/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.token;

import com.tonbeller.tbutils.res.Resources;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.controller.RequestContextFactoryFinder;
import com.tonbeller.wcf.statusline.StatusLine;
import com.tonbeller.wcf.token.RequestToken;
import java.io.IOException;
import java.util.Random;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class TokenFilter
implements Filter {
    private String httpParameterName;
    private boolean showMessage;
    private static Random random = new Random();
    private static final Logger logger = Logger.getLogger(TokenFilter.class);
    private static ThreadLocal threadLocal = new ThreadLocal();

    public void init(FilterConfig config) throws ServletException {
        this.httpParameterName = config.getInitParameter("token");
        if (this.httpParameterName == null) {
            this.httpParameterName = "token";
        }
        this.showMessage = "true".equals(config.getInitParameter("showMessage"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (threadLocal.get() != null) {
            chain.doFilter(req, res);
            return;
        }
        try {
            threadLocal.set(Boolean.TRUE);
            HttpServletRequest request = (HttpServletRequest)req;
            HttpServletResponse response = (HttpServletResponse)res;
            String token = request.getParameter(this.httpParameterName);
            RequestToken s = RequestToken.instance(request.getSession(true));
            s.setHttpParameterName(this.httpParameterName);
            if (token != null && s.getToken() != null && !token.equals(s.getToken())) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("redirecting to " + s.getPage()));
                }
                response.sendRedirect(s.getPage());
                if (this.showMessage) {
                    RequestContext context = RequestContextFactoryFinder.createContext(request, response, false);
                    Resources resources = Resources.instance();
                    if (resources == null) {
                        resources = context.getResources(TokenFilter.class);
                    }
                    String message = resources.getString("jsp.wcf.token.browser.navigation");
                    StatusLine.instance(context.getSession()).setMessage(message);
                }
                return;
            }
            Random random = TokenFilter.random;
            synchronized (random) {
                s.setToken(Integer.toHexString(TokenFilter.random.nextInt()));
                s.setPage(request.getRequestURI());
            }
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            threadLocal.set(null);
        }
    }

    public void destroy() {
    }
}

