/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.irplugin.gui;

import com.jaspersoft.jasperserver.irplugin.IRPlugin;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ValidationUtils {
    public static final int MAX_LENGTH_NAME = 30;
    public static final int MAX_LENGTH_LABEL = 30;
    public static final int MAX_LENGTH_DESC = 100;
    private static final Pattern PATTERN_NAME = Pattern.compile("(\\p{L}|\\p{N}|(\\_)|(\\.)|(\\-)|[;@])+");

    static void validateName(String name) throws Exception {
        if (name == null || name.length() == 0) {
            throw new Exception(IRPlugin.getString("resource.name.isEmpty", "The name can not be empty"));
        }
        Matcher mat = PATTERN_NAME.matcher(name.trim());
        if (!mat.matches()) {
            throw new Exception(IRPlugin.getString("resource.name.invalidCharacters", "The name contains invalid characters"));
        }
        if (name.trim().length() > 30) {
            throw new Exception(IRPlugin.getFormattedString("resource.name.tooLong", "The name can not be longer than {0,integer} characters", new Object[]{new Integer(30)}));
        }
    }

    static void validateLabel(String name) throws Exception {
        if (name == null || name.length() == 0) {
            throw new Exception(IRPlugin.getString("resource.label.isEmpty", "The label can not be empty"));
        }
        if (name.trim().length() > 30) {
            throw new Exception(IRPlugin.getFormattedString("resource.label.tooLong", "The label can not be longer than {0,integer} characters", new Object[]{new Integer(30)}));
        }
    }

    static void validateDesc(String name) throws Exception {
        if (name != null && name.trim().length() > 100) {
            throw new Exception(IRPlugin.getFormattedString("resource.desc.tooLong", "The description can not be longer than characters", new Object[]{new Integer(100)}));
        }
    }
}

