/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.plugin;

import com.liferay.portal.kernel.plugin.PluginPackage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class RemotePluginPackageRepository {
    public static final String LOCAL_URL = "LOCAL_URL";
    public static final String SETTING_USE_DOWNLOAD_URL = "use-download-url";
    private String _repositoryURL;
    private Map _artifactURLIndex;
    private Map _moduleIdIndex;
    private Map _groupAndArtifactIndex;
    private List _pluginPackages;
    private Properties _settings;
    private Set _tags;

    public String getRepositoryURL() {
        return this._repositoryURL;
    }

    public List getPluginPackages() {
        return this._pluginPackages;
    }

    public Properties getSettings() {
        return this._settings;
    }

    public void setSettings(Properties settings) {
        this._settings = settings;
    }

    public Set getTags() {
        return this._tags;
    }

    public void addPluginPackage(PluginPackage pluginPackage) {
        PluginPackage existingPackage = (PluginPackage)this._moduleIdIndex.get(pluginPackage.getModuleId());
        if (existingPackage != null) {
            return;
        }
        this._artifactURLIndex.put(pluginPackage.getArtifactURL(), pluginPackage);
        this._moduleIdIndex.put(pluginPackage.getModuleId(), pluginPackage);
        this._addToGroupAndArtifactIndex(pluginPackage.getGroupId(), pluginPackage.getArtifactId(), pluginPackage);
        this._pluginPackages.add(pluginPackage);
        this._tags.addAll(pluginPackage.getTags());
    }

    public PluginPackage findPluginByArtifactURL(String artifactURL) {
        return (PluginPackage)this._artifactURLIndex.get(artifactURL);
    }

    public PluginPackage findPluginPackageByModuleId(String moduleId) {
        return (PluginPackage)this._moduleIdIndex.get(moduleId);
    }

    public List findPluginsByGroupIdAndArtifactId(String groupId, String artifactId) {
        return (List)this._groupAndArtifactIndex.get(groupId + '/' + artifactId);
    }

    public void removePlugin(PluginPackage pluginPackage) {
        this._artifactURLIndex.remove(pluginPackage.getArtifactURL());
        this._moduleIdIndex.remove(pluginPackage.getModuleId());
        this._removeFromGroupAndArtifactIndex(pluginPackage.getGroupId(), pluginPackage.getArtifactId(), pluginPackage.getModuleId());
        this._pluginPackages.remove(pluginPackage);
    }

    private final void _addToGroupAndArtifactIndex(String groupId, String artifactId, PluginPackage pluginPackage) {
        ArrayList<PluginPackage> plugins = this.findPluginsByGroupIdAndArtifactId(groupId, artifactId);
        if (plugins == null) {
            plugins = new ArrayList<PluginPackage>();
            this._groupAndArtifactIndex.put(groupId + '/' + artifactId, plugins);
        }
        plugins.add(pluginPackage);
    }

    private final void _removeFromGroupAndArtifactIndex(String groupId, String artifactId, String moduleId) {
        List plugins = this.findPluginsByGroupIdAndArtifactId(groupId, artifactId);
        if (plugins != null) {
            Iterator itr = plugins.iterator();
            while (itr.hasNext()) {
                PluginPackage pluginPackage = (PluginPackage)itr.next();
                if (!pluginPackage.getModuleId().equals(moduleId)) continue;
                itr.remove();
                break;
            }
        }
    }

    private final /* synthetic */ void this() {
        this._artifactURLIndex = new HashMap();
        this._moduleIdIndex = new HashMap();
        this._groupAndArtifactIndex = new HashMap();
        this._pluginPackages = new ArrayList();
        this._settings = null;
        this._tags = new TreeSet();
    }

    public RemotePluginPackageRepository(String repositoryURL) {
        this.this();
        this._repositoryURL = repositoryURL;
    }
}

