/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.ui;

import com.tonbeller.wcf.format.FormatException;
import com.tonbeller.wcf.format.FormatHandler;
import com.tonbeller.wcf.format.Formatter;
import com.tonbeller.wcf.ui.TypedCtrl;
import com.tonbeller.wcf.ui.XoplonCtrl;
import com.tonbeller.wcf.utils.XoplonNS;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class EditCtrl
extends TypedCtrl {
    public static void setValue(Element element, String value) {
        XoplonNS.setAttribute(element, "value", value);
    }

    public static String getValue(Element element) {
        return XoplonNS.getAttribute(element, "value");
    }

    public static void setMaxLength(Element element, int maxLength) {
        XoplonNS.setAttribute(element, "maxlength", String.valueOf(maxLength));
    }

    public static int getMaxLength(Element element) {
        return Integer.parseInt(XoplonNS.getAttribute(element, "maxlength"));
    }

    protected static Element createValueHolder(Document doc, String tagName, String type) {
        Element retVal = XoplonCtrl.createCtrl(doc, tagName);
        XoplonNS.setAttribute(retVal, "type", type);
        return retVal;
    }

    protected static Element createValueHolder(Document doc, String tagName) {
        return EditCtrl.createValueHolder(doc, tagName, "string");
    }

    public static void setValue(Formatter formatter, Element element, Object value) throws FormatException {
        FormatHandler formatHandler = formatter.getHandler(EditCtrl.getType(element));
        String formatString = EditCtrl.getFormatString(element);
        String valueString = formatHandler.format(value, formatString);
        XoplonNS.setAttribute(element, "value", valueString);
    }

    public static Object getValue(Formatter formatter, Element element) throws FormatException {
        String className = EditCtrl.getType(element);
        FormatHandler parser = formatter.getHandler(className);
        String formatString = EditCtrl.getFormatString(element);
        return parser.parse(XoplonNS.getAttribute(element, "value"), formatString);
    }

    public static boolean getBoolean(Formatter fmt, Element elem) throws FormatException {
        return (Boolean)EditCtrl.getValue(fmt, elem);
    }

    public static int getInt(Formatter fmt, Element elem) throws FormatException {
        return ((Number)EditCtrl.getValue(fmt, elem)).intValue();
    }

    public static double getDouble(Formatter fmt, Element elem) throws FormatException {
        return ((Number)EditCtrl.getValue(fmt, elem)).doubleValue();
    }

    public static Date getDate(Formatter fmt, Element elem) throws FormatException {
        return (Date)EditCtrl.getValue(fmt, elem);
    }

    public static String getString(Formatter fmt, Element elem) throws FormatException {
        return EditCtrl.getValue(elem);
    }

    public static void setBoolean(Formatter fmt, Element elem, boolean value) throws FormatException {
        EditCtrl.setValue(fmt, elem, new Boolean(value));
    }

    public static void setInt(Formatter fmt, Element elem, int value) throws FormatException {
        EditCtrl.setValue(fmt, elem, new Integer(value));
    }

    public static void setDouble(Formatter fmt, Element elem, double value) throws FormatException {
        EditCtrl.setValue(fmt, elem, new Double(value));
    }

    public static void setDate(Formatter fmt, Element elem, Date value) throws FormatException {
        EditCtrl.setValue(fmt, elem, value);
    }

    public static void setString(Formatter fmt, Element elem, String value) throws FormatException {
        EditCtrl.setValue(elem, value);
    }
}

