/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.param;

import com.tonbeller.wcf.expr.ExprUtils;
import com.tonbeller.wcf.param.SessionParam;
import com.tonbeller.wcf.param.SessionParamPool;
import com.tonbeller.wcf.param.SqlExpr;
import com.tonbeller.wcf.param.SqlGenerator;
import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.log4j.Logger;

public class ParamSqlTag
extends TagSupport {
    String paramName;
    String qname;
    SqlGenerator sg;
    private static Logger logger = Logger.getLogger((Class)ParamSqlTag.class);

    public int doStartTag() throws JspException {
        this.sg = this.createSqlGenerator();
        if (this.qname != null) {
            this.sg.getColumnMap().put("DEFAULT_COLUMN_ID", this.qname);
        }
        return 1;
    }

    public void setMapping(String columnId, String qname) {
        this.sg.getColumnMap().put(columnId, qname);
    }

    public int doEndTag() throws JspException {
        SessionParam param;
        if (ExprUtils.isExpression(this.paramName)) {
            Object obj = ExprUtils.getModelReference(this.pageContext, this.paramName);
            this.paramName = String.valueOf(obj);
        }
        if ((param = SessionParamPool.instance(this.pageContext).getParam(this.paramName)) == null) {
            throw new JspException("SessionParam " + this.paramName + " not found");
        }
        SqlExpr ex = param.getSqlExpr();
        JspWriter out = this.pageContext.getOut();
        try {
            out.print(this.sg.generate(ex));
        }
        catch (IOException e) {
            logger.error(null, (Throwable)e);
        }
        return 6;
    }

    protected SqlGenerator createSqlGenerator() {
        return new SqlGenerator();
    }

    public void setQname(String qname) {
        this.qname = qname;
    }

    public void setParam(String paramName) {
        this.paramName = paramName;
    }
}

