/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.form;

import com.tonbeller.wcf.component.Component;
import com.tonbeller.wcf.component.ComponentSupport;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.form.NodeHandler;
import com.tonbeller.wcf.ui.XoplonCtrl;
import com.tonbeller.wcf.utils.DomUtils;
import com.tonbeller.wcf.utils.SoftException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.jaxen.JaxenException;
import org.jaxen.dom.DOMXPath;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlComponent
extends ComponentSupport {
    private static Logger logger = Logger.getLogger((Class)XmlComponent.class);
    Document document;
    Map elementHandlerMap;
    Map idHandlerMap;
    Map handlerElementMap;

    public XmlComponent(String id, Component parent, Document document) {
        super(id, parent);
        this.document = document;
    }

    public void initialize(RequestContext context) throws Exception {
        super.initialize(context);
        this.hideSecuredElements(context, this.document);
        this.installNodeHandlers(context, this.document);
    }

    public void destroy(HttpSession session) throws Exception {
        Iterator it = this.elementHandlerMap.values().iterator();
        while (it.hasNext()) {
            NodeHandler nh = (NodeHandler)it.next();
            nh.destroy(session);
        }
        super.destroy(session);
    }

    public Document render(RequestContext context) throws Exception {
        Iterator it = this.elementHandlerMap.values().iterator();
        while (it.hasNext()) {
            NodeHandler nh = (NodeHandler)it.next();
            nh.render(context);
        }
        return this.document;
    }

    void installNodeHandlers(RequestContext context, Document root) throws Exception {
        try {
            this.elementHandlerMap = new HashMap();
            this.handlerElementMap = new HashMap();
            this.idHandlerMap = new HashMap();
            List elements = this.findHandlerElements(root);
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                Element elem = (Element)it.next();
                String clazz = elem.getAttribute("handler");
                NodeHandler nh = (NodeHandler)Class.forName(clazz).newInstance();
                nh.initialize(context, this, elem);
                this.elementHandlerMap.put(elem, nh);
                this.handlerElementMap.put(nh, elem);
                this.idHandlerMap.put(elem.getAttribute("id"), nh);
            }
        }
        catch (JaxenException e) {
            logger.error(null, (Throwable)e);
            throw new SoftException(e);
        }
        catch (InstantiationException e) {
            logger.error(null, (Throwable)e);
            throw new SoftException(e);
        }
        catch (IllegalAccessException e) {
            logger.error(null, (Throwable)e);
            throw new SoftException(e);
        }
        catch (ClassNotFoundException e) {
            logger.error(null, (Throwable)e);
            throw new SoftException(e);
        }
    }

    private List findHandlerElements(Document root) throws JaxenException {
        this.installDefaultHandler(root, "//xtree", "com.tonbeller.wcf.tree.TreeHandler");
        this.installDefaultHandler(root, "//xtable", "com.tonbeller.wcf.table.TableHandler");
        this.installDefaultHandler(root, "//xtabbed", "com.tonbeller.wcf.tabbed.TabbedHandler");
        this.installDefaultHandler(root, "//button", "com.tonbeller.wcf.form.ButtonHandler");
        this.installDefaultHandler(root, "//imgButton", "com.tonbeller.wcf.form.ButtonHandler");
        DOMXPath xp = new DOMXPath("//*[@handler]");
        return xp.selectNodes((Object)root);
    }

    private void installDefaultHandler(Document root, String xpath, String clazz) throws JaxenException {
        DOMXPath xp = new DOMXPath(xpath);
        List list = xp.selectNodes((Object)root);
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Element e = (Element)it.next();
            if (e.getAttribute("handler").length() != 0 || e.getAttribute("actionReference").length() != 0) continue;
            e.setAttribute("handler", clazz);
        }
    }

    void hideSecuredElements(RequestContext context, Document root) throws Exception {
        HttpServletRequest req = context.getRequest();
        try {
            DOMXPath xp = new DOMXPath("//*[@role]");
            List elements = xp.selectNodes((Object)root);
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                Element elem = (Element)it.next();
                String role = elem.getAttribute("role");
                if (context.isUserInRole(role)) {
                    XoplonCtrl.setHidden(elem, false);
                    continue;
                }
                XoplonCtrl.setHidden(elem, true);
            }
        }
        catch (JaxenException e) {
            logger.error(null, (Throwable)e);
            throw new SoftException(e);
        }
    }

    public NodeHandler getParent(NodeHandler handler) {
        Element elem = (Element)this.handlerElementMap.get(handler);
        Node node = elem.getParentNode();
        while (node.getNodeType() == 1) {
            NodeHandler h = (NodeHandler)this.elementHandlerMap.get(node);
            if (h != null) {
                return h;
            }
            node = node.getParentNode();
        }
        return null;
    }

    List getHandlers(NodeHandler rootHandler, String xpathExpr) {
        try {
            ArrayList<NodeHandler> handlerList = new ArrayList<NodeHandler>();
            DOMXPath xp = new DOMXPath(xpathExpr);
            Element rootElem = (Element)this.handlerElementMap.get(rootHandler);
            List elements = xp.selectNodes((Object)rootElem);
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                Element element = (Element)it.next();
                NodeHandler handler = (NodeHandler)this.elementHandlerMap.get(element);
                if (handler == null) continue;
                handlerList.add(handler);
            }
            return handlerList;
        }
        catch (JaxenException e) {
            logger.error(null, (Throwable)e);
            throw new SoftException(e);
        }
    }

    public List getChildren(NodeHandler handler) {
        return this.getHandlers(handler, ".//*[@handler]");
    }

    public Document getDocument() {
        return this.document;
    }

    public NodeHandler getHandler(Element element) {
        return (NodeHandler)this.elementHandlerMap.get(element);
    }

    public NodeHandler getHandler(String id) {
        return (NodeHandler)this.idHandlerMap.get(id);
    }

    public Element getElement(NodeHandler handler) {
        return (Element)this.handlerElementMap.get(handler);
    }

    public Element getElement(String id) {
        return DomUtils.findElementWithId(id, this.document.getDocumentElement());
    }
}

