/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.wcf.convert;

import com.tonbeller.wcf.convert.Converter;
import com.tonbeller.wcf.format.Formatter;
import com.tonbeller.wcf.utils.ObjectFactory;
import com.tonbeller.wcf.utils.SoftException;
import java.io.IOException;
import java.net.URL;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class ConverterFactory {
    private static Logger logger = Logger.getLogger((Class)ConverterFactory.class);

    private ConverterFactory() {
    }

    public static Converter instance(Formatter formatter) {
        URL configXml = ConverterFactory.class.getResource("config.xml");
        return ConverterFactory.instance(formatter, configXml);
    }

    public static Converter instance(Formatter formatter, URL configXml) {
        try {
            URL rulesXml = ConverterFactory.class.getResource("rules.xml");
            Converter conv = (Converter)ObjectFactory.instance(rulesXml, configXml);
            conv.setFormatter(formatter);
            return conv;
        }
        catch (SAXException e) {
            logger.error((Object)"?", (Throwable)e);
            throw new SoftException(e);
        }
        catch (IOException e) {
            logger.error((Object)"?", (Throwable)e);
            throw new SoftException(e);
        }
    }
}

