/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.driver.xmla.proxy;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.concurrent.Future;
import org.olap4j.OlapException;
import org.olap4j.driver.xmla.XmlaOlap4jDriver;
import org.olap4j.driver.xmla.cache.XmlaOlap4jCache;
import org.olap4j.driver.xmla.proxy.XmlaOlap4jCachedProxy;
import org.olap4j.driver.xmla.proxy.XmlaOlap4jCookieManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XmlaOlap4jAbstractHttpProxy
implements XmlaOlap4jCachedProxy {
    private XmlaOlap4jCache cache = null;
    private String cacheId;
    private XmlaOlap4jCookieManager cookieManager = null;

    public abstract byte[] getResponse(URL var1, String var2) throws IOException;

    public abstract Future<byte[]> getResponseViaSubmit(URL var1, String var2);

    protected void useCookies(URLConnection urlConn) throws IOException {
        this.initCookieManager();
        this.cookieManager.setCookies(urlConn);
    }

    protected void saveCookies(URLConnection urlConn) throws IOException {
        this.initCookieManager();
        this.cookieManager.storeCookies(urlConn);
    }

    @Override
    public void setCache(Map<String, String> config, Map<String, String> properties) throws OlapException {
        try {
            Class<?> clazz = Class.forName(config.get(XmlaOlap4jDriver.Property.Cache.name()));
            this.cache = (XmlaOlap4jCache)clazz.newInstance();
            this.cacheId = this.cache.setParameters(config, properties);
        }
        catch (ClassNotFoundException e) {
            throw new OlapException("The specified cache class name could not be found : " + config.get(XmlaOlap4jDriver.Property.Cache.name()), e);
        }
        catch (InstantiationException e) {
            throw new OlapException("The specified cache class name could not be instanciated : " + config.get(XmlaOlap4jDriver.Property.Cache.name()), e);
        }
        catch (IllegalAccessException e) {
            throw new OlapException("An error was encountered while instanciating the cache : " + config.get(XmlaOlap4jDriver.Property.Cache.name()), e);
        }
        catch (IllegalArgumentException e) {
            throw new OlapException("An error was encountered while instanciating the cache : " + config.get(XmlaOlap4jDriver.Property.Cache.name()), e);
        }
        catch (SecurityException e) {
            throw new OlapException("An error was encountered while instanciating the cache : " + config.get(XmlaOlap4jDriver.Property.Cache.name()), e);
        }
    }

    @Override
    public byte[] get(URL url, String request) throws IOException {
        byte[] response = this.getFromCache(url, request.getBytes(this.getEncodingCharsetName()));
        if (response != null) {
            return response;
        }
        response = this.getResponse(url, request);
        this.addToCache(url, request.getBytes(this.getEncodingCharsetName()), response);
        return response;
    }

    private byte[] getFromCache(URL url, byte[] request) {
        return this.cache != null ? this.cache.get(this.cacheId, url, request) : null;
    }

    private void addToCache(URL url, byte[] request, byte[] response) {
        if (this.cache != null) {
            this.cache.put(this.cacheId, url, request, response);
        }
    }

    @Override
    public Future<byte[]> submit(URL url, String request) {
        return this.getResponseViaSubmit(url, request);
    }

    private void initCookieManager() {
        if (this.cookieManager == null) {
            this.cookieManager = new XmlaOlap4jCookieManager();
        }
    }
}

