/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.driver.xmla;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.olap4j.OlapException;
import org.olap4j.driver.xmla.XmlaOlap4jCatalog;
import org.olap4j.driver.xmla.XmlaOlap4jConnection;
import org.olap4j.driver.xmla.XmlaOlap4jCube;
import org.olap4j.driver.xmla.XmlaOlap4jDimension;
import org.olap4j.driver.xmla.XmlaOlap4jElement;
import org.olap4j.driver.xmla.XmlaOlap4jHierarchy;
import org.olap4j.driver.xmla.XmlaOlap4jLevel;
import org.olap4j.impl.ArrayMap;
import org.olap4j.impl.Named;
import org.olap4j.impl.NamedListImpl;
import org.olap4j.mdx.ParseTreeNode;
import org.olap4j.metadata.Member;
import org.olap4j.metadata.NamedList;
import org.olap4j.metadata.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class XmlaOlap4jMember
extends XmlaOlap4jElement
implements Member,
Named {
    private final XmlaOlap4jLevel olap4jLevel;
    private final String parentMemberUniqueName;
    private final Member.Type type;
    private XmlaOlap4jMember parentMember;
    private final int childMemberCount;
    private final int ordinal;
    private final ArrayMap<Property, Object> propertyValueMap = new ArrayMap();

    XmlaOlap4jMember(XmlaOlap4jLevel olap4jLevel, String uniqueName, String name, String caption, String description, String parentMemberUniqueName, Member.Type type, int childMemberCount, int ordinal) {
        super(uniqueName, name, caption, description);
        this.ordinal = ordinal;
        assert (olap4jLevel != null);
        assert (type != null);
        this.olap4jLevel = olap4jLevel;
        this.parentMemberUniqueName = parentMemberUniqueName;
        this.type = type;
        this.childMemberCount = childMemberCount;
    }

    public int hashCode() {
        return this.uniqueName.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof XmlaOlap4jMember && ((XmlaOlap4jMember)obj).uniqueName.equals(this.uniqueName);
    }

    @Override
    public NamedList<? extends Member> getChildMembers() throws OlapException {
        NamedListImpl<XmlaOlap4jMember> list = new NamedListImpl<XmlaOlap4jMember>();
        this.getCube().getMetadataReader().lookupMemberRelatives(EnumSet.of(Member.TreeOp.CHILDREN), this.uniqueName, list);
        return list;
    }

    @Override
    public int getChildMemberCount() {
        return this.childMemberCount;
    }

    @Override
    public XmlaOlap4jMember getParentMember() {
        if (this.parentMemberUniqueName == null) {
            return null;
        }
        if (this.parentMember == null) {
            try {
                this.parentMember = this.getCube().getMetadataReader().lookupMemberByUniqueName(this.parentMemberUniqueName);
            }
            catch (OlapException e) {
                throw new RuntimeException("yuck!");
            }
        }
        return this.parentMember;
    }

    @Override
    public XmlaOlap4jLevel getLevel() {
        return this.olap4jLevel;
    }

    @Override
    public XmlaOlap4jHierarchy getHierarchy() {
        return this.olap4jLevel.olap4jHierarchy;
    }

    @Override
    public XmlaOlap4jDimension getDimension() {
        return this.olap4jLevel.olap4jHierarchy.olap4jDimension;
    }

    @Override
    public Member.Type getMemberType() {
        return this.type;
    }

    @Override
    public boolean isAll() {
        return this.type == Member.Type.ALL;
    }

    @Override
    public boolean isChildOrEqualTo(Member member) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isCalculated() {
        return this.type == Member.Type.FORMULA;
    }

    @Override
    public int getSolveOrder() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ParseTreeNode getExpression() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Member> getAncestorMembers() {
        ArrayList<Member> list = new ArrayList<Member>();
        for (XmlaOlap4jMember m = this.getParentMember(); m != null; m = m.getParentMember()) {
            list.add(m);
        }
        return list;
    }

    @Override
    public boolean isCalculatedInQuery() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getPropertyValue(Property property) {
        Object value = this.propertyValueMap.get(property);
        if (value != null || this.propertyValueMap.containsKey(property)) {
            return value;
        }
        if (property instanceof Property.StandardMemberProperty) {
            Property.StandardMemberProperty o = (Property.StandardMemberProperty)property;
            switch (o) {
                case MEMBER_CAPTION: {
                    return this.getCaption(this.getConnection().getLocale());
                }
                case MEMBER_NAME: {
                    return this.getName();
                }
                case MEMBER_UNIQUE_NAME: {
                    return this.getUniqueName();
                }
                case CATALOG_NAME: {
                    return this.getCatalog().getName();
                }
                case CHILDREN_CARDINALITY: {
                    return this.getChildMemberCount();
                }
                case CUBE_NAME: {
                    return this.getCube().getName();
                }
                case DEPTH: {
                    return this.getDepth();
                }
                case DESCRIPTION: {
                    return this.getDescription(this.getConnection().getLocale());
                }
                case DIMENSION_UNIQUE_NAME: {
                    return this.getDimension().getUniqueName();
                }
                case DISPLAY_INFO: {
                    return null;
                }
                case HIERARCHY_UNIQUE_NAME: {
                    return this.getHierarchy().getUniqueName();
                }
                case LEVEL_NUMBER: {
                    return this.getLevel().getDepth();
                }
                case LEVEL_UNIQUE_NAME: {
                    return this.getLevel().getUniqueName();
                }
                case MEMBER_GUID: {
                    return null;
                }
                case MEMBER_ORDINAL: {
                    return this.getOrdinal();
                }
                case MEMBER_TYPE: {
                    return this.getMemberType();
                }
                case PARENT_COUNT: {
                    return 1;
                }
                case PARENT_LEVEL: {
                    return this.getParentMember().getLevel().getDepth();
                }
                case PARENT_UNIQUE_NAME: {
                    return this.getParentMember().getUniqueName();
                }
                case SCHEMA_NAME: {
                    return this.getCube().olap4jSchema.getName();
                }
                case VALUE: {
                    return null;
                }
            }
        }
        return null;
    }

    private XmlaOlap4jCube getCube() {
        return this.olap4jLevel.olap4jHierarchy.olap4jDimension.olap4jCube;
    }

    private XmlaOlap4jCatalog getCatalog() {
        return this.olap4jLevel.olap4jHierarchy.olap4jDimension.olap4jCube.olap4jSchema.olap4jCatalog;
    }

    private XmlaOlap4jConnection getConnection() {
        return this.olap4jLevel.olap4jHierarchy.olap4jDimension.olap4jCube.olap4jSchema.olap4jCatalog.olap4jDatabaseMetaData.olap4jConnection;
    }

    @Override
    public String getPropertyFormattedValue(Property property) {
        return String.valueOf(this.getPropertyValue(property));
    }

    @Override
    public void setProperty(Property property, Object value) throws OlapException {
        this.propertyValueMap.put(property, value);
    }

    @Override
    public NamedList<Property> getProperties() {
        return this.olap4jLevel.getProperties();
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public boolean isHidden() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getDepth() {
        return this.olap4jLevel.getDepth();
    }

    @Override
    public Member getDataMember() {
        throw new UnsupportedOperationException();
    }
}

