/*
 * Decompiled with CFR 0.152.
 */
package mondrian.xmla;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.sql.DataSource;
import mondrian.calc.ResultStyle;
import mondrian.olap.Axis;
import mondrian.olap.Cell;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.DriverManager;
import mondrian.olap.Evaluator;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Position;
import mondrian.olap.Property;
import mondrian.olap.Query;
import mondrian.olap.QueryAxis;
import mondrian.olap.Result;
import mondrian.olap.Role;
import mondrian.olap.Util;
import mondrian.rolap.RolapAggregationManager;
import mondrian.rolap.RolapConnection;
import mondrian.rolap.RolapConnectionProperties;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.SqlStatement;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.sql.SqlQuery;
import mondrian.spi.CatalogLocator;
import mondrian.xmla.DataSourcesConfig;
import mondrian.xmla.Enumeration;
import mondrian.xmla.PropertyDefinition;
import mondrian.xmla.Rowset;
import mondrian.xmla.RowsetDefinition;
import mondrian.xmla.SaxWriter;
import mondrian.xmla.XmlaConstants;
import mondrian.xmla.XmlaException;
import mondrian.xmla.XmlaRequest;
import mondrian.xmla.XmlaResponse;
import mondrian.xmla.XmlaUtil;
import mondrian.xmla.impl.DefaultSaxWriter;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlaHandler
implements XmlaConstants {
    private static final Logger LOGGER = Logger.getLogger(XmlaHandler.class);
    private final Map<String, DataSourcesConfig.DataSource> dataSourcesMap;
    private final List<String> drillThruColumnNames = new ArrayList<String>();
    private final CatalogLocator catalogLocator;
    private final String prefix;
    private static final String EMPTY_ROW_SET_XML_SCHEMA = XmlaHandler.computeEmptyXsd(SetType.ROW_SET);
    private static final String MD_DATA_SET_XML_SCHEMA = XmlaHandler.computeXsd(SetType.MD_DATA_SET);
    private static final String EMPTY_MD_DATA_SET_XML_SCHEMA = XmlaHandler.computeEmptyXsd(SetType.MD_DATA_SET);
    private static final String NS_XML_SQL = "urn:schemas-microsoft-com:xml-sql";
    public static final String XSD_BOOLEAN = "xsd:boolean";
    public static final String XSD_STRING = "xsd:string";
    public static final String XSD_UNSIGNED_INT = "xsd:unsignedInt";
    public static final String XSD_BYTE = "xsd:byte";
    public static final byte XSD_BYTE_MAX_INCLUSIVE = 127;
    public static final byte XSD_BYTE_MIN_INCLUSIVE = -128;
    public static final String XSD_SHORT = "xsd:short";
    public static final short XSD_SHORT_MAX_INCLUSIVE = Short.MAX_VALUE;
    public static final short XSD_SHORT_MIN_INCLUSIVE = Short.MIN_VALUE;
    public static final String XSD_INT = "xsd:int";
    public static final int XSD_INT_MAX_INCLUSIVE = Integer.MAX_VALUE;
    public static final int XSD_INT_MIN_INCLUSIVE = Integer.MIN_VALUE;
    public static final String XSD_LONG = "xsd:long";
    public static final long XSD_LONG_MAX_INCLUSIVE = Long.MAX_VALUE;
    public static final long XSD_LONG_MIN_INCLUSIVE = Long.MIN_VALUE;
    public static final String XSD_DOUBLE = "xsd:double";
    public static final String XSD_DECIMAL = "xsd:decimal";
    public static final String XSD_INTEGER = "xsd:integer";

    public static boolean isValidXsdInt(long l) {
        return l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE;
    }

    private static String computeXsd(SetType setType) {
        StringWriter sw = new StringWriter();
        DefaultSaxWriter writer = new DefaultSaxWriter(new PrintWriter(sw), 3);
        XmlaHandler.writeDatasetXmlSchema(writer, setType);
        writer.flush();
        return sw.toString();
    }

    private static String computeEmptyXsd(SetType setType) {
        StringWriter sw = new StringWriter();
        DefaultSaxWriter writer = new DefaultSaxWriter(new PrintWriter(sw), 3);
        XmlaHandler.writeEmptyDatasetXmlSchema(writer, setType);
        writer.flush();
        return sw.toString();
    }

    public XmlaHandler(DataSourcesConfig.DataSources dataSources, CatalogLocator catalogLocator, String prefix) {
        this.catalogLocator = catalogLocator;
        assert (prefix != null);
        this.prefix = prefix;
        HashMap<String, DataSourcesConfig.DataSource> map = new HashMap<String, DataSourcesConfig.DataSource>();
        if (dataSources != null) {
            for (DataSourcesConfig.DataSource ds : dataSources.dataSources) {
                if (map.containsKey(ds.getDataSourceName())) {
                    throw Util.newError("duplicated data source name '" + ds.getDataSourceName() + "'");
                }
                for (DataSourcesConfig.Catalog catalog : ds.catalogs.catalogs) {
                    catalog.setDataSource(ds);
                }
                map.put(ds.getDataSourceName(), ds);
            }
        }
        this.dataSourcesMap = Collections.unmodifiableMap(map);
    }

    public Map<String, DataSourcesConfig.DataSource> getDataSourceEntries() {
        return this.dataSourcesMap;
    }

    public void process(XmlaRequest request, XmlaResponse response) throws XmlaException {
        int method = request.getMethod();
        long start = System.currentTimeMillis();
        switch (method) {
            case 1: {
                this.discover(request, response);
                break;
            }
            case 2: {
                this.execute(request, response);
                break;
            }
            default: {
                throw new XmlaException("Client", "00HSBB02", "XMLA SOAP bad method", new IllegalArgumentException("Unsupported XML/A method: " + method));
            }
        }
        if (LOGGER.isDebugEnabled()) {
            long end = System.currentTimeMillis();
            LOGGER.debug((Object)("XmlaHandler.process: time = " + (end - start)));
            LOGGER.debug((Object)("XmlaHandler.process: " + Util.printMemory()));
        }
    }

    private void checkFormat(XmlaRequest request) throws XmlaException {
        Map<String, String> properties = request.getProperties();
        if (request.isDrillThrough()) {
            String formatName = properties.get(PropertyDefinition.Format.name());
            Enumeration.Format format = this.valueOf(Enumeration.Format.class, formatName, null);
            if (format != Enumeration.Format.Tabular) {
                throw new XmlaException("Client", "00HSBE02", "XMLA Drill Through format error", new UnsupportedOperationException("<Format>: only 'Tabular' allowed when drilling through"));
            }
        } else {
            Enumeration.AxisFormat axisFormat;
            Enumeration.Format format;
            String formatName = properties.get(PropertyDefinition.Format.name());
            if (formatName != null && (format = (Enumeration.Format)this.valueOf(Enumeration.Format.class, formatName, null)) != Enumeration.Format.Multidimensional && format != Enumeration.Format.Tabular) {
                throw new UnsupportedOperationException("<Format>: only 'Multidimensional', 'Tabular' currently supported");
            }
            String axisFormatName = properties.get(PropertyDefinition.AxisFormat.name());
            if (axisFormatName != null && (axisFormat = (Enumeration.AxisFormat)this.valueOf(Enumeration.AxisFormat.class, axisFormatName, null)) != Enumeration.AxisFormat.TupleFormat) {
                throw new UnsupportedOperationException("<AxisFormat>: only 'TupleFormat' currently supported");
            }
        }
    }

    private void execute(XmlaRequest request, XmlaResponse response) throws XmlaException {
        String tabFields;
        Map<String, String> properties = request.getProperties();
        String contentName = properties.get(PropertyDefinition.Content.name());
        Enumeration.Content content = this.valueOf(Enumeration.Content.class, contentName, CONTENT_DEFAULT);
        QueryResult result = request.isDrillThrough() ? ((tabFields = properties.get(PropertyDefinition.TableFields.name())) != null && tabFields.length() > 0 ? this.executeColumnQuery(request) : this.executeDrillThroughQuery(request)) : this.executeQuery(request);
        SaxWriter writer = response.getWriter();
        writer.startDocument();
        writer.startElement(this.prefix + ":ExecuteResponse", new String[]{"xmlns:" + this.prefix, "urn:schemas-microsoft-com:xml-analysis"});
        writer.startElement(this.prefix + ":return");
        boolean rowset = request.isDrillThrough() || Enumeration.Format.Tabular.name().equals(request.getProperties().get(PropertyDefinition.Format.name()));
        writer.startElement("root", new String[]{"xmlns", result == null ? "urn:schemas-microsoft-com:xml-analysis:empty" : (rowset ? "urn:schemas-microsoft-com:xml-analysis:rowset" : "urn:schemas-microsoft-com:xml-analysis:mddataset"), "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema", "xmlns:EX", "urn:schemas-microsoft-com:xml-analysis:exception"});
        if (content == Enumeration.Content.Schema || content == Enumeration.Content.SchemaData) {
            if (result != null) {
                if (result instanceof MDDataSet_Tabular) {
                    MDDataSet_Tabular tabResult = (MDDataSet_Tabular)result;
                    tabResult.metadata(writer);
                } else if (rowset) {
                    ((TabularRowSet)result).metadata(writer);
                } else {
                    writer.verbatim(MD_DATA_SET_XML_SCHEMA);
                }
            } else if (rowset) {
                writer.verbatim(EMPTY_ROW_SET_XML_SCHEMA);
            } else {
                writer.verbatim(EMPTY_MD_DATA_SET_XML_SCHEMA);
            }
        }
        try {
            if ((content == Enumeration.Content.Data || content == Enumeration.Content.SchemaData) && result != null) {
                result.unparse(writer);
            }
        }
        catch (XmlaException xex) {
            throw xex;
        }
        catch (Throwable t) {
            throw new XmlaException("Server", "00HSBE03", "XMLA Execute unparse results error", t);
        }
        finally {
            writer.endElement();
            writer.endElement();
            writer.endElement();
        }
        writer.endDocument();
    }

    static void writeDatasetXmlSchema(SaxWriter writer, SetType settype) {
        String setNsXmla = settype == SetType.ROW_SET ? "urn:schemas-microsoft-com:xml-analysis:rowset" : "urn:schemas-microsoft-com:xml-analysis:mddataset";
        writer.startElement("xsd:schema", new String[]{"xmlns:xsd", "http://www.w3.org/2001/XMLSchema", "targetNamespace", setNsXmla, "xmlns", setNsXmla, "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance", "xmlns:sql", NS_XML_SQL, "elementFormDefault", "qualified"});
        writer.startElement("xsd:complexType", new String[]{"name", "MemberType"});
        writer.startElement("xsd:sequence");
        writer.element("xsd:element", new String[]{"name", "UName", "type", XSD_STRING});
        writer.element("xsd:element", new String[]{"name", "Caption", "type", XSD_STRING});
        writer.element("xsd:element", new String[]{"name", "LName", "type", XSD_STRING});
        writer.element("xsd:element", new String[]{"name", "LNum", "type", XSD_UNSIGNED_INT});
        writer.element("xsd:element", new String[]{"name", "DisplayInfo", "type", XSD_UNSIGNED_INT});
        writer.startElement("xsd:sequence", new String[]{"maxOccurs", "unbounded", "minOccurs", "0"});
        writer.element("xsd:any", new String[]{"processContents", "lax", "maxOccurs", "unbounded"});
        writer.endElement();
        writer.endElement();
        writer.element("xsd:attribute", new String[]{"name", "Hierarchy", "type", XSD_STRING});
        writer.endElement();
        writer.startElement("xsd:complexType", new String[]{"name", "PropType"});
        writer.element("xsd:attribute", new String[]{"name", "name", "type", XSD_STRING});
        writer.endElement();
        writer.startElement("xsd:complexType", new String[]{"name", "TupleType"});
        writer.startElement("xsd:sequence", new String[]{"maxOccurs", "unbounded"});
        writer.element("xsd:element", new String[]{"name", "Member", "type", "MemberType"});
        writer.endElement();
        writer.endElement();
        writer.startElement("xsd:complexType", new String[]{"name", "MembersType"});
        writer.startElement("xsd:sequence", new String[]{"maxOccurs", "unbounded"});
        writer.element("xsd:element", new String[]{"name", "Member", "type", "MemberType"});
        writer.endElement();
        writer.element("xsd:attribute", new String[]{"name", "Hierarchy", "type", XSD_STRING});
        writer.endElement();
        writer.startElement("xsd:complexType", new String[]{"name", "TuplesType"});
        writer.startElement("xsd:sequence", new String[]{"maxOccurs", "unbounded"});
        writer.element("xsd:element", new String[]{"name", "Tuple", "type", "TupleType"});
        writer.endElement();
        writer.endElement();
        writer.startElement("xsd:complexType", new String[]{"name", "CrossProductType"});
        writer.startElement("xsd:sequence");
        writer.startElement("xsd:choice", new String[]{"minOccurs", "0", "maxOccurs", "unbounded"});
        writer.element("xsd:element", new String[]{"name", "Members", "type", "MembersType"});
        writer.element("xsd:element", new String[]{"name", "Tuples", "type", "TuplesType"});
        writer.endElement();
        writer.endElement();
        writer.element("xsd:attribute", new String[]{"name", "Size", "type", XSD_UNSIGNED_INT});
        writer.endElement();
        writer.startElement("xsd:complexType", new String[]{"name", "OlapInfo"});
        writer.startElement("xsd:sequence");
        writer.startElement("xsd:element", new String[]{"name", "CubeInfo"});
        writer.startElement("xsd:complexType");
        writer.startElement("xsd:sequence");
        writer.startElement("xsd:element", new String[]{"name", "Cube", "maxOccurs", "unbounded"});
        writer.startElement("xsd:complexType");
        writer.startElement("xsd:sequence");
        writer.element("xsd:element", new String[]{"name", "CubeName", "type", XSD_STRING});
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.startElement("xsd:element", new String[]{"name", "AxesInfo"});
        writer.startElement("xsd:complexType");
        writer.startElement("xsd:sequence");
        writer.startElement("xsd:element", new String[]{"name", "AxisInfo", "maxOccurs", "unbounded"});
        writer.startElement("xsd:complexType");
        writer.startElement("xsd:sequence");
        writer.startElement("xsd:element", new String[]{"name", "HierarchyInfo", "minOccurs", "0", "maxOccurs", "unbounded"});
        writer.startElement("xsd:complexType");
        writer.startElement("xsd:sequence");
        writer.startElement("xsd:sequence", new String[]{"maxOccurs", "unbounded"});
        writer.element("xsd:element", new String[]{"name", "UName", "type", "PropType"});
        writer.element("xsd:element", new String[]{"name", "Caption", "type", "PropType"});
        writer.element("xsd:element", new String[]{"name", "LName", "type", "PropType"});
        writer.element("xsd:element", new String[]{"name", "LNum", "type", "PropType"});
        writer.element("xsd:element", new String[]{"name", "DisplayInfo", "type", "PropType", "minOccurs", "0", "maxOccurs", "unbounded"});
        writer.endElement();
        writer.startElement("xsd:sequence");
        writer.element("xsd:any", new String[]{"processContents", "lax", "minOccurs", "0", "maxOccurs", "unbounded"});
        writer.endElement();
        writer.endElement();
        writer.element("xsd:attribute", new String[]{"name", "name", "type", XSD_STRING, "use", "required"});
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.element("xsd:attribute", new String[]{"name", "name", "type", XSD_STRING});
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.startElement("xsd:element", new String[]{"name", "CellInfo"});
        writer.startElement("xsd:complexType");
        writer.startElement("xsd:sequence");
        writer.startElement("xsd:sequence", new String[]{"minOccurs", "0", "maxOccurs", "unbounded"});
        writer.startElement("xsd:choice");
        writer.element("xsd:element", new String[]{"name", "Value", "type", "PropType"});
        writer.element("xsd:element", new String[]{"name", "FmtValue", "type", "PropType"});
        writer.element("xsd:element", new String[]{"name", "BackColor", "type", "PropType"});
        writer.element("xsd:element", new String[]{"name", "ForeColor", "type", "PropType"});
        writer.element("xsd:element", new String[]{"name", "FontName", "type", "PropType"});
        writer.element("xsd:element", new String[]{"name", "FontSize", "type", "PropType"});
        writer.element("xsd:element", new String[]{"name", "FontFlags", "type", "PropType"});
        writer.element("xsd:element", new String[]{"name", "FormatString", "type", "PropType"});
        writer.element("xsd:element", new String[]{"name", "NonEmptyBehavior", "type", "PropType"});
        writer.element("xsd:element", new String[]{"name", "SolveOrder", "type", "PropType"});
        writer.element("xsd:element", new String[]{"name", "Updateable", "type", "PropType"});
        writer.element("xsd:element", new String[]{"name", "Visible", "type", "PropType"});
        writer.element("xsd:element", new String[]{"name", "Expression", "type", "PropType"});
        writer.endElement();
        writer.endElement();
        writer.startElement("xsd:sequence", new String[]{"maxOccurs", "unbounded", "minOccurs", "0"});
        writer.element("xsd:any", new String[]{"processContents", "lax", "maxOccurs", "unbounded"});
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.startElement("xsd:complexType", new String[]{"name", "Axes"});
        writer.startElement("xsd:sequence", new String[]{"maxOccurs", "unbounded"});
        writer.startElement("xsd:element", new String[]{"name", "Axis"});
        writer.startElement("xsd:complexType");
        writer.startElement("xsd:choice", new String[]{"minOccurs", "0", "maxOccurs", "unbounded"});
        writer.element("xsd:element", new String[]{"name", "CrossProduct", "type", "CrossProductType"});
        writer.element("xsd:element", new String[]{"name", "Tuples", "type", "TuplesType"});
        writer.element("xsd:element", new String[]{"name", "Members", "type", "MembersType"});
        writer.endElement();
        writer.element("xsd:attribute", new String[]{"name", "name", "type", XSD_STRING});
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.startElement("xsd:complexType", new String[]{"name", "CellData"});
        writer.startElement("xsd:sequence");
        writer.startElement("xsd:element", new String[]{"name", "Cell", "minOccurs", "0", "maxOccurs", "unbounded"});
        writer.startElement("xsd:complexType");
        writer.startElement("xsd:sequence", new String[]{"maxOccurs", "unbounded"});
        writer.startElement("xsd:choice");
        writer.element("xsd:element", new String[]{"name", "Value"});
        writer.element("xsd:element", new String[]{"name", "FmtValue", "type", XSD_STRING});
        writer.element("xsd:element", new String[]{"name", "BackColor", "type", XSD_UNSIGNED_INT});
        writer.element("xsd:element", new String[]{"name", "ForeColor", "type", XSD_UNSIGNED_INT});
        writer.element("xsd:element", new String[]{"name", "FontName", "type", XSD_STRING});
        writer.element("xsd:element", new String[]{"name", "FontSize", "type", "xsd:unsignedShort"});
        writer.element("xsd:element", new String[]{"name", "FontFlags", "type", XSD_UNSIGNED_INT});
        writer.element("xsd:element", new String[]{"name", "FormatString", "type", XSD_STRING});
        writer.element("xsd:element", new String[]{"name", "NonEmptyBehavior", "type", "xsd:unsignedShort"});
        writer.element("xsd:element", new String[]{"name", "SolveOrder", "type", XSD_UNSIGNED_INT});
        writer.element("xsd:element", new String[]{"name", "Updateable", "type", XSD_UNSIGNED_INT});
        writer.element("xsd:element", new String[]{"name", "Visible", "type", XSD_UNSIGNED_INT});
        writer.element("xsd:element", new String[]{"name", "Expression", "type", XSD_STRING});
        writer.endElement();
        writer.endElement();
        writer.element("xsd:attribute", new String[]{"name", "CellOrdinal", "type", XSD_UNSIGNED_INT, "use", "required"});
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.startElement("xsd:element", new String[]{"name", "root"});
        writer.startElement("xsd:complexType");
        writer.startElement("xsd:sequence", new String[]{"maxOccurs", "unbounded"});
        writer.element("xsd:element", new String[]{"name", "OlapInfo", "type", "OlapInfo"});
        writer.element("xsd:element", new String[]{"name", "Axes", "type", "Axes"});
        writer.element("xsd:element", new String[]{"name", "CellData", "type", "CellData"});
        writer.endElement();
        writer.endElement();
        writer.endElement();
        writer.endElement();
    }

    static void writeEmptyDatasetXmlSchema(SaxWriter writer, SetType setType) {
        String setNsXmla = "urn:schemas-microsoft-com:xml-analysis:rowset";
        writer.startElement("xsd:schema", new String[]{"xmlns:xsd", "http://www.w3.org/2001/XMLSchema", "targetNamespace", setNsXmla, "xmlns", setNsXmla, "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance", "xmlns:sql", NS_XML_SQL, "elementFormDefault", "qualified"});
        writer.element("xsd:element", new String[]{"name", "root"});
        writer.endElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryResult executeDrillThroughQuery(XmlaRequest request) throws XmlaException {
        int count;
        Statement stmt;
        this.checkFormat(request);
        DataSourcesConfig.DataSource ds = this.getDataSource(request);
        DataSourcesConfig.Catalog dsCatalog = this.getCatalog(request, ds, true);
        String roleName = request.getRoleName();
        Role role = request.getRole();
        mondrian.olap.Connection connection = this.getConnection(dsCatalog, role, roleName);
        String statement = request.getStatement();
        Query query = connection.parseQuery(statement);
        query.setResultStyle(ResultStyle.LIST);
        Result result = connection.execute(query);
        Cell dtCell = result.getCell(new int[]{0, 0});
        if (!dtCell.canDrillThrough()) {
            throw new XmlaException("Server", "00HSBF01", "XMLA Drill Through not allowed", Util.newError("Cannot do DrillThrough operation on the cell"));
        }
        String dtSql = dtCell.getDrillThroughSQL(true);
        Connection sqlConn = null;
        try {
            Map<String, String> properties = request.getProperties();
            String advancedFlag = properties.get(PropertyDefinition.AdvancedFlag.name());
            if ("true".equals(advancedFlag)) {
                Position position = result.getAxes()[0].getPositions().get(0);
                Member[] members = position.toArray(new Member[position.size()]);
                CellRequest cellRequest = RolapAggregationManager.makeRequest(members);
                ArrayList<MondrianDef.Relation> relationList = new ArrayList<MondrianDef.Relation>();
                RolapStar.Table factTable = cellRequest.getMeasure().getStar().getFactTable();
                MondrianDef.Relation relation = factTable.getRelation();
                relationList.add(relation);
                for (RolapStar.Table table : factTable.getChildren()) {
                    relationList.add(table.getRelation());
                }
                ArrayList<String> truncatedTableList = new ArrayList<String>();
                sqlConn = connection.getDataSource().getConnection();
                stmt = null;
                stmt = sqlConn.createStatement();
                ArrayList fields = new ArrayList();
                HashMap<String, List<String>> tableFieldMap = new HashMap<String, List<String>>();
                for (MondrianDef.Relation relation1 : relationList) {
                    String tableName = relation1.toString();
                    ArrayList<String> fieldNameList = new ArrayList<String>();
                    dtSql = "SELECT * FROM " + tableName + " WHERE 1=2";
                    ResultSet rs = stmt.executeQuery(dtSql);
                    ResultSetMetaData rsMeta = rs.getMetaData();
                    for (int j = 1; j <= rsMeta.getColumnCount(); ++j) {
                        String colName = rsMeta.getColumnName(j);
                        boolean colNameExists = false;
                        for (List list : fields) {
                            if (!list.contains(colName)) continue;
                            colNameExists = true;
                            break;
                        }
                        if (colNameExists) continue;
                        fieldNameList.add(rsMeta.getColumnName(j));
                    }
                    fields.add(fieldNameList);
                    String truncatedTableName = tableName.substring(tableName.lastIndexOf(".") + 1);
                    truncatedTableList.add(truncatedTableName);
                    tableFieldMap.put(truncatedTableName, fieldNameList);
                }
                TabularRowSet tabularRowSet = new TabularRowSet(tableFieldMap, truncatedTableList);
                return tabularRowSet;
            }
            count = -1;
        }
        catch (XmlaException xex) {
            throw xex;
        }
        catch (SQLException sqle) {
            throw new XmlaException("Server", "00HSBF02", "XMLA Drill Through SQL error", Util.newError(sqle, "Error in drill through"));
        }
        catch (RuntimeException e) {}
        if (MondrianProperties.instance().EnableTotalCount.booleanValue()) {
            count = dtCell.getDrillThroughCount();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("drill through sql: " + dtSql));
        }
        int resultSetType = 1004;
        int resultSetConcurrency = 1007;
        SqlQuery.Dialect dialect = ((RolapSchema)connection.getSchema()).getDialect();
        if (!dialect.supportsResultSetConcurrency(resultSetType, resultSetConcurrency)) {
            resultSetType = 1003;
        }
        SqlStatement stmt2 = RolapUtil.executeQuery(connection.getDataSource(), dtSql, -1, "XmlaHandler.executeDrillThroughQuery", "Error in drill through", resultSetType, resultSetConcurrency);
        TabularRowSet tabularRowSet = new TabularRowSet(stmt2, request.drillThroughMaxRows(), request.drillThroughFirstRowset(), count, resultSetType);
        return tabularRowSet;
        {
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException ignored) {}
                }
            }
        }
        {
            throw new XmlaException("Server", "00HSBF02", "XMLA Drill Through SQL error", e);
        }
        finally {
            if (sqlConn != null) {
                try {
                    sqlConn.close();
                }
                catch (SQLException ignored) {}
            }
        }
    }

    private static String sqlToXsdType(int sqlType) {
        switch (sqlType) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return XSD_INTEGER;
            }
            case 2: {
                return XSD_DECIMAL;
            }
            case 6: 
            case 8: {
                return XSD_DOUBLE;
            }
            case 91: 
            case 92: 
            case 93: {
                return XSD_STRING;
            }
        }
        return XSD_STRING;
    }

    private QueryResult executeQuery(XmlaRequest request) throws XmlaException {
        Result result;
        Query query;
        String statement = request.getStatement();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("mdx: \"" + statement + "\""));
        }
        if (statement == null || statement.length() == 0) {
            return null;
        }
        this.checkFormat(request);
        DataSourcesConfig.DataSource ds = this.getDataSource(request);
        DataSourcesConfig.Catalog dsCatalog = this.getCatalog(request, ds, true);
        String roleName = request.getRoleName();
        Role role = request.getRole();
        mondrian.olap.Connection connection = this.getConnection(dsCatalog, role, roleName);
        try {
            query = connection.parseQuery(statement);
            query.setResultStyle(ResultStyle.LIST);
        }
        catch (XmlaException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new XmlaException("Client", "00HSBD01", "XMLA MDX parse failed", ex);
        }
        try {
            result = connection.execute(query);
        }
        catch (XmlaException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new XmlaException("Server", "00HSBD02", "XMLA MDX execute failed", ex);
        }
        String formatName = request.getProperties().get(PropertyDefinition.Format.name());
        Enumeration.Format format = this.valueOf(Enumeration.Format.class, formatName, null);
        if (format == Enumeration.Format.Multidimensional) {
            return new MDDataSet_Multidimensional(result);
        }
        return new MDDataSet_Tabular(result);
    }

    private void discover(XmlaRequest request, XmlaResponse response) throws XmlaException {
        RowsetDefinition rowsetDefinition = RowsetDefinition.valueOf(request.getRequestType());
        Rowset rowset = rowsetDefinition.getRowset(request, this);
        String formatName = request.getProperties().get(PropertyDefinition.Format.name());
        Enumeration.Format format = this.valueOf(Enumeration.Format.class, formatName, Enumeration.Format.Tabular);
        if (format != Enumeration.Format.Tabular) {
            throw new XmlaException("Client", "00HSBE01", "XMLA Discover format error", new UnsupportedOperationException("<Format>: only 'Tabular' allowed in Discover method type"));
        }
        String contentName = request.getProperties().get(PropertyDefinition.Content.name());
        Enumeration.Content content = this.valueOf(Enumeration.Content.class, contentName, CONTENT_DEFAULT);
        SaxWriter writer = response.getWriter();
        writer.startDocument();
        writer.startElement(this.prefix + ":DiscoverResponse", new String[]{"xmlns:" + this.prefix, "urn:schemas-microsoft-com:xml-analysis"});
        writer.startElement(this.prefix + ":return");
        writer.startElement("root", new String[]{"xmlns", "urn:schemas-microsoft-com:xml-analysis:rowset", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance", "xmlns:xsd", "http://www.w3.org/2001/XMLSchema", "xmlns:EX", "urn:schemas-microsoft-com:xml-analysis:exception"});
        if (content == Enumeration.Content.Schema || content == Enumeration.Content.SchemaData) {
            rowset.rowsetDefinition.writeRowsetXmlSchema(writer);
        }
        try {
            if (content == Enumeration.Content.Data || content == Enumeration.Content.SchemaData) {
                rowset.unparse(response);
            }
        }
        catch (XmlaException xex) {
            throw xex;
        }
        catch (Throwable t) {
            throw new XmlaException("Server", "00HSBE02", "XMLA Discover unparse results error", t);
        }
        finally {
            writer.endElement();
            writer.endElement();
            writer.endElement();
        }
        writer.endDocument();
    }

    private <E extends Enum<E>> E valueOf(Class<E> enumType, String name, E defaultValue) {
        if (name == null) {
            return defaultValue;
        }
        try {
            return Enum.valueOf(enumType, name);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    protected mondrian.olap.Connection getConnection(DataSourcesConfig.Catalog catalog, Role role, String roleName) throws XmlaException {
        DataSourcesConfig.DataSource ds = catalog.getDataSource();
        Util.PropertyList connectProperties = Util.parseConnectString(catalog.getDataSourceInfo());
        String catalogUrl = this.catalogLocator.locate(catalog.definition);
        if (LOGGER.isDebugEnabled()) {
            if (catalogUrl == null) {
                LOGGER.debug((Object)"XmlaHandler.getConnection: catalogUrl is null");
            } else {
                LOGGER.debug((Object)("XmlaHandler.getConnection: catalogUrl=" + catalogUrl));
            }
        }
        connectProperties.put(RolapConnectionProperties.Catalog.name(), catalogUrl);
        if (!"Unauthenticated".equalsIgnoreCase(ds.getAuthenticationMode()) && role == null && roleName == null) {
            throw new XmlaException("Client", "00HSBC02", "XMLA connection with role must be authenticated", new SecurityException("Access denied for data source needing authentication"));
        }
        if (roleName != null) {
            connectProperties.put(RolapConnectionProperties.Role.name(), roleName);
        }
        RolapConnection conn = (RolapConnection)DriverManager.getConnection(connectProperties, null);
        if (role != null) {
            conn.setRole(role);
        }
        if (LOGGER.isDebugEnabled()) {
            if (conn == null) {
                LOGGER.debug((Object)"XmlaHandler.getConnection: returning connection null");
            } else {
                LOGGER.debug((Object)"XmlaHandler.getConnection: returning connection not null");
            }
        }
        return conn;
    }

    public DataSourcesConfig.DataSource getDataSource(XmlaRequest request) throws XmlaException {
        Map<String, String> properties = request.getProperties();
        String dataSourceInfo = properties.get(PropertyDefinition.DataSourceInfo.name());
        if (!this.dataSourcesMap.containsKey(dataSourceInfo)) {
            throw new XmlaException("Client", "00HSBC01", "XMLA connection datasource not found", Util.newError("no data source is configured with name '" + dataSourceInfo + "'"));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("XmlaHandler.getDataSource: dataSourceInfo=" + dataSourceInfo));
        }
        DataSourcesConfig.DataSource ds = this.dataSourcesMap.get(dataSourceInfo);
        if (LOGGER.isDebugEnabled()) {
            if (ds == null) {
                LOGGER.debug((Object)"XmlaHandler.getDataSource: ds is null");
            } else {
                LOGGER.debug((Object)("XmlaHandler.getDataSource: ds.dataSourceInfo=" + ds.getDataSourceInfo()));
            }
        }
        return ds;
    }

    public DataSourcesConfig.Catalog getCatalog(DataSourcesConfig.DataSource ds, String catalogName) {
        DataSourcesConfig.Catalog[] catalogs = ds.catalogs.catalogs;
        if (catalogName == null) {
            if (catalogs.length == 1) {
                return catalogs[0];
            }
        } else {
            for (DataSourcesConfig.Catalog dsCatalog : catalogs) {
                if (!catalogName.equals(dsCatalog.name)) continue;
                return dsCatalog;
            }
        }
        return null;
    }

    public DataSourcesConfig.Catalog[] getCatalogs(XmlaRequest request, DataSourcesConfig.DataSource ds) {
        Map<String, String> properties = request.getProperties();
        String catalogName = properties.get(PropertyDefinition.Catalog.name());
        if (catalogName != null) {
            DataSourcesConfig.Catalog dsCatalog = this.getCatalog(ds, catalogName);
            return new DataSourcesConfig.Catalog[]{dsCatalog};
        }
        return ds.catalogs.catalogs;
    }

    public DataSourcesConfig.Catalog getCatalog(XmlaRequest request, DataSourcesConfig.DataSource ds, boolean required) throws XmlaException {
        Map<String, String> properties = request.getProperties();
        String catalogName = properties.get(PropertyDefinition.Catalog.name());
        DataSourcesConfig.Catalog dsCatalog = this.getCatalog(ds, catalogName);
        if (dsCatalog == null) {
            if (catalogName == null) {
                if (required) {
                    throw new XmlaException("Client", "00HSBC01", "XMLA connection datasource not found", Util.newError("catalog not specified"));
                }
                return null;
            }
            throw new XmlaException("Client", "00HSBC01", "XMLA connection datasource not found", Util.newError("no catalog named '" + catalogName + "'"));
        }
        return dsCatalog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TabularRowSet executeColumnQuery(XmlaRequest request) throws XmlaException {
        this.checkFormat(request);
        DataSourcesConfig.DataSource ds = this.getDataSource(request);
        DataSourcesConfig.Catalog dsCatalog = this.getCatalog(request, ds, true);
        String roleName = request.getRoleName();
        Role role = request.getRole();
        mondrian.olap.Connection connection = this.getConnection(dsCatalog, role, roleName);
        String statement = request.getStatement();
        Query query = connection.parseQuery(statement);
        query.setResultStyle(ResultStyle.LIST);
        Result result = connection.execute(query);
        Cell dtCell = result.getCell(new int[]{0, 0});
        if (!dtCell.canDrillThrough()) {
            throw new XmlaException("Server", "00HSBF01", "XMLA Drill Through not allowed", Util.newError("Cannot do DillThrough operation on the cell"));
        }
        Map<String, String> properties = request.getProperties();
        String dtSql = dtCell.getDrillThroughSQL(true);
        int index = dtSql.indexOf("from");
        String whereClause = " " + dtSql.substring(index);
        String fieldNames = properties.get(PropertyDefinition.TableFields.name());
        StringTokenizer st = new StringTokenizer(fieldNames, ",");
        this.drillThruColumnNames.clear();
        while (st.hasMoreTokens()) {
            this.drillThruColumnNames.add(st.nextToken());
        }
        StringBuilder buf = new StringBuilder("select ");
        int k = -1;
        for (String drillThruColumnName : this.drillThruColumnNames) {
            if (++k > 0) {
                buf.append(",");
            }
            buf.append(drillThruColumnName);
        }
        buf.append(' ');
        buf.append(whereClause);
        dtSql = buf.toString();
        DataSource dataSource = connection.getDataSource();
        try {
            int count = -1;
            if (MondrianProperties.instance().EnableTotalCount.booleanValue()) {
                String temp = dtSql.toUpperCase();
                int fromOff = temp.indexOf("FROM");
                buf.setLength(0);
                buf.append("select count(*) ");
                buf.append(dtSql.substring(fromOff));
                String countSql = buf.toString();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("Advanced drill through counting sql: " + countSql));
                }
                SqlStatement smt = RolapUtil.executeQuery(dataSource, countSql, -1, "XmlaHandler.executeColumnQuery", "Advanced drill-through", 1004, 1007);
                try {
                    ResultSet rs = smt.getResultSet();
                    if (rs.next()) {
                        count = rs.getInt(1);
                        ++smt.rowCount;
                    }
                }
                catch (SQLException e) {
                    smt.handle(e);
                }
                finally {
                    smt.close();
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Advanced drill through sql: " + dtSql));
            }
            SqlStatement stmt = RolapUtil.executeQuery(dataSource, dtSql, -1, "XmlaHandler.executeColumnQuery", "Advanced drill-through", 1004, 1007);
            return new TabularRowSet(stmt, request.drillThroughMaxRows(), request.drillThroughFirstRowset(), count, 1003);
        }
        catch (XmlaException xex) {
            throw xex;
        }
        catch (RuntimeException rte) {
            throw new XmlaException("Server", "00HSBF02", "XMLA Drill Through SQL error", rte);
        }
    }

    public static void main(String[] args) {
        for (RowsetDefinition def : RowsetDefinition.values()) {
            System.out.print("    " + def.name() + "(");
            int k = 0;
            for (RowsetDefinition.Column column : def.columnDefinitions) {
                if (k++ == 0) {
                    System.out.println();
                } else {
                    System.out.println(",");
                }
                System.out.print("        new MetadataColumn(\"" + column.name + "\")");
            }
            System.out.println("),");
        }
    }

    static class MDDataSet_Tabular
    extends MDDataSet {
        private final boolean empty;
        private final int[] pos;
        private final int axisCount;
        private int cellOrdinal;
        private static final Id[] MemberCaptionIdArray = new Id[]{new Id(new Id.Segment(Property.MEMBER_CAPTION.name, Id.Quoting.QUOTED))};
        private final Member[] members;
        private final ColumnHandler[] columnHandlers;

        public MDDataSet_Tabular(Result result) {
            super(result);
            Axis[] axes = result.getAxes();
            this.axisCount = axes.length;
            this.pos = new int[this.axisCount];
            boolean empty = false;
            int dimensionCount = 0;
            for (int i = axes.length - 1; i > 0; --i) {
                Axis axis = axes[i];
                if (axis.getPositions().size() == 0) {
                    empty = true;
                    continue;
                }
                dimensionCount += axis.getPositions().get(0).size();
            }
            this.empty = empty;
            Level[] levels = new Level[dimensionCount];
            ArrayList<ColumnHandler> columnHandlerList = new ArrayList<ColumnHandler>();
            int memberOrdinal = 0;
            if (!empty) {
                for (int i = axes.length - 1; i > 0; --i) {
                    Axis axis = axes[i];
                    QueryAxis queryAxis = result.getQuery().getAxes()[i];
                    int z0 = memberOrdinal;
                    List<Position> positions = axis.getPositions();
                    int jj = 0;
                    for (Position position : positions) {
                        memberOrdinal = z0;
                        for (Member member : position) {
                            if (jj == 0 || member.getLevel().getDepth() > levels[memberOrdinal].getDepth()) {
                                levels[memberOrdinal] = member.getLevel();
                            }
                            ++memberOrdinal;
                        }
                        ++jj;
                    }
                    Id[] dimProps = queryAxis.getDimensionProperties();
                    if (dimProps.length == 0) {
                        dimProps = MemberCaptionIdArray;
                    }
                    for (int j = z0; j < memberOrdinal; ++j) {
                        Level level = levels[j];
                        for (int k = 0; k <= level.getDepth(); ++k) {
                            Level level2 = level.getHierarchy().getLevels()[k];
                            if (level2.isAll()) continue;
                            for (Id dimProp : dimProps) {
                                columnHandlerList.add(new MemberColumnHandler(dimProp.toStringArray()[0], level2, j));
                            }
                        }
                    }
                }
            }
            this.members = new Member[memberOrdinal + 1];
            if (axes.length > 0) {
                Axis columnsAxis = axes[0];
                for (Position position : columnsAxis.getPositions()) {
                    String name = null;
                    int j = 0;
                    for (Member member : position) {
                        name = j == 0 ? member.getUniqueName() : name + "." + member.getUniqueName();
                        ++j;
                    }
                    columnHandlerList.add(new CellColumnHandler(name));
                }
            }
            this.columnHandlers = columnHandlerList.toArray(new ColumnHandler[columnHandlerList.size()]);
        }

        public void metadata(SaxWriter writer) {
            writer.startElement("xsd:schema", new String[]{"xmlns:xsd", "http://www.w3.org/2001/XMLSchema", "targetNamespace", "urn:schemas-microsoft-com:xml-analysis:rowset", "xmlns", "urn:schemas-microsoft-com:xml-analysis:rowset", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance", "xmlns:sql", XmlaHandler.NS_XML_SQL, "elementFormDefault", "qualified"});
            writer.startElement("xsd:element", new String[]{"name", "root"});
            writer.startElement("xsd:complexType");
            writer.startElement("xsd:sequence");
            writer.element("xsd:element", new String[]{"maxOccurs", "unbounded", "minOccurs", "0", "name", "row", "type", "row"});
            writer.endElement();
            writer.endElement();
            writer.endElement();
            writer.startElement("xsd:simpleType", new String[]{"name", "uuid"});
            writer.startElement("xsd:restriction", new String[]{"base", XmlaHandler.XSD_STRING});
            writer.element("xsd:pattern", new String[]{"value", "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}"});
            writer.endElement();
            writer.endElement();
            writer.startElement("xsd:complexType", new String[]{"name", "row"});
            writer.startElement("xsd:sequence");
            for (ColumnHandler columnHandler : this.columnHandlers) {
                columnHandler.metadata(writer);
            }
            writer.endElement();
            writer.endElement();
            writer.endElement();
        }

        public void unparse(SaxWriter writer) throws SAXException {
            if (this.empty) {
                return;
            }
            this.cellData(writer);
        }

        private void cellData(SaxWriter writer) throws SAXException {
            this.cellOrdinal = 0;
            this.iterate(writer);
        }

        private void iterate(SaxWriter writer) throws SAXException {
            switch (this.axisCount) {
                case 0: {
                    this.emitCell(writer, this.result.getCell(this.pos));
                    return;
                }
            }
            this.iterate(writer, this.axisCount - 1, 0);
        }

        private void iterate(SaxWriter writer, int axis, int xxx) {
            List<Position> positions = this.result.getAxes()[axis].getPositions();
            int axisLength = axis == 0 ? 1 : positions.size();
            for (int i = 0; i < axisLength; ++i) {
                Position position = positions.get(i);
                int ho = xxx;
                for (int j = 0; j < position.size() && ho < this.members.length; ++j, ++ho) {
                    this.members[ho] = (Member)position.get(j);
                }
                ++this.cellOrdinal;
                Util.discard((int)this.cellOrdinal);
                if (axis >= 2) {
                    this.iterate(writer, axis - 1, ho);
                    continue;
                }
                writer.startElement("row");
                this.pos[axis] = i;
                this.pos[0] = 0;
                for (ColumnHandler columnHandler : this.columnHandlers) {
                    if (columnHandler instanceof MemberColumnHandler) {
                        columnHandler.write(writer, null, this.members);
                        continue;
                    }
                    if (!(columnHandler instanceof CellColumnHandler)) continue;
                    columnHandler.write(writer, this.result.getCell(this.pos), null);
                    this.pos[0] = this.pos[0] + 1;
                }
                writer.endElement();
            }
        }

        private void emitCell(SaxWriter writer, Cell cell) {
            ++this.cellOrdinal;
            Util.discard((int)this.cellOrdinal);
            Object cellValue = cell.getValue();
            if (cellValue == null) {
                return;
            }
            writer.startElement("row");
            for (ColumnHandler columnHandler : this.columnHandlers) {
                columnHandler.write(writer, cell, this.members);
            }
            writer.endElement();
        }
    }

    static class MemberColumnHandler
    extends ColumnHandler {
        private final String property;
        private final Level level;
        private final int memberOrdinal;

        public MemberColumnHandler(String property, Level level, int memberOrdinal) {
            super(level.getUniqueName() + "." + Util.quoteMdxIdentifier(property));
            this.property = property;
            this.level = level;
            this.memberOrdinal = memberOrdinal;
        }

        public void metadata(SaxWriter writer) {
            writer.element("xsd:element", new String[]{"minOccurs", "0", "name", this.encodedName, "sql:field", this.name, "type", XmlaHandler.XSD_STRING});
        }

        public void write(SaxWriter writer, Cell cell, Member[] members) {
            Member member = members[this.memberOrdinal];
            int depth = this.level.getDepth();
            if (member.getDepth() < depth) {
                return;
            }
            while (member.getDepth() > depth) {
                member = member.getParentMember();
            }
            Object propertyValue = member.getPropertyValue(this.property);
            if (propertyValue == null) {
                return;
            }
            writer.startElement(this.encodedName);
            writer.characters(propertyValue.toString());
            writer.endElement();
        }
    }

    static class CellColumnHandler
    extends ColumnHandler {
        CellColumnHandler(String name) {
            super(name);
        }

        public void metadata(SaxWriter writer) {
            writer.element("xsd:element", new String[]{"minOccurs", "0", "name", this.encodedName, "sql:field", this.name});
        }

        public void write(SaxWriter writer, Cell cell, Member[] members) {
            if (cell.isNull()) {
                return;
            }
            Object value = cell.getValue();
            String dataType = (String)cell.getPropertyValue(Property.DATATYPE.getName());
            ValueInfo vi = new ValueInfo(dataType, value);
            String valueType = vi.valueType;
            value = vi.value;
            boolean isDecimal = vi.isDecimal;
            String valueString = value.toString();
            writer.startElement(this.encodedName, new String[]{"xsi:type", valueType});
            if (isDecimal) {
                valueString = XmlaUtil.normalizeNumericString(valueString);
            }
            writer.characters(valueString);
            writer.endElement();
        }
    }

    static abstract class ColumnHandler {
        protected final String name;
        protected final String encodedName;

        protected ColumnHandler(String name) {
            this.name = name;
            this.encodedName = XmlaUtil.encodeElementName(this.name);
        }

        abstract void write(SaxWriter var1, Cell var2, Member[] var3);

        abstract void metadata(SaxWriter var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MDDataSet_Multidimensional
    extends MDDataSet {
        private List<Hierarchy> slicerAxisHierarchies;

        protected MDDataSet_Multidimensional(Result result) {
            super(result);
        }

        @Override
        public void unparse(SaxWriter writer) throws SAXException {
            this.olapInfo(writer);
            this.axes(writer);
            this.cellData(writer);
        }

        private void olapInfo(SaxWriter writer) {
            Cube cube = this.result.getQuery().getCube();
            ArrayList<Dimension> unseenDimensionList = new ArrayList<Dimension>(Arrays.asList(cube.getDimensions()));
            writer.startElement("OlapInfo");
            writer.startElement("CubeInfo");
            writer.startElement("Cube");
            writer.startElement("CubeName");
            writer.characters(this.result.getQuery().getCube().getName());
            writer.endElement();
            writer.endElement();
            writer.endElement();
            writer.startElement("AxesInfo");
            Axis[] axes = this.result.getAxes();
            QueryAxis[] queryAxes = this.result.getQuery().getAxes();
            ArrayList<Hierarchy> axisHierarchyList = new ArrayList<Hierarchy>();
            for (int i = 0; i < axes.length; ++i) {
                List<Hierarchy> hiers = this.axisInfo(writer, axes[i], queryAxes[i], "Axis" + i);
                axisHierarchyList.addAll(hiers);
            }
            for (Hierarchy hier1 : axisHierarchyList) {
                unseenDimensionList.remove(hier1.getDimension());
            }
            ArrayList<Hierarchy> hierarchies = new ArrayList<Hierarchy>();
            for (Dimension dimension : unseenDimensionList) {
                hierarchies.add(dimension.getHierarchy());
            }
            writer.startElement("AxisInfo", new String[]{"name", "SlicerAxis"});
            QueryAxis slicerAxis = this.result.getQuery().getSlicerAxis();
            this.writeHierarchyInfo(writer, hierarchies, this.getProps(slicerAxis));
            writer.endElement();
            this.slicerAxisHierarchies = hierarchies;
            writer.endElement();
            writer.startElement("CellInfo");
            if (this.shouldReturnCellProperty(Property.VALUE.getName())) {
                writer.element("Value", new String[]{"name", "VALUE"});
            }
            if (this.shouldReturnCellProperty(Property.FORMATTED_VALUE.getName())) {
                writer.element("FmtValue", new String[]{"name", "FORMATTED_VALUE"});
            }
            if (this.shouldReturnCellProperty(Property.FORMAT_STRING.getName())) {
                writer.element("FormatString", new String[]{"name", "FORMAT_STRING"});
            }
            writer.endElement();
            writer.endElement();
        }

        private List<Hierarchy> axisInfo(SaxWriter writer, Axis axis, QueryAxis queryAxis, String axisName) {
            List<Hierarchy> hierarchies;
            writer.startElement("AxisInfo", new String[]{"name", axisName});
            Iterator<Position> it = axis.getPositions().iterator();
            if (it.hasNext()) {
                Position position = it.next();
                hierarchies = new ArrayList();
                for (Member member : position) {
                    hierarchies.add(member.getHierarchy());
                }
            } else {
                hierarchies = Collections.emptyList();
            }
            String[] props = this.getProps(queryAxis);
            this.writeHierarchyInfo(writer, hierarchies, props);
            writer.endElement();
            return hierarchies;
        }

        private void writeHierarchyInfo(SaxWriter writer, List<Hierarchy> hierarchies, String[] props) {
            for (Hierarchy hierarchy : hierarchies) {
                writer.startElement("HierarchyInfo", new String[]{"name", hierarchy.getName()});
                for (String prop : props) {
                    writer.element(prop, this.getAttributes(prop, hierarchy));
                }
                writer.endElement();
            }
        }

        private String[] getAttributes(String prop, Hierarchy hierarchy) {
            String actualPropName = this.getPropertyName(prop);
            ArrayList<String> values = new ArrayList<String>();
            values.add("name");
            values.add(hierarchy.getUniqueName() + "." + Util.quoteMdxIdentifier(actualPropName));
            if (longPropNames.get(prop) == null) {
                values.add("type");
                values.add(this.getXsdType(actualPropName));
            }
            return values.toArray(new String[values.size()]);
        }

        private String getXsdType(String prop) {
            Property property = Property.lookup(prop, false);
            if (property != null) {
                Property.Datatype datatype = property.getType();
                switch (datatype) {
                    case TYPE_NUMERIC: {
                        return RowsetDefinition.Type.UnsignedInteger.columnType;
                    }
                    case TYPE_BOOLEAN: {
                        return RowsetDefinition.Type.Boolean.columnType;
                    }
                }
            }
            return RowsetDefinition.Type.String.columnType;
        }

        private String getPropertyName(String prop) {
            String actualPropertyName = (String)longPropNames.get(prop);
            if (actualPropertyName == null) {
                return prop;
            }
            return actualPropertyName;
        }

        private void axes(SaxWriter writer) {
            writer.startElement("Axes");
            Axis[] axes = this.result.getAxes();
            QueryAxis[] queryAxes = this.result.getQuery().getAxes();
            for (int i = 0; i < axes.length; ++i) {
                String[] props = this.getProps(queryAxes[i]);
                this.axis(writer, axes[i], props, "Axis" + i);
            }
            List<Hierarchy> hierarchies = this.slicerAxisHierarchies;
            writer.startElement("Axis", new String[]{"name", "SlicerAxis"});
            writer.startElement("Tuples");
            writer.startElement("Tuple");
            HashMap<String, Integer> memberMap = new HashMap<String, Integer>();
            Axis slicerAxis = this.result.getSlicerAxis();
            if (slicerAxis.getPositions() != null && slicerAxis.getPositions().size() > 0) {
                Position pos0 = slicerAxis.getPositions().get(0);
                int i = 0;
                for (Member member : pos0) {
                    memberMap.put(member.getHierarchy().getName(), i++);
                }
            }
            QueryAxis slicerQueryAxis = this.result.getQuery().getSlicerAxis();
            List slicerMembers = this.result.getSlicerAxis().getPositions().get(0);
            for (Hierarchy hierarchy : hierarchies) {
                Member member = hierarchy.getDefaultMember();
                Integer indexPosition = (Integer)memberMap.get(hierarchy.getName());
                Member positionMember = indexPosition != null ? (Member)slicerAxis.getPositions().get(0).get(indexPosition) : null;
                for (Member slicerMember : slicerMembers) {
                    if (!slicerMember.getHierarchy().equals(hierarchy)) continue;
                    member = slicerMember;
                    break;
                }
                if (member != null) {
                    if (positionMember != null) {
                        this.writeMember(writer, positionMember, null, slicerAxis.getPositions().get(0), indexPosition, this.getProps(slicerQueryAxis));
                        continue;
                    }
                    this.slicerAxis(writer, member, this.getProps(slicerQueryAxis));
                    continue;
                }
                LOGGER.warn((Object)("Can not create SlicerAxis: null default member for Hierarchy " + hierarchy.getUniqueName()));
            }
            writer.endElement();
            writer.endElement();
            writer.endElement();
            writer.endElement();
        }

        private String[] getProps(QueryAxis queryAxis) {
            if (queryAxis == null) {
                return defaultProps;
            }
            Id[] dimensionProperties = queryAxis.getDimensionProperties();
            if (dimensionProperties.length == 0) {
                return defaultProps;
            }
            String[] props = new String[defaultProps.length + dimensionProperties.length];
            System.arraycopy(defaultProps, 0, props, 0, defaultProps.length);
            for (int i = 0; i < dimensionProperties.length; ++i) {
                props[MDDataSet_Multidimensional.defaultProps.length + i] = dimensionProperties[i].toStringArray()[0];
            }
            return props;
        }

        private void axis(SaxWriter writer, Axis axis, String[] props, String axisName) {
            Position nextPosition;
            writer.startElement("Axis", new String[]{"name", axisName});
            writer.startElement("Tuples");
            List<Position> positions = axis.getPositions();
            Iterator<Position> pit = positions.iterator();
            Position prevPosition = null;
            Position position = pit.hasNext() ? pit.next() : null;
            Position position2 = nextPosition = pit.hasNext() ? pit.next() : null;
            while (position != null) {
                writer.startElement("Tuple");
                int k = 0;
                for (Member member : position) {
                    this.writeMember(writer, member, prevPosition, nextPosition, k++, props);
                }
                writer.endElement();
                prevPosition = position;
                position = nextPosition;
                nextPosition = pit.hasNext() ? pit.next() : null;
            }
            writer.endElement();
            writer.endElement();
        }

        private void writeMember(SaxWriter writer, Member member, Position prevPosition, Position nextPosition, int k, String[] props) {
            writer.startElement("Member", new String[]{"Hierarchy", member.getHierarchy().getName()});
            for (String prop : props) {
                Object value;
                String propLong = (String)longPropNames.get(prop);
                if (propLong == null) {
                    propLong = prop;
                }
                if (propLong.equals(Property.DISPLAY_INFO.name)) {
                    Integer childrenCard = (Integer)member.getPropertyValue(Property.CHILDREN_CARDINALITY.name);
                    value = this.calculateDisplayInfo(prevPosition, nextPosition, member, k, childrenCard);
                } else {
                    value = propLong.equals(Property.DEPTH.name) ? Integer.valueOf(member.getDepth()) : member.getPropertyValue(propLong);
                }
                if (value == null) continue;
                writer.startElement(prop);
                writer.characters(value.toString());
                writer.endElement();
            }
            writer.endElement();
        }

        private void slicerAxis(SaxWriter writer, Member member, String[] props) {
            writer.startElement("Member", new String[]{"Hierarchy", member.getHierarchy().getName()});
            for (String prop : props) {
                Object value;
                String propLong = (String)longPropNames.get(prop);
                if (propLong == null) {
                    propLong = prop;
                }
                if (propLong.equals(Property.DISPLAY_INFO.name)) {
                    Integer childrenCard = (Integer)member.getPropertyValue(Property.CHILDREN_CARDINALITY.name);
                    int displayInfo = 0xFFFF & childrenCard;
                    value = displayInfo;
                } else {
                    value = propLong.equals(Property.DEPTH.name) ? Integer.valueOf(member.getDepth()) : member.getPropertyValue(propLong);
                }
                if (value == null) continue;
                writer.startElement(prop);
                writer.characters(value.toString());
                writer.endElement();
            }
            writer.endElement();
        }

        private int calculateDisplayInfo(Position prevPosition, Position nextPosition, Member currentMember, int memberOrdinal, int childrenCount) {
            Member nextMember;
            String nextParentUName;
            String currentUName;
            int displayInfo = 0xFFFF & childrenCount;
            if (nextPosition != null && (currentUName = currentMember.getUniqueName()).equals(nextParentUName = (nextMember = (Member)nextPosition.get(memberOrdinal)).getParentUniqueName())) {
                displayInfo |= 0x10000;
            }
            if (prevPosition != null) {
                String currentParentUName = currentMember.getParentUniqueName();
                Member prevMember = (Member)prevPosition.get(memberOrdinal);
                String prevParentUName = prevMember.getParentUniqueName();
                if (currentParentUName != null && currentParentUName.equals(prevParentUName)) {
                    displayInfo |= 0x20000;
                }
            }
            return displayInfo;
        }

        private void cellData(SaxWriter writer) {
            writer.startElement("CellData");
            int axisCount = this.result.getAxes().length;
            int[] pos = new int[axisCount];
            int[] cellOrdinal = new int[]{0};
            Evaluator evaluator = RolapUtil.createEvaluator(this.result.getQuery());
            int axisOrdinal = axisCount - 1;
            this.recurse(writer, pos, axisOrdinal, evaluator, cellOrdinal);
            writer.endElement();
        }

        private void recurse(SaxWriter writer, int[] pos, int axisOrdinal, Evaluator evaluator, int[] cellOrdinal) {
            if (axisOrdinal < 0) {
                int n = cellOrdinal[0];
                cellOrdinal[0] = n + 1;
                this.emitCell(writer, pos, evaluator, n);
            } else {
                Axis axis = this.result.getAxes()[axisOrdinal];
                List<Position> positions = axis.getPositions();
                int i = 0;
                for (Position position : positions) {
                    pos[axisOrdinal] = i++;
                    evaluator.setContext(position);
                    this.recurse(writer, pos, axisOrdinal - 1, evaluator, cellOrdinal);
                }
            }
        }

        private void emitCell(SaxWriter writer, int[] pos, Evaluator evaluator, int ordinal) {
            Cell cell = this.result.getCell(pos);
            if (cell.isNull() && ordinal != 0) {
                return;
            }
            writer.startElement("Cell", new String[]{"CellOrdinal", Integer.toString(ordinal)});
            for (int i = 0; i < cellProps.length; ++i) {
                String cellPropLong = cellPropLongs[i];
                Object value = cell.getPropertyValue(cellPropLong);
                if (value == null || !this.shouldReturnCellProperty(cellPropLong)) continue;
                boolean isDecimal = false;
                if (cellPropLong.equals(Property.VALUE.name)) {
                    if (cell.isNull()) continue;
                    String dataType = (String)evaluator.getProperty(Property.DATATYPE.getName(), null);
                    ValueInfo vi = new ValueInfo(dataType, value);
                    String valueType = vi.valueType;
                    value = vi.value;
                    isDecimal = vi.isDecimal;
                    writer.startElement(cellProps[i], new String[]{"xsi:type", valueType});
                } else {
                    writer.startElement(cellProps[i]);
                }
                String valueString = value.toString();
                if (isDecimal) {
                    valueString = XmlaUtil.normalizeNumericString(valueString);
                }
                writer.characters(valueString);
                writer.endElement();
            }
            writer.endElement();
        }

        private boolean shouldReturnCellProperty(String cellPropLong) {
            Query query = this.result.getQuery();
            return query.isCellPropertyEmpty() || query.hasCellProperty(cellPropLong);
        }
    }

    static abstract class MDDataSet
    implements QueryResult {
        protected final Result result;
        protected static final String[] cellProps = new String[]{"Value", "FmtValue", "FormatString"};
        protected static final String[] cellPropLongs = new String[]{Property.VALUE.name, Property.FORMATTED_VALUE.name, Property.FORMAT_STRING.name};
        protected static final String[] defaultProps = new String[]{"UName", "Caption", "LName", "LNum", "DisplayInfo"};
        protected static final Map<String, String> longPropNames = new HashMap<String, String>();

        protected MDDataSet(Result result) {
            this.result = result;
        }

        static {
            longPropNames.put("UName", Property.MEMBER_UNIQUE_NAME.name);
            longPropNames.put("Caption", Property.MEMBER_CAPTION.name);
            longPropNames.put("LName", Property.LEVEL_UNIQUE_NAME.name);
            longPropNames.put("LNum", Property.LEVEL_NUMBER.name);
            longPropNames.put("DisplayInfo", Property.DISPLAY_INFO.name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TabularRowSet
    implements QueryResult {
        private final List<Column> columns = new ArrayList<Column>();
        private final List<Object[]> rows;
        private int totalCount;

        public TabularRowSet(SqlStatement stmt, int maxRows, int firstRowset, int totalCount, int resultSetType) {
            this.totalCount = totalCount;
            ResultSet rs = stmt.getResultSet();
            try {
                int firstRow;
                ResultSetMetaData md = rs.getMetaData();
                int columnCount = md.getColumnCount();
                for (int i = 0; i < columnCount; ++i) {
                    this.columns.add(new Column(md.getColumnLabel(i + 1), md.getColumnType(i + 1)));
                }
                int n = firstRow = firstRowset <= 0 ? 1 : firstRowset;
                if (resultSetType == 1003) {
                    for (int i = 0; i < firstRow && rs.next(); ++i) {
                    }
                } else {
                    rs.absolute(firstRow);
                }
                this.rows = new ArrayList<Object[]>();
                maxRows = maxRows <= 0 ? Integer.MAX_VALUE : maxRows;
                do {
                    Object[] row = new Object[columnCount];
                    for (int i = 0; i < columnCount; ++i) {
                        row[i] = rs.getObject(i + 1);
                    }
                    this.rows.add(row);
                } while (rs.next() && --maxRows > 0);
            }
            catch (SQLException e) {
                throw stmt.handle(e);
            }
            finally {
                stmt.close();
            }
        }

        public TabularRowSet(Map<String, List<String>> tableFieldMap, List<String> tableList) {
            for (String tableName : tableList) {
                List<String> fieldNames = tableFieldMap.get(tableName);
                for (String fieldName : fieldNames) {
                    this.columns.add(new Column(tableName + "." + fieldName, 12));
                }
            }
            this.rows = new ArrayList<Object[]>();
            Object[] row = new Object[this.columns.size()];
            for (int k = 0; k < row.length; ++k) {
                row[k] = k;
            }
            this.rows.add(row);
        }

        @Override
        public void unparse(SaxWriter writer) throws SAXException {
            if (this.totalCount >= 0) {
                String countStr = Integer.toString(this.totalCount);
                writer.startElement("row");
                for (Column column : this.columns) {
                    writer.startElement(column.encodedName);
                    writer.characters(countStr);
                    writer.endElement();
                }
                writer.endElement();
            }
            for (Object[] row : this.rows) {
                writer.startElement("row");
                for (int i = 0; i < row.length; ++i) {
                    writer.startElement(this.columns.get(i).encodedName);
                    Object value = row[i];
                    if (value == null) {
                        writer.characters("null");
                    } else {
                        String valueString = value.toString();
                        if (value instanceof Number) {
                            valueString = XmlaUtil.normalizeNumericString(valueString);
                        }
                        writer.characters(valueString);
                    }
                    writer.endElement();
                }
                writer.endElement();
            }
        }

        public TabularRowSet(ResultSet rs) throws SQLException {
            ResultSetMetaData md = rs.getMetaData();
            int columnCount = md.getColumnCount();
            for (int i = 0; i < columnCount; ++i) {
                this.columns.add(new Column(md.getColumnName(i + 1), md.getColumnType(i + 1)));
            }
            this.rows = new ArrayList<Object[]>();
            while (rs.next()) {
                Object[] row = new Object[columnCount];
                for (int i = 0; i < columnCount; ++i) {
                    row[i] = rs.getObject(i + 1);
                }
                this.rows.add(row);
            }
        }

        public void metadata(SaxWriter writer) {
            writer.startElement("xsd:schema", new String[]{"xmlns:xsd", "http://www.w3.org/2001/XMLSchema", "targetNamespace", "urn:schemas-microsoft-com:xml-analysis:rowset", "xmlns", "urn:schemas-microsoft-com:xml-analysis:rowset", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance", "xmlns:sql", XmlaHandler.NS_XML_SQL, "elementFormDefault", "qualified"});
            writer.startElement("xsd:element", new String[]{"name", "root"});
            writer.startElement("xsd:complexType");
            writer.startElement("xsd:sequence");
            writer.element("xsd:element", new String[]{"maxOccurs", "unbounded", "minOccurs", "0", "name", "row", "type", "row"});
            writer.endElement();
            writer.endElement();
            writer.endElement();
            writer.startElement("xsd:simpleType", new String[]{"name", "uuid"});
            writer.startElement("xsd:restriction", new String[]{"base", XmlaHandler.XSD_STRING});
            writer.element("xsd:pattern", new String[]{"value", "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}"});
            writer.endElement();
            writer.endElement();
            writer.startElement("xsd:complexType", new String[]{"name", "row"});
            writer.startElement("xsd:sequence");
            for (Column column : this.columns) {
                writer.element("xsd:element", new String[]{"minOccurs", "0", "name", column.encodedName, "sql:field", column.name, "type", column.xsdType});
            }
            writer.endElement();
            writer.endElement();
            writer.endElement();
        }
    }

    static class Column {
        private final String name;
        private final String encodedName;
        private final String xsdType;

        Column(String name, int type) {
            this.name = name;
            this.encodedName = XmlaUtil.encodeElementName(name);
            this.xsdType = XmlaHandler.sqlToXsdType(type);
        }
    }

    private static interface QueryResult {
        public void unparse(SaxWriter var1) throws SAXException;
    }

    static class ValueInfo {
        String valueType;
        Object value;
        boolean isDecimal;

        static String getValueTypeHint(String dataType) {
            if (dataType != null) {
                return dataType.equals("Integer") ? XmlaHandler.XSD_INT : (dataType.equals("Numeric") ? XmlaHandler.XSD_DOUBLE : XmlaHandler.XSD_STRING);
            }
            return null;
        }

        ValueInfo(String dataType, Object inputValue) {
            String valueTypeHint = ValueInfo.getValueTypeHint(dataType);
            if (valueTypeHint != null) {
                if (valueTypeHint.equals(XmlaHandler.XSD_STRING)) {
                    this.valueType = valueTypeHint;
                    this.value = inputValue;
                    this.isDecimal = false;
                } else if (valueTypeHint.equals(XmlaHandler.XSD_INT)) {
                    if (inputValue instanceof Integer) {
                        this.valueType = valueTypeHint;
                        this.value = inputValue;
                        this.isDecimal = false;
                    } else if (inputValue instanceof Byte) {
                        this.valueType = valueTypeHint;
                        this.value = inputValue;
                        this.isDecimal = false;
                    } else if (inputValue instanceof Short) {
                        this.valueType = valueTypeHint;
                        this.value = inputValue;
                        this.isDecimal = false;
                    } else if (inputValue instanceof Long) {
                        long lval = (Long)inputValue;
                        this.setValueAndType(lval);
                    } else if (inputValue instanceof BigInteger) {
                        BigInteger bi = (BigInteger)inputValue;
                        long lval = bi.longValue();
                        if (bi.equals(BigInteger.valueOf(lval))) {
                            this.setValueAndType(lval);
                        } else {
                            this.valueType = XmlaHandler.XSD_INTEGER;
                            this.value = inputValue;
                            this.isDecimal = false;
                        }
                    } else if (inputValue instanceof Float) {
                        Float f = (Float)inputValue;
                        long lval = f.longValue();
                        if (f.equals(new Float(lval))) {
                            this.setValueAndType(lval);
                        } else {
                            this.valueType = XmlaHandler.XSD_DOUBLE;
                            this.value = inputValue;
                            this.isDecimal = true;
                        }
                    } else if (inputValue instanceof Double) {
                        Double d = (Double)inputValue;
                        long lval = d.longValue();
                        if (d.equals(new Double(lval))) {
                            this.setValueAndType(lval);
                        } else {
                            this.valueType = XmlaHandler.XSD_DOUBLE;
                            this.value = inputValue;
                            this.isDecimal = true;
                        }
                    } else if (inputValue instanceof BigDecimal) {
                        BigDecimal bd = (BigDecimal)inputValue;
                        try {
                            long lval = bd.longValue();
                            this.setValueAndType(lval);
                        }
                        catch (ArithmeticException ex) {
                            try {
                                BigInteger bi = bd.toBigIntegerExact();
                                this.valueType = XmlaHandler.XSD_INTEGER;
                                this.value = bi;
                                this.isDecimal = false;
                            }
                            catch (ArithmeticException ex1) {
                                this.valueType = XmlaHandler.XSD_DECIMAL;
                                this.value = inputValue;
                                this.isDecimal = true;
                            }
                        }
                    } else if (inputValue instanceof Number) {
                        this.value = ((Number)inputValue).longValue();
                        this.valueType = valueTypeHint;
                        this.isDecimal = false;
                    } else {
                        this.valueType = valueTypeHint;
                        this.value = inputValue;
                        this.isDecimal = false;
                    }
                } else if (valueTypeHint.equals(XmlaHandler.XSD_DOUBLE)) {
                    if (inputValue instanceof Double) {
                        this.valueType = valueTypeHint;
                        this.value = inputValue;
                        this.isDecimal = true;
                    } else if (inputValue instanceof Byte || inputValue instanceof Short || inputValue instanceof Integer || inputValue instanceof Long) {
                        this.value = ((Number)inputValue).doubleValue();
                        this.valueType = valueTypeHint;
                        this.isDecimal = true;
                    } else if (inputValue instanceof Float) {
                        this.value = inputValue;
                        this.valueType = valueTypeHint;
                        this.isDecimal = true;
                    } else if (inputValue instanceof BigDecimal) {
                        BigDecimal bd = (BigDecimal)inputValue;
                        double dval = bd.doubleValue();
                        try {
                            BigDecimal bd2 = Util.makeBigDecimalFromDouble(dval);
                            if (bd.compareTo(bd2) == 0) {
                                this.valueType = XmlaHandler.XSD_DOUBLE;
                                this.value = dval;
                            } else {
                                this.valueType = XmlaHandler.XSD_DECIMAL;
                                this.value = inputValue;
                            }
                        }
                        catch (NumberFormatException ex) {
                            this.valueType = XmlaHandler.XSD_DECIMAL;
                            this.value = inputValue;
                        }
                        this.isDecimal = true;
                    } else if (inputValue instanceof BigInteger) {
                        BigInteger bi = (BigInteger)inputValue;
                        long lval = bi.longValue();
                        if (bi.equals(BigInteger.valueOf(lval))) {
                            this.setValueAndType(lval);
                        } else {
                            this.valueType = XmlaHandler.XSD_INTEGER;
                            this.value = inputValue;
                            this.isDecimal = true;
                        }
                    } else if (inputValue instanceof Number) {
                        this.value = ((Number)inputValue).doubleValue();
                        this.valueType = valueTypeHint;
                        this.isDecimal = true;
                    } else {
                        this.valueType = valueTypeHint;
                        this.value = inputValue;
                        this.isDecimal = true;
                    }
                }
            } else if (inputValue instanceof String) {
                this.valueType = XmlaHandler.XSD_STRING;
                this.value = inputValue;
                this.isDecimal = false;
            } else if (inputValue instanceof Integer) {
                this.valueType = XmlaHandler.XSD_INT;
                this.value = inputValue;
                this.isDecimal = false;
            } else if (inputValue instanceof Byte) {
                Byte b = (Byte)inputValue;
                this.valueType = XmlaHandler.XSD_INT;
                this.value = b.intValue();
                this.isDecimal = false;
            } else if (inputValue instanceof Short) {
                Short s = (Short)inputValue;
                this.valueType = XmlaHandler.XSD_INT;
                this.value = s.intValue();
                this.isDecimal = false;
            } else if (inputValue instanceof Long) {
                this.setValueAndType((Long)inputValue);
            } else if (inputValue instanceof BigInteger) {
                BigInteger bi = (BigInteger)inputValue;
                long lval = bi.longValue();
                if (bi.equals(BigInteger.valueOf(lval))) {
                    this.setValueAndType(lval);
                } else {
                    this.valueType = XmlaHandler.XSD_INTEGER;
                    this.value = inputValue;
                    this.isDecimal = false;
                }
            } else if (inputValue instanceof Float) {
                this.valueType = XmlaHandler.XSD_DOUBLE;
                this.value = inputValue;
                this.isDecimal = true;
            } else if (inputValue instanceof Double) {
                this.valueType = XmlaHandler.XSD_DOUBLE;
                this.value = inputValue;
                this.isDecimal = true;
            } else if (inputValue instanceof BigDecimal) {
                BigDecimal bd = (BigDecimal)inputValue;
                double dval = bd.doubleValue();
                try {
                    BigDecimal bd2 = Util.makeBigDecimalFromDouble(dval);
                    if (bd.compareTo(bd2) == 0) {
                        this.valueType = XmlaHandler.XSD_DOUBLE;
                        this.value = dval;
                    } else {
                        this.valueType = XmlaHandler.XSD_DECIMAL;
                        this.value = inputValue;
                    }
                }
                catch (NumberFormatException ex) {
                    this.valueType = XmlaHandler.XSD_DECIMAL;
                    this.value = inputValue;
                }
                this.isDecimal = true;
            } else if (inputValue instanceof Number) {
                this.value = ((Number)inputValue).longValue();
                this.valueType = XmlaHandler.XSD_LONG;
                this.isDecimal = false;
            } else {
                this.valueType = XmlaHandler.XSD_STRING;
                this.value = inputValue;
                this.isDecimal = false;
            }
        }

        private void setValueAndType(long lval) {
            if (!XmlaHandler.isValidXsdInt(lval)) {
                this.valueType = XmlaHandler.XSD_LONG;
                this.value = lval;
            } else {
                this.valueType = XmlaHandler.XSD_INT;
                this.value = (int)lval;
            }
            this.isDecimal = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SetType {
        ROW_SET,
        MD_DATA_SET;

    }
}

