/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import mondrian.olap.Evaluator;
import mondrian.olap.Member;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.rolap.RolapAggregationManager;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.agg.ListColumnPredicate;
import mondrian.rolap.agg.LiteralStarPredicate;
import mondrian.rolap.agg.MemberColumnPredicate;
import mondrian.rolap.aggmatcher.AggStar;
import mondrian.rolap.sql.SqlQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlConstraintUtils {
    private SqlConstraintUtils() {
    }

    public static void addContextConstraint(SqlQuery sqlQuery, AggStar aggStar, Evaluator evaluator, boolean restrictMemberTypes) {
        CellRequest request;
        Member[] members = evaluator.getMembers();
        if (restrictMemberTypes) {
            if (SqlConstraintUtils.containsCalculatedMember(members)) {
                throw Util.newInternal("can not restrict SQL to calculated Members");
            }
        } else {
            members = SqlConstraintUtils.removeCalculatedMembers(members);
            members = SqlConstraintUtils.removeDefaultMembers(members);
        }
        if ((request = RolapAggregationManager.makeRequest(members)) == null) {
            if (restrictMemberTypes) {
                throw Util.newInternal("CellRequest is null - why?");
            }
            return;
        }
        RolapStar.Column[] columns = request.getConstrainedColumns();
        Object[] values = request.getSingleValues();
        int arity = columns.length;
        for (int i = 0; i < arity; ++i) {
            String expr;
            RolapStar.Column column = columns[i];
            if (aggStar != null) {
                int bitPos = column.getBitPosition();
                AggStar.Table.Column aggColumn = aggStar.lookupColumn(bitPos);
                AggStar.Table table = aggColumn.getTable();
                table.addToFrom(sqlQuery, false, true);
                expr = aggColumn.generateExprString(sqlQuery);
            } else {
                RolapStar.Table table = column.getTable();
                table.addToFrom(sqlQuery, false, true);
                expr = column.generateExprString(sqlQuery);
            }
            String value = String.valueOf(values[i]);
            if (RolapUtil.mdxNullLiteral.equalsIgnoreCase(value)) {
                sqlQuery.addWhere(expr, " is ", "null");
                continue;
            }
            if (column.getDatatype().isNumeric()) {
                Double.valueOf(value);
            }
            StringBuilder buf = new StringBuilder();
            sqlQuery.getDialect().quote(buf, value, column.getDatatype());
            sqlQuery.addWhere(expr, " = ", buf.toString());
        }
    }

    private static Member[] removeDefaultMembers(Member[] members) {
        ArrayList<Member> result = new ArrayList<Member>();
        result.add(members[0]);
        for (int i = 1; i < members.length; ++i) {
            Member m = members[i];
            if (m.getHierarchy().getDefaultMember().equals(m)) continue;
            result.add(m);
        }
        return result.toArray(new Member[result.size()]);
    }

    static Member[] removeCalculatedMembers(Member[] members) {
        ArrayList<Member> result = new ArrayList<Member>();
        for (Member member : members) {
            if (member.isCalculated()) continue;
            result.add(member);
        }
        return result.toArray(new Member[result.size()]);
    }

    public static boolean containsCalculatedMember(Member[] members) {
        for (Member member : members) {
            if (!member.isCalculated()) continue;
            return true;
        }
        return false;
    }

    public static void joinLevelTableToFactTable(SqlQuery sqlQuery, RolapCube baseCube, AggStar aggStar, Evaluator e, RolapCubeLevel level) {
        RolapStar.Column starColumn = level.getBaseStarKeyColumn(baseCube);
        if (aggStar != null) {
            int bitPos = starColumn.getBitPosition();
            AggStar.Table.Column aggColumn = aggStar.lookupColumn(bitPos);
            AggStar.Table table = aggColumn.getTable();
            table.addToFrom(sqlQuery, false, true);
        } else {
            RolapStar.Table table = starColumn.getTable();
            assert (table != null);
            table.addToFrom(sqlQuery, false, true);
        }
    }

    public static void addMemberConstraint(SqlQuery sqlQuery, RolapCube baseCube, AggStar aggStar, RolapMember parent, boolean restrictMemberTypes) {
        List<RolapMember> list = Collections.singletonList(parent);
        SqlConstraintUtils.addMemberConstraint(sqlQuery, baseCube, aggStar, list, restrictMemberTypes, false);
    }

    public static void addMemberConstraint(SqlQuery sqlQuery, RolapCube baseCube, AggStar aggStar, List<RolapMember> members, boolean restrictMemberTypes, boolean crossJoin) {
        RolapMember firstUniqueParent;
        if (members.size() == 0) {
            sqlQuery.addWhere("(1 = 0)");
            return;
        }
        RolapMember member = members.get(0);
        RolapLevel memberLevel = member.getLevel();
        RolapLevel firstUniqueParentLevel = null;
        for (firstUniqueParent = member; firstUniqueParent != null && !firstUniqueParent.getLevel().isUnique(); firstUniqueParent = firstUniqueParent.getParentMember()) {
        }
        if (firstUniqueParent != null) {
            firstUniqueParentLevel = firstUniqueParent.getLevel();
        }
        String condition = "(";
        if (crossJoin && !memberLevel.isUnique() && !SqlConstraintUtils.membersAreCrossProduct(members)) {
            assert (member.getParentMember() != null);
            condition = condition + SqlConstraintUtils.constrainMultiLevelMembers(sqlQuery, baseCube, members, firstUniqueParentLevel, restrictMemberTypes);
        } else {
            condition = condition + SqlConstraintUtils.generateSingleValueInExpr(sqlQuery, baseCube, members, firstUniqueParentLevel, restrictMemberTypes);
        }
        if (condition.length() > 1) {
            condition = condition + ")";
            sqlQuery.addWhere(condition);
        }
    }

    private static StarColumnPredicate getColumnPredicates(RolapStar.Column column, Collection<RolapMember> members) {
        switch (members.size()) {
            case 0: {
                return new LiteralStarPredicate(column, false);
            }
            case 1: {
                return new MemberColumnPredicate(column, members.iterator().next());
            }
        }
        ArrayList<StarColumnPredicate> predicateList = new ArrayList<StarColumnPredicate>();
        for (RolapMember member : members) {
            predicateList.add(new MemberColumnPredicate(column, member));
        }
        return new ListColumnPredicate(column, predicateList);
    }

    private static LinkedHashSet<RolapMember> getUniqueParentMembers(Collection<RolapMember> members) {
        LinkedHashSet<RolapMember> set = new LinkedHashSet<RolapMember>();
        for (RolapMember m : members) {
            if ((m = m.getParentMember()) == null) continue;
            set.add(m);
        }
        return set;
    }

    private static String constrainMultiLevelMembers(SqlQuery sqlQuery, RolapCube baseCube, List<RolapMember> members, RolapLevel fromLevel, boolean restrictMemberTypes) {
        LinkedHashMap<RolapMember, List<RolapMember>> parentChildrenMap = new LinkedHashMap<RolapMember, List<RolapMember>>();
        String condition = "";
        if (sqlQuery.getDialect().supportsMultiValueInExpr()) {
            condition = condition + SqlConstraintUtils.generateMultiValueInExpr(sqlQuery, baseCube, members, fromLevel, restrictMemberTypes, parentChildrenMap);
            if (parentChildrenMap.isEmpty()) {
                return condition;
            }
        } else {
            for (RolapMember m : members) {
                if (m.isCalculated()) {
                    if (!restrictMemberTypes) continue;
                    throw Util.newInternal("addMemberConstraint: cannot restrict SQL to calculated member :" + m);
                }
                RolapMember p = m.getParentMember();
                ArrayList<RolapMember> childrenList = (ArrayList<RolapMember>)parentChildrenMap.get(p);
                if (childrenList == null) {
                    childrenList = new ArrayList<RolapMember>();
                    parentChildrenMap.put(p, childrenList);
                }
                childrenList.add(m);
            }
        }
        boolean firstParent = true;
        if (condition.length() > 0) {
            firstParent = false;
        }
        RolapLevel memberLevel = members.get(0).getLevel();
        for (RolapMember p : parentChildrenMap.keySet()) {
            if (!firstParent) {
                condition = condition + " or ";
            }
            condition = condition + "(";
            boolean firstLevel = true;
            for (RolapMember gp = p; gp != null; gp = gp.getParentMember()) {
                if (gp.isAll()) continue;
                RolapLevel level = gp.getLevel();
                if (firstParent) {
                    RolapHierarchy hierarchy = level.getHierarchy();
                    RolapStar.Column column = null;
                    if (level instanceof RolapCubeLevel) {
                        column = ((RolapCubeLevel)level).getBaseStarKeyColumn(baseCube);
                    }
                    if (column != null) {
                        RolapStar.Table targetTable = column.getTable();
                        hierarchy.addToFrom(sqlQuery, targetTable);
                    } else {
                        hierarchy.addToFrom(sqlQuery, level.getKeyExp());
                    }
                }
                if (!firstLevel) {
                    condition = condition + " and ";
                } else {
                    firstLevel = false;
                }
                condition = condition + SqlConstraintUtils.constrainLevel(level, sqlQuery, baseCube, SqlConstraintUtils.getColumnValue(gp.getKey(), sqlQuery.getDialect(), level.getDatatype()), false);
                if (gp.getLevel() == fromLevel) break;
            }
            firstParent = false;
            List children = (List)parentChildrenMap.get(p);
            if (!children.isEmpty()) {
                HashMap<RolapMember, List<RolapMember>> tmpParentChildrenMap = new HashMap<RolapMember, List<RolapMember>>();
                condition = condition + " and ";
                RolapLevel childrenLevel = (RolapLevel)p.getLevel().getChildLevel();
                if (sqlQuery.getDialect().supportsMultiValueInExpr() && childrenLevel != memberLevel) {
                    condition = condition + SqlConstraintUtils.generateMultiValueInExpr(sqlQuery, baseCube, children, childrenLevel, restrictMemberTypes, tmpParentChildrenMap);
                    assert (tmpParentChildrenMap.isEmpty());
                } else {
                    assert (childrenLevel == memberLevel);
                    condition = condition + SqlConstraintUtils.generateSingleValueInExpr(sqlQuery, baseCube, children, childrenLevel, restrictMemberTypes);
                }
            }
            condition = condition + ")";
        }
        return condition;
    }

    private static boolean membersAreCrossProduct(List<RolapMember> members) {
        int crossProdSize = SqlConstraintUtils.getNumUniqueMemberKeys(members);
        LinkedHashSet<RolapMember> parents = SqlConstraintUtils.getUniqueParentMembers(members);
        while (!parents.isEmpty()) {
            crossProdSize *= parents.size();
            parents = SqlConstraintUtils.getUniqueParentMembers(parents);
        }
        return crossProdSize == members.size();
    }

    private static int getNumUniqueMemberKeys(List<RolapMember> members) {
        HashSet<Object> set = new HashSet<Object>();
        for (RolapMember m : members) {
            set.add(m.getKey());
        }
        return set.size();
    }

    private static String getColumnValue(Object key, SqlQuery.Dialect dialect, SqlQuery.Datatype datatype) {
        if (key != RolapUtil.sqlNullValue) {
            return key.toString();
        }
        return RolapUtil.mdxNullLiteral;
    }

    public static String constrainLevel(RolapLevel level, SqlQuery query, RolapCube baseCube, String columnValue, boolean caseSensitive) {
        String constraint;
        String columnString;
        SqlQuery.Datatype datatype;
        RolapStar.Column column = null;
        if (level instanceof RolapCubeLevel) {
            column = ((RolapCubeLevel)level).getBaseStarKeyColumn(baseCube);
        }
        if (column != null) {
            if (column.getNameColumn() == null) {
                datatype = level.getDatatype();
            } else {
                column = column.getNameColumn();
                datatype = SqlQuery.Datatype.String;
            }
            columnString = column.generateExprString(query);
        } else {
            MondrianDef.Expression exp = level.getNameExp();
            if (exp == null) {
                exp = level.getKeyExp();
                datatype = level.getDatatype();
            } else {
                datatype = SqlQuery.Datatype.String;
            }
            columnString = exp.getExpression(query);
        }
        if (RolapUtil.mdxNullLiteral.equalsIgnoreCase(columnValue)) {
            constraint = columnString + " is " + "null";
        } else {
            if (datatype.isNumeric()) {
                Double.valueOf(columnValue);
            }
            StringBuilder buf = new StringBuilder();
            query.getDialect().quote(buf, columnValue, datatype);
            String value = buf.toString();
            if (caseSensitive && datatype == SqlQuery.Datatype.String && !MondrianProperties.instance().CaseSensitive.get()) {
                columnString = query.getDialect().toUpper(columnString);
                value = query.getDialect().toUpper(value);
            }
            constraint = columnString + " = " + value;
        }
        return constraint;
    }

    private static String generateMultiValueInExpr(SqlQuery sqlQuery, RolapCube baseCube, List<RolapMember> members, RolapLevel fromLevel, boolean restrictMemberTypes, Map<RolapMember, List<RolapMember>> parentWithNullToChildrenMap) {
        StringBuilder columnBuf = new StringBuilder();
        StringBuilder valueBuf = new StringBuilder();
        columnBuf.append("(");
        boolean isFirstLevelInMultiple = true;
        for (RolapMember m = members.get(0); m != null; m = m.getParentMember()) {
            if (m.isAll()) continue;
            RolapLevel level = m.getLevel();
            RolapHierarchy hierarchy = level.getHierarchy();
            RolapStar.Column column = null;
            if (level instanceof RolapCubeLevel) {
                column = ((RolapCubeLevel)level).getBaseStarKeyColumn(baseCube);
            }
            String columnString = null;
            if (column != null) {
                RolapStar.Table targetTable = column.getTable();
                hierarchy.addToFrom(sqlQuery, targetTable);
                RolapStar.Column nameColumn = column.getNameColumn();
                if (nameColumn == null) {
                    nameColumn = column;
                }
                columnString = nameColumn.generateExprString(sqlQuery);
            } else {
                hierarchy.addToFrom(sqlQuery, level.getKeyExp());
                MondrianDef.Expression nameExp = level.getNameExp();
                if (nameExp == null) {
                    nameExp = level.getKeyExp();
                }
                columnString = nameExp.getExpression(sqlQuery);
            }
            if (!isFirstLevelInMultiple) {
                columnBuf.append(",");
            } else {
                isFirstLevelInMultiple = false;
            }
            columnBuf.append(columnString);
            if (m.getLevel() == fromLevel) break;
        }
        columnBuf.append(")");
        valueBuf.append("(");
        boolean isFirstMember = true;
        for (RolapMember m : members) {
            if (m.isCalculated()) {
                if (!restrictMemberTypes) continue;
                throw Util.newInternal("addMemberConstraint: cannot restrict SQL to calculated member :" + m);
            }
            isFirstLevelInMultiple = true;
            String memberString = "(";
            boolean containsNull = false;
            for (RolapMember p = m; p != null; p = p.getParentMember()) {
                if (p.isAll()) continue;
                RolapLevel level = p.getLevel();
                String value = SqlConstraintUtils.getColumnValue(p.getKey(), sqlQuery.getDialect(), level.getDatatype());
                if (RolapUtil.mdxNullLiteral.equalsIgnoreCase(value)) {
                    List<RolapMember> childrenList = parentWithNullToChildrenMap.get(p);
                    if (childrenList == null) {
                        childrenList = new ArrayList<RolapMember>();
                        parentWithNullToChildrenMap.put(p, childrenList);
                    }
                    if (m != p) {
                        childrenList.add(m);
                    }
                    containsNull = true;
                    break;
                }
                if (isFirstLevelInMultiple) {
                    isFirstLevelInMultiple = false;
                } else {
                    memberString = memberString + ",";
                }
                StringBuilder buf = new StringBuilder();
                sqlQuery.getDialect().quote(buf, value, level.getDatatype());
                memberString = memberString + buf.toString();
                if (p.getLevel() == fromLevel) break;
            }
            if (containsNull) continue;
            memberString = memberString + ")";
            if (!isFirstMember) {
                valueBuf.append(",");
            }
            valueBuf.append(memberString);
            isFirstMember = false;
        }
        String condition = "";
        if (!isFirstMember) {
            valueBuf.append(")");
            condition = condition + columnBuf.toString() + " in " + valueBuf.toString();
        }
        return condition;
    }

    private static String generateSingleValueInExpr(SqlQuery sqlQuery, RolapCube baseCube, List<RolapMember> members, RolapLevel fromLevel, boolean restrictMemberTypes) {
        int maxConstraints = MondrianProperties.instance().MaxConstraints.get();
        String condition = "";
        boolean firstLevel = true;
        SequencedCollection<RolapMember> c = members;
        while (!c.isEmpty()) {
            RolapMember m = (RolapMember)c.iterator().next();
            if (!m.isAll()) {
                if (m.isCalculated()) {
                    if (restrictMemberTypes) {
                        throw Util.newInternal("addMemberConstraint: cannot restrict SQL to calculated member :" + m);
                    }
                } else {
                    String where;
                    RolapLevel level = m.getLevel();
                    RolapHierarchy hierarchy = level.getHierarchy();
                    RolapStar.Column column = null;
                    if (level instanceof RolapCubeLevel) {
                        column = ((RolapCubeLevel)level).getBaseStarKeyColumn(baseCube);
                    }
                    StarColumnPredicate cc = SqlConstraintUtils.getColumnPredicates(column, c);
                    String q = null;
                    if (column != null) {
                        RolapStar.Table targetTable = column.getTable();
                        hierarchy.addToFrom(sqlQuery, targetTable);
                        q = column.generateExprString(sqlQuery);
                    } else {
                        hierarchy.addToFrom(sqlQuery, level.getKeyExp());
                        q = level.getKeyExp().getExpression(sqlQuery);
                    }
                    if (!(cc instanceof ListColumnPredicate && ((ListColumnPredicate)cc).getPredicates().size() > maxConstraints || (where = RolapStar.Column.createInExpr(q, cc, level.getDatatype(), sqlQuery)).equals("true"))) {
                        if (!firstLevel) {
                            condition = condition + " and ";
                        } else {
                            firstLevel = false;
                        }
                        condition = condition + where;
                    }
                    if (m.getLevel().isUnique() || m.getLevel() == fromLevel) break;
                }
            }
            c = SqlConstraintUtils.getUniqueParentMembers(c);
        }
        return condition;
    }
}

