/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import mondrian.olap.Cube;
import mondrian.olap.DimensionBase;
import mondrian.olap.DimensionType;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.MondrianDef;
import mondrian.olap.Schema;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapUtil;
import org.apache.log4j.Logger;

class RolapDimension
extends DimensionBase {
    private static final Logger LOGGER = Logger.getLogger(RolapDimension.class);
    private final Schema schema;

    RolapDimension(Schema schema, String name, DimensionType dimensionType) {
        super(name, dimensionType);
        this.schema = schema;
        this.hierarchies = new RolapHierarchy[0];
    }

    RolapDimension(RolapSchema schema, RolapCube cube, MondrianDef.Dimension xmlDimension, MondrianDef.CubeDimension xmlCubeDimension) {
        this(schema, xmlDimension.name, xmlDimension.getDimensionType());
        int i;
        Util.assertPrecondition(schema != null);
        if (cube != null) {
            Util.assertTrue(cube.getSchema() == schema);
        }
        if (!Util.isEmpty(xmlDimension.caption)) {
            this.setCaption(xmlDimension.caption);
        }
        this.hierarchies = new RolapHierarchy[xmlDimension.hierarchies.length];
        for (i = 0; i < xmlDimension.hierarchies.length; ++i) {
            if (xmlDimension.hierarchies[i].relation == null && xmlDimension.hierarchies[i].memberReaderClass == null && cube != null) {
                xmlDimension.hierarchies[i].relation = cube.fact;
            }
            RolapHierarchy hierarchy = new RolapHierarchy(this, xmlDimension.hierarchies[i], xmlCubeDimension);
            this.hierarchies[i] = hierarchy;
        }
        if (this.dimensionType == null) {
            for (i = 0; i < this.hierarchies.length; ++i) {
                Level[] levels = this.hierarchies[i].getLevels();
                for (int j = 0; j < levels.length; ++j) {
                    Level lev = levels[j];
                    if (lev.isAll()) continue;
                    if (this.dimensionType == null) {
                        this.dimensionType = lev.getLevelType().isTime() ? DimensionType.TimeDimension : (this.isMeasures() ? DimensionType.MeasuresDimension : DimensionType.StandardDimension);
                        continue;
                    }
                    if (this.dimensionType == DimensionType.TimeDimension && !lev.getLevelType().isTime() && !lev.isAll()) {
                        throw MondrianResource.instance().NonTimeLevelInTimeHierarchy.ex(this.getUniqueName());
                    }
                    if (this.dimensionType == DimensionType.TimeDimension || !lev.getLevelType().isTime()) continue;
                    throw MondrianResource.instance().TimeLevelInNonTimeHierarchy.ex(this.getUniqueName());
                }
            }
        }
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    void init(MondrianDef.CubeDimension xmlDimension) {
        for (int i = 0; i < this.hierarchies.length; ++i) {
            if (this.hierarchies[i] == null) continue;
            ((RolapHierarchy)this.hierarchies[i]).init(xmlDimension);
        }
    }

    RolapHierarchy newHierarchy(String subName, boolean hasAll) {
        RolapHierarchy hierarchy = new RolapHierarchy(this, subName, hasAll);
        this.hierarchies = RolapUtil.addElement(this.hierarchies, hierarchy);
        return hierarchy;
    }

    public Hierarchy getHierarchy() {
        return this.hierarchies[0];
    }

    public int getOrdinal(Cube cube) {
        assert (this.isMeasures());
        return 0;
    }

    public Schema getSchema() {
        return this.schema;
    }
}

