/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap4j;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.Property;
import mondrian.olap.SchemaReader;
import mondrian.olap4j.MondrianOlap4jConnection;
import mondrian.olap4j.MondrianOlap4jDimension;
import mondrian.olap4j.MondrianOlap4jHierarchy;
import mondrian.olap4j.MondrianOlap4jProperty;
import mondrian.olap4j.MondrianOlap4jSchema;
import org.olap4j.impl.ArrayNamedListImpl;
import org.olap4j.impl.Named;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Level;
import org.olap4j.metadata.NamedList;
import org.olap4j.metadata.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MondrianOlap4jLevel
implements org.olap4j.metadata.Level,
Named {
    private final MondrianOlap4jSchema olap4jSchema;
    private final Level level;

    MondrianOlap4jLevel(MondrianOlap4jSchema olap4jSchema, Level level) {
        this.olap4jSchema = olap4jSchema;
        this.level = level;
    }

    public boolean equals(Object obj) {
        return obj instanceof MondrianOlap4jLevel && this.level.equals(((MondrianOlap4jLevel)obj).level);
    }

    public int hashCode() {
        return this.level.hashCode();
    }

    public int getDepth() {
        return this.level.getDepth();
    }

    public Hierarchy getHierarchy() {
        return new MondrianOlap4jHierarchy(this.olap4jSchema, this.level.getHierarchy());
    }

    public Dimension getDimension() {
        return new MondrianOlap4jDimension(this.olap4jSchema, this.level.getDimension());
    }

    public Level.Type getLevelType() {
        throw new UnsupportedOperationException();
    }

    public NamedList<org.olap4j.metadata.Property> getProperties() {
        ArrayNamedListImpl<org.olap4j.metadata.Property> list = new ArrayNamedListImpl<org.olap4j.metadata.Property>(){

            protected String getName(org.olap4j.metadata.Property property) {
                return property.getName();
            }
        };
        list.addAll(Arrays.asList(Property.StandardMemberProperty.values()));
        for (Property property : this.level.getProperties()) {
            list.add((Object)new MondrianOlap4jProperty(property));
        }
        return list;
    }

    public List<org.olap4j.metadata.Member> getMembers() {
        final MondrianOlap4jConnection olap4jConnection = this.olap4jSchema.olap4jCatalog.olap4jDatabaseMetaData.olap4jConnection;
        SchemaReader schemaReader = olap4jConnection.connection.getSchemaReader();
        final Member[] levelMembers = schemaReader.getLevelMembers(this.level, true);
        return new AbstractList<org.olap4j.metadata.Member>(){

            @Override
            public org.olap4j.metadata.Member get(int index) {
                return olap4jConnection.toOlap4j(levelMembers[index]);
            }

            @Override
            public int size() {
                return levelMembers.length;
            }
        };
    }

    public String getName() {
        return this.level.getName();
    }

    public String getUniqueName() {
        return this.level.getUniqueName();
    }

    public String getCaption(Locale locale) {
        return this.level.getCaption();
    }

    public String getDescription(Locale locale) {
        return this.level.getDescription();
    }

    public int getCardinality() {
        return this.level.getApproxRowCount();
    }
}

