/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.impl.AbstractDoubleCalc;
import mondrian.calc.impl.ValueCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.FunDef;
import mondrian.olap.fun.AbstractAggregateFunDef;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.ReflectiveMultiResolver;
import mondrian.olap.fun.Resolver;

class VarPFunDef
extends AbstractAggregateFunDef {
    static final Resolver VariancePResolver = new ReflectiveMultiResolver("VarianceP", "VarianceP(<Set>[, <Numeric Expression>])", "Alias for VarP.", new String[]{"fnx", "fnxn"}, VarPFunDef.class);
    static final Resolver VarPResolver = new ReflectiveMultiResolver("VarP", "VarP(<Set>[, <Numeric Expression>])", "Returns the variance of a numeric expression evaluated over a set (biased).", new String[]{"fnx", "fnxn"}, VarPFunDef.class);

    public VarPFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final ListCalc listCalc = compiler.compileList(call.getArg(0));
        final ValueCalc calc = call.getArgCount() > 1 ? compiler.compileScalar(call.getArg(1), true) : new ValueCalc(call);
        return new AbstractDoubleCalc(call, new Calc[]{listCalc, calc}){

            public double evaluateDouble(Evaluator evaluator) {
                List memberList = AbstractAggregateFunDef.evaluateCurrentList(listCalc, evaluator);
                return (Double)FunUtil.var(evaluator.push(), memberList, calc, true);
            }

            public boolean dependsOn(Dimension dimension) {
                return 1.anyDependsButFirst(this.getCalcs(), dimension);
            }
        };
    }
}

