/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.Collections;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.IntegerCalc;
import mondrian.calc.ListCalc;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.FunDef;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.ReflectiveMultiResolver;

class SubsetFunDef
extends FunDefBase {
    static final ReflectiveMultiResolver Resolver = new ReflectiveMultiResolver("Subset", "Subset(<Set>, <Start>[, <Count>])", "Returns a subset of elements from a set.", new String[]{"fxxn", "fxxnn"}, SubsetFunDef.class);

    public SubsetFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final ListCalc listCalc = compiler.compileList(call.getArg(0));
        final IntegerCalc startCalc = compiler.compileInteger(call.getArg(1));
        final IntegerCalc countCalc = call.getArgCount() > 2 ? compiler.compileInteger(call.getArg(2)) : null;
        return new AbstractListCalc(call, new Calc[]{listCalc, startCalc, countCalc}){

            public List evaluateList(Evaluator evaluator) {
                int end;
                List list = listCalc.evaluateList(evaluator);
                int start = startCalc.evaluateInteger(evaluator);
                if (countCalc != null) {
                    int count = countCalc.evaluateInteger(evaluator);
                    end = start + count;
                } else {
                    end = list.size();
                }
                if (end > list.size()) {
                    end = list.size();
                }
                if (start >= end || start < 0) {
                    return Collections.EMPTY_LIST;
                }
                assert (0 <= start);
                assert (start < end);
                assert (end <= list.size());
                if (start == 0 && end == list.size()) {
                    return list;
                }
                return list.subList(start, end);
            }
        };
    }
}

