/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.IterCalc;
import mondrian.calc.ListCalc;
import mondrian.calc.MemberCalc;
import mondrian.calc.ResultStyle;
import mondrian.calc.TupleCalc;
import mondrian.calc.VoidCalc;
import mondrian.calc.impl.AbstractIterCalc;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.calc.impl.AbstractVoidCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.FunDef;
import mondrian.olap.Member;
import mondrian.olap.ResultStyleException;
import mondrian.olap.Syntax;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.Resolver;
import mondrian.olap.fun.ResolverBase;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.Type;
import mondrian.olap.type.TypeUtil;
import mondrian.resource.MondrianResource;

public class SetFunDef
extends FunDefBase {
    static final ResolverImpl Resolver = new ResolverImpl();

    SetFunDef(Resolver resolver, int[] argTypes) {
        super(resolver, 8, argTypes);
    }

    public void unparse(Exp[] args, PrintWriter pw) {
        ExpBase.unparseList(pw, args, "{", ", ", "}");
    }

    public Type getResultType(Validator validator, Exp[] args) {
        Type type0 = null;
        if (args.length == 0) {
            type0 = MemberType.Unknown;
        } else {
            for (int i = 0; i < args.length; ++i) {
                Exp arg = args[i];
                Type type = arg.getType();
                type = TypeUtil.toMemberOrTupleType(type);
                if (i == 0) {
                    type0 = type;
                    continue;
                }
                if (TypeUtil.isUnionCompatible(type0, type)) continue;
                throw MondrianResource.instance().ArgsMustHaveSameHierarchy.ex(this.getName());
            }
        }
        return new SetType(type0);
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        Exp[] args = call.getArgs();
        return new ListSetCalc(call, args, compiler, ResultStyle.LIST_MUTABLELIST);
    }

    private static class ResolverImpl
    extends ResolverBase {
        public ResolverImpl() {
            super("{}", "{<Member> [, <Member>...]}", "Brace operator constructs a set.", Syntax.Braces);
        }

        public FunDef resolve(Exp[] args, Validator validator, int[] conversionCount) {
            int[] parameterTypes = new int[args.length];
            for (int i = 0; i < args.length; ++i) {
                if (validator.canConvert(args[i], 6, conversionCount)) {
                    parameterTypes[i] = 6;
                    continue;
                }
                if (validator.canConvert(args[i], 8, conversionCount)) {
                    parameterTypes[i] = 8;
                    continue;
                }
                if (validator.canConvert(args[i], 10, conversionCount)) {
                    parameterTypes[i] = 10;
                    continue;
                }
                return null;
            }
            return new SetFunDef(this, parameterTypes);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IterSetCalc
    extends AbstractIterCalc {
        private final IterCalc[] iterCalcs;

        public IterSetCalc(Exp exp, Exp[] args, ExpCompiler compiler, List<ResultStyle> resultStyles) {
            super(exp, null);
            this.iterCalcs = this.compileSelf(args, compiler, resultStyles);
        }

        @Override
        public Calc[] getCalcs() {
            return this.iterCalcs;
        }

        private IterCalc[] compileSelf(Exp[] args, ExpCompiler compiler, List<ResultStyle> resultStyles) {
            IterCalc[] iterCalcs = new IterCalc[args.length];
            for (int i = 0; i < args.length; ++i) {
                iterCalcs[i] = this.createCalc(args[i], compiler, resultStyles);
            }
            return iterCalcs;
        }

        private IterCalc createCalc(Exp arg, ExpCompiler compiler, List<ResultStyle> resultStyles) {
            Type type = arg.getType();
            if (type instanceof SetType) {
                final Calc calc = compiler.compileAs(arg, null, resultStyles);
                Type elementType = ((SetType)type).getElementType();
                if (elementType instanceof MemberType) {
                    switch (calc.getResultStyle()) {
                        case ITERABLE: {
                            return new AbstractIterCalc(arg, new Calc[]{calc}){
                                private final IterCalc iterCalc;
                                {
                                    super(x0, x1);
                                    this.iterCalc = (IterCalc)calc;
                                }

                                public Iterable evaluateIterable(Evaluator evaluator) {
                                    return this.iterCalc.evaluateIterable(evaluator);
                                }

                                protected String getName() {
                                    return "Sublist";
                                }
                            };
                        }
                        case LIST: 
                        case MUTABLE_LIST: {
                            return new AbstractIterCalc(arg, new Calc[]{calc}){
                                private final ListCalc listCalc;
                                {
                                    super(x0, x1);
                                    this.listCalc = (ListCalc)calc;
                                }

                                public Iterable evaluateIterable(Evaluator evaluator) {
                                    ArrayList<Member> result = new ArrayList<Member>();
                                    List list = this.listCalc.evaluateList(evaluator);
                                    for (Member member : list) {
                                        if (member == null || member.isNull()) continue;
                                        result.add(member);
                                    }
                                    return result;
                                }

                                protected String getName() {
                                    return "Sublist";
                                }
                            };
                        }
                    }
                    throw ResultStyleException.generateBadType(ResultStyle.ITERABLE_LIST_MUTABLELIST, calc.getResultStyle());
                }
                switch (calc.getResultStyle()) {
                    case ITERABLE: {
                        return new AbstractIterCalc(arg, new Calc[]{calc}){
                            private final IterCalc iterCalc;
                            {
                                super(x0, x1);
                                this.iterCalc = (IterCalc)calc;
                            }

                            public Iterable evaluateIterable(Evaluator evaluator) {
                                return this.iterCalc.evaluateIterable(evaluator);
                            }

                            protected String getName() {
                                return "Sublist";
                            }
                        };
                    }
                    case LIST: 
                    case MUTABLE_LIST: {
                        return new AbstractIterCalc(arg, new Calc[]{calc}){
                            private final ListCalc listCalc;
                            {
                                super(x0, x1);
                                this.listCalc = (ListCalc)calc;
                            }

                            public Iterable evaluateIterable(Evaluator evaluator) {
                                ArrayList<Member[]> result = new ArrayList<Member[]>();
                                List list = this.listCalc.evaluateList(evaluator);
                                Iterator i$ = list.iterator();
                                block0: while (i$.hasNext()) {
                                    Member[] members;
                                    for (Member member : members = (Member[])i$.next()) {
                                        if (member == null || member.isNull()) continue block0;
                                    }
                                    result.add(members);
                                }
                                return result;
                            }

                            protected String getName() {
                                return "Sublist";
                            }
                        };
                    }
                }
                throw ResultStyleException.generateBadType(ResultStyle.ITERABLE_LIST_MUTABLELIST, calc.getResultStyle());
            }
            if (TypeUtil.couldBeMember(type)) {
                final MemberCalc memberCalc = compiler.compileMember(arg);
                ResolvedFunCall call = this.wrapAsSet(arg);
                return new AbstractIterCalc(call, new Calc[]{memberCalc}){

                    public Iterable evaluateIterable(Evaluator evaluator) {
                        final Member member = memberCalc.evaluateMember(evaluator);
                        return new Iterable<Member>(){

                            @Override
                            public Iterator<Member> iterator() {
                                return new Iterator<Member>(){
                                    private Member m;
                                    {
                                        this.m = member;
                                    }

                                    @Override
                                    public boolean hasNext() {
                                        return this.m != null;
                                    }

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public Member next() {
                                        try {
                                            Member member = this.m;
                                            return member;
                                        }
                                        finally {
                                            this.m = null;
                                        }
                                    }

                                    @Override
                                    public void remove() {
                                        throw new UnsupportedOperationException("remove");
                                    }
                                };
                            }
                        };
                    }

                    protected String getName() {
                        return "Sublist";
                    }
                };
            }
            final TupleCalc tupleCalc = compiler.compileTuple(arg);
            ResolvedFunCall call = this.wrapAsSet(arg);
            return new AbstractIterCalc(call, new Calc[]{tupleCalc}){

                public Iterable evaluateIterable(Evaluator evaluator) {
                    final Member[] members = tupleCalc.evaluateTuple(evaluator);
                    return new Iterable<Member[]>(){

                        @Override
                        public Iterator<Member[]> iterator() {
                            return new Iterator<Member[]>(){
                                private Member[] m;
                                {
                                    this.m = members;
                                }

                                @Override
                                public boolean hasNext() {
                                    return this.m != null;
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public Member[] next() {
                                    try {
                                        Member[] memberArray = this.m;
                                        return memberArray;
                                    }
                                    finally {
                                        this.m = null;
                                    }
                                }

                                @Override
                                public void remove() {
                                    throw new UnsupportedOperationException("remove");
                                }
                            };
                        }
                    };
                }

                protected String getName() {
                    return "Sublist";
                }
            };
        }

        private ResolvedFunCall wrapAsSet(Exp arg) {
            return new ResolvedFunCall(new SetFunDef(Resolver, new int[]{arg.getCategory()}), new Exp[]{arg}, new SetType(arg.getType()));
        }

        @Override
        public Iterable evaluateIterable(final Evaluator evaluator) {
            return new Iterable<Member>(){

                @Override
                public Iterator<Member> iterator() {
                    return new Iterator<Member>(){
                        int index = 0;
                        Iterator<Member> currentIterator = null;
                        Member member = null;

                        @Override
                        public boolean hasNext() {
                            if (this.member != null) {
                                return true;
                            }
                            if (this.currentIterator == null) {
                                if (this.index >= IterSetCalc.this.iterCalcs.length) {
                                    return false;
                                }
                                IterCalc iterCalc = IterSetCalc.this.iterCalcs[this.index++];
                                Iterable iter = iterCalc.evaluateIterable(evaluator);
                                this.currentIterator = iter.iterator();
                            }
                            do {
                                boolean b = this.currentIterator.hasNext();
                                while (!b) {
                                    if (this.index >= IterSetCalc.this.iterCalcs.length) {
                                        return false;
                                    }
                                    IterCalc iterCalc = IterSetCalc.this.iterCalcs[this.index++];
                                    Iterable iter = iterCalc.evaluateIterable(evaluator);
                                    this.currentIterator = iter.iterator();
                                    b = this.currentIterator.hasNext();
                                }
                                this.member = this.currentIterator.next();
                            } while (this.member == null);
                            return true;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Member next() {
                            try {
                                Member member = this.member;
                                return member;
                            }
                            finally {
                                this.member = null;
                            }
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException("remove");
                        }
                    };
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ListSetCalc
    extends AbstractListCalc {
        private List result = new ArrayList();
        private final VoidCalc[] voidCalcs;

        public ListSetCalc(Exp exp, Exp[] args, ExpCompiler compiler, List<ResultStyle> resultStyles) {
            super(exp, null);
            this.voidCalcs = this.compileSelf(args, compiler, resultStyles);
        }

        @Override
        public Calc[] getCalcs() {
            return this.voidCalcs;
        }

        private VoidCalc[] compileSelf(Exp[] args, ExpCompiler compiler, List<ResultStyle> resultStyles) {
            VoidCalc[] voidCalcs = new VoidCalc[args.length];
            for (int i = 0; i < args.length; ++i) {
                voidCalcs[i] = this.createCalc(args[i], compiler, resultStyles);
            }
            return voidCalcs;
        }

        private VoidCalc createCalc(Exp arg, ExpCompiler compiler, List<ResultStyle> resultStyles) {
            Type type = arg.getType();
            if (type instanceof SetType) {
                final ListCalc listCalc = compiler.compileList(arg);
                Type elementType = ((SetType)type).getElementType();
                if (elementType instanceof MemberType) {
                    return new AbstractVoidCalc(arg, new Calc[]{listCalc}){

                        public void evaluateVoid(Evaluator evaluator) {
                            List list = listCalc.evaluateList(evaluator);
                            for (Member member : list) {
                                if (member == null || member.isNull()) continue;
                                ListSetCalc.this.result.add(member);
                            }
                        }

                        protected String getName() {
                            return "Sublist";
                        }
                    };
                }
                return new AbstractVoidCalc(arg, new Calc[]{listCalc}){

                    public void evaluateVoid(Evaluator evaluator) {
                        List list = listCalc.evaluateList(evaluator);
                        Iterator i$ = list.iterator();
                        block0: while (i$.hasNext()) {
                            Member[] members;
                            for (Member member : members = (Member[])i$.next()) {
                                if (member == null || member.isNull()) continue block0;
                            }
                            ListSetCalc.this.result.add(members);
                        }
                    }

                    protected String getName() {
                        return "Sublist";
                    }
                };
            }
            if (TypeUtil.couldBeMember(type)) {
                final MemberCalc listCalc = compiler.compileMember(arg);
                return new AbstractVoidCalc(arg, new Calc[]{listCalc}){

                    public void evaluateVoid(Evaluator evaluator) {
                        Member member = listCalc.evaluateMember(evaluator);
                        if (member == null || member.isNull()) {
                            return;
                        }
                        ListSetCalc.this.result.add(member);
                    }

                    protected String getName() {
                        return "Sublist";
                    }
                };
            }
            final TupleCalc tupleCalc = compiler.compileTuple(arg);
            return new AbstractVoidCalc(arg, new Calc[]{tupleCalc}){

                public void evaluateVoid(Evaluator evaluator) {
                    Member[] members = tupleCalc.evaluateTuple(evaluator);
                    if (members == null) {
                        return;
                    }
                    assert (!FunUtil.tupleContainsNullMember(members));
                    ListSetCalc.this.result.add(members);
                }
            };
        }

        @Override
        public List evaluateList(Evaluator evaluator) {
            this.result.clear();
            for (VoidCalc voidCalc : this.voidCalcs) {
                voidCalc.evaluateVoid(evaluator);
            }
            return new ArrayList(this.result);
        }
    }
}

