/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.LevelCalc;
import mondrian.calc.MemberCalc;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Dimension;
import mondrian.olap.DimensionType;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.ReflectiveMultiResolver;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.Type;
import mondrian.resource.MondrianResource;

class PeriodsToDateFunDef
extends FunDefBase {
    static final ReflectiveMultiResolver Resolver = new ReflectiveMultiResolver("PeriodsToDate", "PeriodsToDate([<Level>[, <Member>]])", "Returns a set of periods (members) from a specified level starting with the first period and ending with a specified member.", new String[]{"fx", "fxl", "fxlm"}, PeriodsToDateFunDef.class);

    public PeriodsToDateFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    public Type getResultType(Validator validator, Exp[] args) {
        if (args.length == 0) {
            Dimension defaultTimeDimension = validator.getQuery().getCube().getTimeDimension();
            if (defaultTimeDimension == null) {
                throw MondrianResource.instance().NoTimeDimensionInCube.ex(this.getName());
            }
            Hierarchy hierarchy = defaultTimeDimension.getHierarchy();
            return new SetType(MemberType.forHierarchy(hierarchy));
        }
        Type type = args[0].getType();
        if (type.getDimension() == null || type.getDimension().getDimensionType() != DimensionType.TimeDimension) {
            throw MondrianResource.instance().TimeArgNeeded.ex(this.getName());
        }
        return super.getResultType(validator, args);
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final LevelCalc levelCalc = call.getArgCount() > 0 ? compiler.compileLevel(call.getArg(0)) : null;
        final MemberCalc memberCalc = call.getArgCount() > 1 ? compiler.compileMember(call.getArg(1)) : null;
        final Dimension timeDimension = compiler.getEvaluator().getCube().getTimeDimension();
        return new AbstractListCalc(call, new Calc[]{levelCalc, memberCalc}){

            public List evaluateList(Evaluator evaluator) {
                Level level;
                Member member;
                if (levelCalc == null) {
                    if (timeDimension == null) {
                        throw MondrianResource.instance().NoTimeDimensionInCube.ex(this.getName());
                    }
                    member = evaluator.getContext(timeDimension);
                    level = member.getLevel().getParentLevel();
                } else {
                    level = levelCalc.evaluateLevel(evaluator);
                    member = memberCalc == null ? evaluator.getContext(level.getHierarchy().getDimension()) : memberCalc.evaluateMember(evaluator);
                }
                return FunUtil.periodsToDate(evaluator, level, member);
            }

            public boolean dependsOn(Dimension dimension) {
                if (super.dependsOn(dimension)) {
                    return true;
                }
                if (memberCalc != null) {
                    return false;
                }
                if (levelCalc != null) {
                    return levelCalc.getType().usesDimension(dimension, true);
                }
                if (timeDimension == null) {
                    throw MondrianResource.instance().NoTimeDimensionInCube.ex(this.getName());
                }
                return dimension == timeDimension;
            }
        };
    }
}

