/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.mdx.DimensionExpr;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Member;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.DistinctFunDef;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.Resolver;
import mondrian.olap.fun.ResolverBase;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExtractFunDef
extends FunDefBase {
    static final ResolverBase Resolver = new ResolverBase("Extract", "Extract(<Set>, <Dimension>[, <Dimension>...])", "Returns a set of tuples from extracted dimension elements. The opposite of Crossjoin.", Syntax.Function){

        public FunDef resolve(Exp[] args, Validator validator, int[] conversionCount) {
            if (args.length < 2) {
                return null;
            }
            if (!validator.canConvert(args[0], 8, conversionCount)) {
                return null;
            }
            for (int i = 1; i < args.length; ++i) {
                if (validator.canConvert(args[i], 2, conversionCount)) continue;
                return null;
            }
            ArrayList extractedOrdinals = new ArrayList();
            ArrayList extractedDimensions = new ArrayList();
            ExtractFunDef.findExtractedDimensions(args, extractedDimensions, extractedOrdinals);
            int[] parameterTypes = new int[args.length];
            parameterTypes[0] = 8;
            Arrays.fill(parameterTypes, 1, parameterTypes.length, 2);
            return new ExtractFunDef(this, 8, parameterTypes);
        }
    };

    private ExtractFunDef(Resolver resolver, int returnType, int[] parameterTypes) {
        super(resolver, returnType, parameterTypes);
    }

    @Override
    public Type getResultType(Validator validator, Exp[] args) {
        ArrayList<Dimension> extractedDimensions = new ArrayList<Dimension>();
        ArrayList<Integer> extractedOrdinals = new ArrayList<Integer>();
        ExtractFunDef.findExtractedDimensions(args, extractedDimensions, extractedOrdinals);
        if (extractedDimensions.size() == 1) {
            return new SetType(new MemberType((Dimension)extractedDimensions.get(0), null, null, null));
        }
        ArrayList<MemberType> typeList = new ArrayList<MemberType>();
        for (Dimension extractedDimension : extractedDimensions) {
            typeList.add(new MemberType(extractedDimension, null, null, null));
        }
        return new SetType(new TupleType(typeList.toArray(new Type[typeList.size()])));
    }

    private static void findExtractedDimensions(Exp[] args, List<Dimension> extractedDimensions, List<Integer> extractedOrdinals) {
        SetType type = (SetType)args[0].getType();
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
        if (type.getElementType() instanceof TupleType) {
            for (Type elementType : ((TupleType)type.getElementType()).elementTypes) {
                Dimension dimension = elementType.getDimension();
                if (dimension == null) {
                    throw new RuntimeException("dimension of argument not known");
                }
                dimensions.add(dimension);
            }
        } else {
            Dimension dimension = type.getDimension();
            if (dimension == null) {
                throw new RuntimeException("dimension of argument not known");
            }
            dimensions.add(dimension);
        }
        for (int i = 1; i < args.length; ++i) {
            int ordinal;
            Dimension extractedDimension;
            Exp arg = args[i];
            if (arg instanceof DimensionExpr) {
                DimensionExpr dimensionExpr = (DimensionExpr)arg;
                extractedDimension = dimensionExpr.getDimension();
                ordinal = dimensions.indexOf(extractedDimension);
                if (ordinal == -1) {
                    throw new RuntimeException("dimension " + extractedDimension.getUniqueName() + " is not a dimension of the expression " + args[0]);
                }
                if (extractedOrdinals.indexOf(ordinal) >= 0) {
                    throw new RuntimeException("dimension " + extractedDimension.getUniqueName() + " is extracted more than once");
                }
            } else {
                throw new RuntimeException("not a constant dimension: " + arg);
            }
            extractedOrdinals.add(ordinal);
            extractedDimensions.add(extractedDimension);
        }
    }

    private static int[] toIntArray(List<Integer> integerList) {
        int[] ints = new int[integerList.size()];
        for (int i = 0; i < ints.length; ++i) {
            ints[i] = integerList.get(i);
        }
        return ints;
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        ArrayList<Dimension> extractedDimensionList = new ArrayList<Dimension>();
        ArrayList<Integer> extractedOrdinalList = new ArrayList<Integer>();
        ExtractFunDef.findExtractedDimensions(call.getArgs(), extractedDimensionList, extractedOrdinalList);
        Util.assertTrue(extractedOrdinalList.size() == extractedDimensionList.size());
        Exp arg = call.getArg(0);
        final ListCalc listCalc = compiler.compileList(arg, false);
        int inArity = ((SetType)arg.getType()).getArity();
        final int outArity = extractedOrdinalList.size();
        if (inArity == 1) {
            Util.assertTrue(outArity == 1);
            return new DistinctFunDef.CalcImpl(call, listCalc);
        }
        final int[] extractedOrdinals = ExtractFunDef.toIntArray(extractedOrdinalList);
        if (outArity == 1) {
            return new AbstractListCalc(call, new Calc[]{listCalc}){

                public List evaluateList(Evaluator evaluator) {
                    ArrayList<Member> result = new ArrayList<Member>();
                    List list = listCalc.evaluateList(evaluator);
                    HashSet<Member> emittedMembers = new HashSet<Member>();
                    for (Member[] members : list) {
                        Member outMember = members[extractedOrdinals[0]];
                        if (emittedMembers.contains(outMember)) continue;
                        emittedMembers.add(outMember);
                        result.add(outMember);
                    }
                    return result;
                }
            };
        }
        return new AbstractListCalc(call, new Calc[]{listCalc}){

            public List evaluateList(Evaluator evaluator) {
                ArrayList<Member[]> result = new ArrayList<Member[]>();
                List list = listCalc.evaluateList(evaluator);
                HashSet<List<Member>> emittedTuples = new HashSet<List<Member>>();
                for (Member[] members : list) {
                    Member[] outMembers = new Member[outArity];
                    for (int i = 0; i < outMembers.length; ++i) {
                        outMembers[i] = members[extractedOrdinals[i]];
                    }
                    List<Member> outTuple = Arrays.asList(outMembers);
                    if (emittedTuples.contains(outTuple)) continue;
                    emittedTuples.add(outTuple);
                    result.add(outMembers);
                }
                return result;
            }
        };
    }
}

