/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.HashSet;
import java.util.Set;
import mondrian.olap.FunDef;
import mondrian.olap.fun.BuiltinFunTable;
import mondrian.olap.fun.FunTableImpl;
import mondrian.olap.fun.Resolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomizedFunctionTable
extends FunTableImpl {
    Set<String> supportedBuiltInFunctions;
    Set<FunDef> specialFunctions;

    public CustomizedFunctionTable(Set<String> buildInFunctions) {
        this.supportedBuiltInFunctions = buildInFunctions;
        this.specialFunctions = new HashSet<FunDef>();
    }

    public CustomizedFunctionTable(Set<String> buildInFunctions, Set<FunDef> specialFunctions) {
        this.supportedBuiltInFunctions = buildInFunctions;
        this.specialFunctions = specialFunctions;
    }

    @Override
    protected void defineFunctions() {
        BuiltinFunTable builtinFunTable = BuiltinFunTable.instance();
        for (String reservedWord : builtinFunTable.getReservedWords()) {
            this.defineReserved(reservedWord);
        }
        for (Resolver resolver : builtinFunTable.getResolvers()) {
            if (!this.supportedBuiltInFunctions.contains(resolver.getName())) continue;
            this.define(resolver);
        }
        for (FunDef funDef : this.specialFunctions) {
            this.define(funDef);
        }
    }
}

