/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.io.PrintWriter;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ResultStyle;
import mondrian.calc.impl.GenericCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.ExpCacheDescriptor;
import mondrian.olap.FunDef;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.ResolverBase;
import mondrian.olap.type.SetType;
import mondrian.olap.type.Type;

public class CacheFunDef
extends FunDefBase {
    static final String NAME = "Cache";
    private static final String SIGNATURE = "Cache(<<Exp>>)";
    private static final String DESCRIPTION = "Evaluates and returns its sole argument, applying statement-level caching";
    private static final Syntax SYNTAX = Syntax.Function;
    static final CacheFunResolver Resolver = new CacheFunResolver();

    CacheFunDef(String name, String signature, String description, Syntax syntax, int category, Type type) {
        super(name, signature, description, syntax, category, new int[]{category});
        Util.discard((Object)type);
    }

    public void unparse(Exp[] args, PrintWriter pw) {
        args[0].unparse(pw);
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        Exp exp = call.getArg(0);
        final ExpCacheDescriptor cacheDescriptor = new ExpCacheDescriptor(exp, compiler);
        return new GenericCalc(call){

            public Object evaluate(Evaluator evaluator) {
                return evaluator.getCachedResult(cacheDescriptor);
            }

            public Calc[] getCalcs() {
                return new Calc[]{cacheDescriptor.getCalc()};
            }

            public ResultStyle getResultStyle() {
                if (this.type instanceof SetType) {
                    return ResultStyle.LIST;
                }
                return ResultStyle.VALUE;
            }
        };
    }

    public static class CacheFunResolver
    extends ResolverBase {
        CacheFunResolver() {
            super(CacheFunDef.NAME, CacheFunDef.SIGNATURE, CacheFunDef.DESCRIPTION, SYNTAX);
        }

        public FunDef resolve(Exp[] args, Validator validator, int[] conversionCount) {
            if (args.length != 1) {
                return null;
            }
            Exp exp = args[0];
            int category = exp.getCategory();
            Type type = exp.getType();
            return new CacheFunDef(CacheFunDef.NAME, CacheFunDef.SIGNATURE, CacheFunDef.DESCRIPTION, SYNTAX, category, type);
        }

        public boolean requiresExpression(int k) {
            return false;
        }
    }
}

