/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.xmla;

import com.tonbeller.jpivot.olap.mdxparse.FunCall;
import com.tonbeller.jpivot.olap.model.Dimension;
import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.Level;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.OlapException;
import com.tonbeller.jpivot.olap.query.Quax;
import com.tonbeller.jpivot.olap.query.QuaxUti;
import com.tonbeller.jpivot.olap.query.SetExp;
import com.tonbeller.jpivot.xmla.XMLA_Level;
import com.tonbeller.jpivot.xmla.XMLA_Member;
import com.tonbeller.jpivot.xmla.XMLA_Util;
import java.util.Iterator;
import java.util.List;
import mondrian.olap.Exp;
import org.apache.log4j.Logger;

public class XMLA_QuaxUti
implements QuaxUti {
    static Logger logger = Logger.getLogger((Class)XMLA_QuaxUti.class);

    public boolean isMemberInFunCall(Object oExp, Member m) throws Quax.CannotHandleException {
        FunCall f = (FunCall)oExp;
        XMLA_Member xm = (XMLA_Member)m;
        try {
            if (f.isCallTo("Children")) {
                return this.isMemberInChildren(f, xm);
            }
            if (f.isCallTo("Descendants")) {
                return this.isMemberInDescendants(f, xm);
            }
            if (f.isCallTo("Members")) {
                return this.isMemberInLevel(f, xm);
            }
            if (f.isCallTo("Union")) {
                return this.isMemberInUnion(f, xm);
            }
            if (f.isCallTo("{}")) {
                return this.isMemberInSet(f, xm);
            }
        }
        catch (OlapException e) {
            logger.error((Object)"?", (Throwable)e);
            return false;
        }
        throw new Quax.CannotHandleException(f.getFunction());
    }

    private boolean isMemberInChildren(FunCall f, XMLA_Member mSearch) {
        if (mSearch.isCalculated()) {
            return false;
        }
        XMLA_Member parent = (XMLA_Member)f.getArgs()[0];
        return this.checkParent(parent, mSearch);
    }

    private boolean isMemberInDescendants(FunCall f, XMLA_Member mSearch) throws OlapException {
        if (mSearch.isCalculated()) {
            return false;
        }
        XMLA_Member ancestor = (XMLA_Member)f.getArgs()[0];
        XMLA_Level level = (XMLA_Level)f.getArgs()[1];
        XMLA_Level mLevel = (XMLA_Level)mSearch.getLevel();
        if (!mLevel.equals(level)) {
            return false;
        }
        if (mSearch.equals(ancestor)) {
            return false;
        }
        int ancestorLevelNumber = ((XMLA_Level)ancestor.getLevel()).getDepth();
        XMLA_Member mm = mSearch;
        while (ancestorLevelNumber < ((XMLA_Level)mm.getLevel()).getDepth()) {
            mm = (XMLA_Member)mm.getParent();
        }
        return mm.equals(ancestor);
    }

    private boolean isMemberInLevel(FunCall f, XMLA_Member mSearch) {
        XMLA_Level level = (XMLA_Level)f.getArgs()[0];
        return level.equals(mSearch.getLevel());
    }

    private boolean isMemberInSet(FunCall f, XMLA_Member mSearch) {
        for (int i = 0; i < f.getArgs().length; ++i) {
            XMLA_Member m = (XMLA_Member)f.getArgs()[i];
            if (!m.equals(mSearch)) continue;
            return true;
        }
        return false;
    }

    private boolean isMemberInUnion(FunCall f, XMLA_Member mSearch) throws Quax.CannotHandleException {
        for (int i = 0; i < 2; ++i) {
            FunCall fChild = (FunCall)f.getArgs()[i];
            if (!this.isMemberInFunCall(fChild, mSearch)) continue;
            return true;
        }
        return false;
    }

    public boolean isChildOfMemberInFunCall(Object oFun, Member m) throws Quax.CannotHandleException {
        if (((XMLA_Member)m).isCalculated()) {
            return false;
        }
        FunCall f = (FunCall)oFun;
        try {
            if (f.isCallTo("Children")) {
                return ((XMLA_Member)f.getArgs()[0]).equals(m);
            }
            if (f.isCallTo("Descendants")) {
                XMLA_Member ancestor = (XMLA_Member)f.getArgs()[0];
                XMLA_Level lev = (XMLA_Level)f.getArgs()[1];
                XMLA_Level parentLevel = lev.getParentLevel();
                if (parentLevel != null && m.getLevel().equals(parentLevel)) {
                    XMLA_Member mm = (XMLA_Member)m;
                    int ancestorLevelNumber = ((XMLA_Level)ancestor.getLevel()).getDepth();
                    while (ancestorLevelNumber < ((XMLA_Level)mm.getLevel()).getDepth()) {
                        mm = (XMLA_Member)mm.getParent();
                    }
                    return mm.equals(ancestor);
                }
                return false;
            }
            if (f.isCallTo("Members")) {
                XMLA_Level lev = (XMLA_Level)f.getArgs()[0];
                XMLA_Level parentLevel = lev.getParentLevel();
                return parentLevel != null && m.getLevel().equals(parentLevel);
            }
            if (f.isCallTo("Union")) {
                if (this.isChildOfMemberInFunCall(f.getArgs()[0], m)) {
                    return true;
                }
                return this.isChildOfMemberInFunCall(f.getArgs()[1], m);
            }
            if (f.isCallTo("{}")) {
                for (int i = 0; i < f.getArgs().length; ++i) {
                    XMLA_Member mm = (XMLA_Member)f.getArgs()[i];
                    XMLA_Member mmp = (XMLA_Member)mm.getParent();
                    if (mmp == null || !mmp.equals(m)) continue;
                    return true;
                }
                return false;
            }
        }
        catch (OlapException e) {
            logger.error((Object)"?", (Throwable)e);
            return false;
        }
        throw new Quax.CannotHandleException(f.getFunction());
    }

    public boolean isDescendantOfMemberInFunCall(Object oExp, Member member) throws Quax.CannotHandleException {
        XMLA_Member m = (XMLA_Member)member;
        if (m.isCalculated()) {
            return false;
        }
        FunCall f = (FunCall)oExp;
        if (f.isCallTo("Children")) {
            XMLA_Member mExp = (XMLA_Member)f.getArgs()[0];
            return m.equals(mExp) || XMLA_Util.isDescendant(m, mExp);
        }
        if (f.isCallTo("Descendants")) {
            XMLA_Member mExp = (XMLA_Member)f.getArgs()[0];
            return m.equals(mExp) || XMLA_Util.isDescendant(m, mExp);
        }
        if (f.isCallTo("Members")) {
            XMLA_Level levExp = (XMLA_Level)f.getArgs()[0];
            return levExp.getDepth() > ((XMLA_Level)m.getLevel()).getDepth();
        }
        if (f.isCallTo("Union")) {
            if (this.isDescendantOfMemberInFunCall(f.getArgs()[0], m)) {
                return true;
            }
            return this.isDescendantOfMemberInFunCall(f.getArgs()[1], m);
        }
        if (f.isCallTo("{}")) {
            int i = 0;
            if (i < f.getArgs().length) {
                XMLA_Member mExp = (XMLA_Member)f.getArgs()[i];
                return !m.equals(mExp) && XMLA_Util.isDescendant(m, mExp);
            }
            return false;
        }
        throw new Quax.CannotHandleException(f.getFunction());
    }

    static FunCall removeChildrenFromUnion(FunCall f, XMLA_Member monMember) {
        FunCall f1 = (FunCall)f.getArgs()[0];
        FunCall f2 = (FunCall)f.getArgs()[1];
        if (f1.isCallTo("Children") && ((XMLA_Member)f1.getArgs()[0]).equals(monMember)) {
            return f2;
        }
        if (f2.isCallTo("Children") && ((XMLA_Member)f1.getArgs()[0]).equals(monMember)) {
            return f1;
        }
        FunCall f1New = f1;
        if (f1.isCallTo("Union")) {
            f1New = XMLA_QuaxUti.removeChildrenFromUnion(f1, monMember);
        }
        FunCall f2New = f2;
        if (f2.isCallTo("Union")) {
            f2New = XMLA_QuaxUti.removeChildrenFromUnion(f2, monMember);
        }
        if (f1 == f1New && f2 == f2New) {
            return f;
        }
        return new FunCall("Union", new com.tonbeller.jpivot.olap.mdxparse.Exp[]{f1New, f2New});
    }

    public void addMemberUncles(List list, Member m, int[] maxLevel) {
        block6: {
            XMLA_Member xm = (XMLA_Member)m;
            int parentLevel = ((XMLA_Level)xm.getLevel()).getDepth() - 1;
            if (parentLevel < maxLevel[0]) {
                return;
            }
            if (parentLevel > maxLevel[0]) {
                maxLevel[0] = parentLevel;
                list.clear();
            }
            if (parentLevel > 0) {
                XMLA_Member grandPa;
                try {
                    XMLA_Member parent = (XMLA_Member)xm.getParent();
                    grandPa = (XMLA_Member)parent.getParent();
                }
                catch (OlapException e) {
                    logger.error((Object)"?", (Throwable)e);
                    return;
                }
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    FunCall f;
                    com.tonbeller.jpivot.olap.mdxparse.Exp exp = (com.tonbeller.jpivot.olap.mdxparse.Exp)iter.next();
                    if (!(exp instanceof FunCall) || !(f = (FunCall)exp).isCallTo("Children") || !((XMLA_Member)f.getArgs()[0]).equals(grandPa)) continue;
                    break block6;
                }
                FunCall fUncles = new FunCall("Children", new com.tonbeller.jpivot.olap.mdxparse.Exp[]{grandPa}, 1);
                list.add(fUncles);
            }
        }
    }

    public void addMemberSiblings(List list, Member m, int[] maxLevel) {
        block6: {
            XMLA_Member xm = (XMLA_Member)m;
            int level = ((XMLA_Level)xm.getLevel()).getDepth();
            if (level < maxLevel[0]) {
                return;
            }
            if (level > maxLevel[0]) {
                maxLevel[0] = level;
                list.clear();
            }
            if (level > 0) {
                XMLA_Member parent;
                try {
                    parent = (XMLA_Member)xm.getParent();
                }
                catch (OlapException e) {
                    logger.error((Object)"?", (Throwable)e);
                    return;
                }
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    FunCall f;
                    com.tonbeller.jpivot.olap.mdxparse.Exp exp = (com.tonbeller.jpivot.olap.mdxparse.Exp)iter.next();
                    if (!(exp instanceof FunCall) || !(f = (FunCall)exp).isCallTo("Children") || !((XMLA_Member)f.getArgs()[0]).equals(parent)) continue;
                    break block6;
                }
                FunCall fSiblings = new FunCall("Children", new com.tonbeller.jpivot.olap.mdxparse.Exp[]{parent}, 1);
                list.add(fSiblings);
            }
        }
    }

    public void addMemberChildren(List list, Member m, int[] maxLevel) {
        block4: {
            XMLA_Member xm = (XMLA_Member)m;
            int childLevel = ((XMLA_Level)xm.getLevel()).getDepth() + 1;
            if (childLevel < maxLevel[0]) {
                return;
            }
            if (childLevel > maxLevel[0]) {
                maxLevel[0] = childLevel;
                list.clear();
            }
            if (childLevel > 0) {
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    FunCall f;
                    com.tonbeller.jpivot.olap.mdxparse.Exp exp = (com.tonbeller.jpivot.olap.mdxparse.Exp)iter.next();
                    if (!(exp instanceof FunCall) || !(f = (FunCall)exp).isCallTo("Children") || !((XMLA_Member)f.getArgs()[0]).equals(xm)) continue;
                    break block4;
                }
                FunCall fChildren = new FunCall("Children", new com.tonbeller.jpivot.olap.mdxparse.Exp[]{xm}, 1);
                list.add(fChildren);
            }
        }
    }

    public void addMemberDescendants(List list, Member m, Level lev, int[] maxLevel) {
        block4: {
            XMLA_Member xm = (XMLA_Member)m;
            int parentLevel = ((XMLA_Level)xm.getLevel()).getDepth() - 1;
            if (parentLevel < maxLevel[0]) {
                return;
            }
            if (parentLevel > maxLevel[0]) {
                maxLevel[0] = parentLevel;
                list.clear();
            }
            if (parentLevel > 0) {
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    FunCall f;
                    com.tonbeller.jpivot.olap.mdxparse.Exp exp = (com.tonbeller.jpivot.olap.mdxparse.Exp)iter.next();
                    if (!(exp instanceof FunCall) || !(f = (FunCall)exp).isCallTo("Descendants") || !((XMLA_Member)f.getArgs()[0]).equals(m)) continue;
                    break block4;
                }
                FunCall fChildren = new FunCall("Descendants", new com.tonbeller.jpivot.olap.mdxparse.Exp[]{xm, (XMLA_Level)lev}, 0);
                list.add(fChildren);
            }
        }
    }

    public void addLevelMembers(List list, Level lev, int[] maxLevel) {
        block4: {
            int level = ((XMLA_Level)lev).getDepth();
            if (level < maxLevel[0]) {
                return;
            }
            if (level > maxLevel[0]) {
                maxLevel[0] = level;
                list.clear();
            }
            if (level > 0) {
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    FunCall f;
                    com.tonbeller.jpivot.olap.mdxparse.Exp exp = (com.tonbeller.jpivot.olap.mdxparse.Exp)iter.next();
                    if (!(exp instanceof FunCall) || !(f = (FunCall)exp).isCallTo("Members")) continue;
                    break block4;
                }
                FunCall fMembers = new FunCall("Members", new com.tonbeller.jpivot.olap.mdxparse.Exp[]{(XMLA_Level)lev}, 1);
                list.add(fMembers);
            }
        }
    }

    public StringBuffer funString(Object oFun) {
        FunCall f = (FunCall)oFun;
        StringBuffer buf = new StringBuffer();
        if (f.isCallTo("Children")) {
            XMLA_Member m = (XMLA_Member)f.getArgs()[0];
            buf.append(m.getUniqueName());
            buf.append(".children");
        } else if (f.isCallTo("Descendants")) {
            XMLA_Member m = (XMLA_Member)f.getArgs()[0];
            XMLA_Level lev = (XMLA_Level)f.getArgs()[1];
            buf.append("Descendants(");
            buf.append(m.getUniqueName());
            buf.append(",");
            buf.append(lev.getUniqueName());
            buf.append(")");
        } else if (f.isCallTo("members")) {
            XMLA_Level lev = (XMLA_Level)f.getArgs()[0];
            buf.append(lev.getUniqueName());
            buf.append(".Members");
        } else if (f.isCallTo("Union")) {
            buf.append("Union(");
            FunCall f1 = (FunCall)f.getArgs()[0];
            buf.append(this.funString(f1));
            buf.append(",");
            FunCall f2 = (FunCall)f.getArgs()[1];
            buf.append(this.funString(f2));
            buf.append(")");
        } else if (f.isCallTo("{}")) {
            buf.append("{");
            for (int i = 0; i < f.getArgs().length; ++i) {
                if (i > 0) {
                    buf.append(",");
                }
                XMLA_Member m = (XMLA_Member)f.getArgs()[i];
                buf.append(m.getUniqueName());
            }
            buf.append("}");
        } else if (f.isCallTo("TopCount") || f.isCallTo("BottomCount") || f.isCallTo("TopPercent") || f.isCallTo("BottomPercent")) {
            buf.append(f.getFunction());
            buf.append("(");
            FunCall f1 = (FunCall)f.getArgs()[0];
            buf.append(this.funString(f1));
            buf.append(")");
        }
        return buf;
    }

    public Hierarchy hierForExp(Object oExp) throws Quax.CannotHandleException {
        if (oExp instanceof XMLA_Member) {
            return ((XMLA_Member)oExp).getHierarchy();
        }
        if (oExp instanceof SetExp) {
            SetExp set = (SetExp)oExp;
            return set.getHier();
        }
        FunCall f = (FunCall)oExp;
        if (f.isCallTo("Children")) {
            XMLA_Member m = (XMLA_Member)f.getArgs()[0];
            return m.getHierarchy();
        }
        if (f.isCallTo("Descendants")) {
            XMLA_Member m = (XMLA_Member)f.getArgs()[0];
            return m.getHierarchy();
        }
        if (f.isCallTo("Members")) {
            XMLA_Level lev = (XMLA_Level)f.getArgs()[0];
            return lev.getHierarchy();
        }
        if (f.isCallTo("Union")) {
            return this.hierForExp(f.getArgs()[0]);
        }
        if (f.isCallTo("{}")) {
            XMLA_Member m = (XMLA_Member)f.getArgs()[0];
            return m.getHierarchy();
        }
        if (f.isCallTo("TopCount") || f.isCallTo("BottomCount") || f.isCallTo("TopPercent") || f.isCallTo("BottomPercent") || f.isCallTo("Filter")) {
            return this.hierForExp(f.getArgs()[0]);
        }
        throw new Quax.CannotHandleException(f.getFunction());
    }

    public boolean isMember(Object oExp) {
        return oExp instanceof XMLA_Member;
    }

    public boolean isFunCall(Object oExp) {
        return oExp instanceof FunCall;
    }

    public boolean equalMember(Object oExp, Member member) {
        return ((XMLA_Member)member).equals(oExp);
    }

    public Member getParentMember(Object oExp) {
        try {
            return ((XMLA_Member)oExp).getParent();
        }
        catch (OlapException e) {
            logger.error((Object)"?", (Throwable)e);
            return null;
        }
    }

    public Object funCallChildren(Member member) {
        return new FunCall("Children", new com.tonbeller.jpivot.olap.mdxparse.Exp[]{(XMLA_Member)member}, 1);
    }

    public Hierarchy hierForMember(Member member) {
        XMLA_Member xm = (XMLA_Member)member;
        return xm.getHierarchy();
    }

    public Dimension dimForMember(Member member) {
        XMLA_Member xm = (XMLA_Member)member;
        return xm.getHierarchy().getDimension();
    }

    public String getMemberUniqueName(Object oExp) {
        XMLA_Member m = (XMLA_Member)oExp;
        return m.getUniqueName();
    }

    public boolean isFunCallTo(Object oExp, String function) {
        return ((FunCall)oExp).isCallTo(function);
    }

    public Object funCallArg(Object oExp, int index) {
        return ((FunCall)oExp).getArgs()[index];
    }

    public String funCallName(Object oFun) {
        return ((FunCall)oFun).getFunction();
    }

    public boolean checkParent(Member pMember, Object cMemObj) {
        XMLA_Member pm = (XMLA_Member)pMember;
        XMLA_Member cm = (XMLA_Member)cMemObj;
        if (pm.isMicrosoft()) {
            String pUName = cm.getParentUniqueName();
            return ((XMLA_Member)pMember).getUniqueName().equals(pUName);
        }
        try {
            return pm.equals(cm.getParent());
        }
        catch (OlapException e) {
            return false;
        }
    }

    public boolean checkChild(Member cMember, Object pMemObj) {
        return this.checkParent((XMLA_Member)pMemObj, cMember);
    }

    public boolean checkDescendantM(Member aMember, Member dMember) {
        return XMLA_Util.isDescendant((XMLA_Member)aMember, (XMLA_Member)dMember);
    }

    public boolean checkDescendantO(Member aMember, Object oMember) {
        return XMLA_Util.isDescendant((XMLA_Member)aMember, (XMLA_Member)oMember);
    }

    public Object objForMember(Member member) {
        return member;
    }

    public Object objForDim(Dimension dim) {
        return dim;
    }

    public Member memberForObj(Object oExp) {
        return (Member)oExp;
    }

    public String memberString(Member[] mPath) {
        if (mPath == null || mPath.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < mPath.length; ++i) {
            if (i > 0) {
                sb.append(" ");
            }
            sb.append(((XMLA_Member)mPath[i]).getUniqueName());
        }
        return sb.toString();
    }

    public Object createMemberSet(List mList) {
        if (mList.size() == 0) {
            return null;
        }
        if (mList.size() == 1) {
            return (com.tonbeller.jpivot.olap.mdxparse.Exp)mList.get(0);
        }
        com.tonbeller.jpivot.olap.mdxparse.Exp[] remExps = mList.toArray(new com.tonbeller.jpivot.olap.mdxparse.Exp[0]);
        return new FunCall("{}", remExps, 5);
    }

    public boolean isFunCallNotTopLevel(Object oExp) throws Quax.CannotHandleException {
        FunCall f = (FunCall)oExp;
        if (f.isCallTo("Children")) {
            return true;
        }
        if (f.isCallTo("Descendants")) {
            return true;
        }
        if (f.isCallTo("Members")) {
            XMLA_Level lev = (XMLA_Level)f.getArgs()[0];
            return lev.getDepth() > 0;
        }
        if (f.isCallTo("Union")) {
            if (this.isFunCallNotTopLevel(f.getArgs()[0])) {
                return true;
            }
            return this.isFunCallNotTopLevel(f.getArgs()[1]);
        }
        if (f.isCallTo("{}")) {
            for (int i = 0; i < f.getArgs().length; ++i) {
                if (this.isMemberOnToplevel(f.getArgs()[i])) continue;
                return true;
            }
            return false;
        }
        throw new Quax.CannotHandleException(f.getFunction());
    }

    public boolean isMemberOnToplevel(Object oMem) {
        XMLA_Member m = (XMLA_Member)oMem;
        return ((XMLA_Level)m.getLevel()).getDepth() <= 0;
    }

    public int levelDepthForMember(Object oExp) {
        XMLA_Member m = (XMLA_Member)oExp;
        XMLA_Level level = (XMLA_Level)m.getLevel();
        return level.getDepth();
    }

    public Object topLevelMembers(Hierarchy hier, boolean expandAllMember) {
        return XMLA_Util.topLevelMembers(hier, expandAllMember);
    }

    public int funCallArgCount(Object oFun) {
        FunCall f = (FunCall)oFun;
        return f.getArgs().length;
    }

    public Level LevelForObj(Object oLevel) {
        return (Level)oLevel;
    }

    public Level getParentLevel(Level level) {
        return ((XMLA_Level)level).getParentLevel();
    }

    public Exp toExp(Object o) {
        return (Exp)o;
    }

    public Object createFunCall(String function, Object[] args, int funType) {
        int type;
        com.tonbeller.jpivot.olap.mdxparse.Exp[] expArgs = new com.tonbeller.jpivot.olap.mdxparse.Exp[args.length];
        for (int i = 0; i < expArgs.length; ++i) {
            expArgs[i] = (com.tonbeller.jpivot.olap.mdxparse.Exp)args[i];
        }
        switch (funType) {
            case 2: {
                type = 5;
                break;
            }
            case 1: {
                type = 1;
                break;
            }
            case 3: {
                type = 6;
                break;
            }
            case 4: {
                type = 3;
                break;
            }
            default: {
                type = 0;
            }
        }
        return new FunCall(function, expArgs, type);
    }

    public boolean canHandle(Object oExp) {
        if (oExp instanceof Member) {
            return true;
        }
        FunCall f = (FunCall)oExp;
        if (f.isCallTo("children")) {
            return true;
        }
        if (f.isCallTo("descendants")) {
            return true;
        }
        if (f.isCallTo("members")) {
            return true;
        }
        if (f.isCallTo("{}")) {
            return true;
        }
        if (f.isCallTo("union")) {
            for (int i = 0; i < f.getArgs().length; ++i) {
                if (this.canHandle(f.getArgs()[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Object[] getChildren(Object oMember) {
        Object[] mChildren;
        try {
            mChildren = ((XMLA_Member)oMember).getChildren();
        }
        catch (OlapException e) {
            logger.fatal((Object)"unexpected exception", (Throwable)e);
            return null;
        }
        return mChildren;
    }

    public Object[] getLevelMembers(Level level) {
        Object[] members;
        try {
            members = ((XMLA_Level)level).getMembers();
        }
        catch (OlapException e) {
            logger.fatal((Object)"unexpected failure level members", (Throwable)e);
            return null;
        }
        return members;
    }
}

