/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.xmla;

import com.tonbeller.jpivot.core.Extension;
import com.tonbeller.jpivot.core.ModelChangeEvent;
import com.tonbeller.jpivot.core.ModelChangeListener;
import com.tonbeller.jpivot.olap.mdxparse.Exp;
import com.tonbeller.jpivot.olap.mdxparse.Formula;
import com.tonbeller.jpivot.olap.mdxparse.FunCall;
import com.tonbeller.jpivot.olap.mdxparse.Lexer;
import com.tonbeller.jpivot.olap.mdxparse.Literal;
import com.tonbeller.jpivot.olap.mdxparse.ParsedQuery;
import com.tonbeller.jpivot.olap.mdxparse.parser;
import com.tonbeller.jpivot.olap.model.Dimension;
import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.Level;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.OlapException;
import com.tonbeller.jpivot.olap.model.OlapItem;
import com.tonbeller.jpivot.olap.model.OlapModel;
import com.tonbeller.jpivot.olap.model.Result;
import com.tonbeller.jpivot.olap.query.ExpBean;
import com.tonbeller.jpivot.olap.query.MdxOlapModel;
import com.tonbeller.jpivot.olap.query.PositionNodeBean;
import com.tonbeller.jpivot.olap.query.Quax;
import com.tonbeller.jpivot.olap.query.QuaxBean;
import com.tonbeller.jpivot.olap.query.QueryAdapter;
import com.tonbeller.jpivot.util.TreeNode;
import com.tonbeller.jpivot.xmla.XMLA_Dimension;
import com.tonbeller.jpivot.xmla.XMLA_Hierarchy;
import com.tonbeller.jpivot.xmla.XMLA_Level;
import com.tonbeller.jpivot.xmla.XMLA_Member;
import com.tonbeller.jpivot.xmla.XMLA_MemberProp;
import com.tonbeller.jpivot.xmla.XMLA_Memento;
import com.tonbeller.jpivot.xmla.XMLA_Quax;
import com.tonbeller.jpivot.xmla.XMLA_QueryAdapter;
import com.tonbeller.jpivot.xmla.XMLA_Result;
import com.tonbeller.jpivot.xmla.XMLA_SOAP;
import com.tonbeller.jpivot.xmla.XMLA_SortRank;
import com.tonbeller.jpivot.xmla.XMLA_Util;
import com.tonbeller.tbutils.res.Resources;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java_cup.runtime.Symbol;
import javax.servlet.ServletContext;
import org.apache.log4j.Logger;

public class XMLA_Model
extends MdxOlapModel
implements OlapModel,
QueryAdapter.QueryAdapterHolder {
    static Logger logger = Logger.getLogger((Class)XMLA_Model.class);
    private String ID = null;
    private String uri = null;
    private String user = null;
    private String password = null;
    private String catalog = null;
    private ServletContext servletContext = null;
    private String dataSource = null;
    private String mdxQuery = null;
    private String currentMdx = null;
    private ParsedQuery pQuery = null;
    private XMLA_Result result = null;
    private List aDimensions = new ArrayList();
    private List aHierarchies = new ArrayList();
    private List aLevels = new ArrayList();
    private List aMeasures = new ArrayList();
    private List aMembers = new ArrayList();
    private XMLA_QueryAdapter queryAdapter = null;
    private String cube = null;
    private boolean isNewCube = false;
    private XMLA_SOAP soap = null;
    private boolean isInitialized = false;
    private Locale locale = null;
    private Locale modelLocale = null;
    private Map calcMeasurePropMap;

    public XMLA_Model() {
        this.addModelChangeListener(new ModelChangeListener(){

            public void modelChanged(ModelChangeEvent e) {
                XMLA_Model.this.result = null;
            }

            public void structureChanged(ModelChangeEvent e) {
                XMLA_Model.this.result = null;
            }
        });
    }

    public void initialize() throws OlapException {
        logger.info((Object)this);
        boolean logInfo = logger.isInfoEnabled();
        if (this.catalog == null) {
            throw new OlapException("XMLA Model requires catalog specification");
        }
        this.locale = Resources.instance().getLocaleContextHolderLocale();
        this.modelLocale = (Locale)this.servletContext.getAttribute("locale");
        if (this.modelLocale == null) {
            this.modelLocale = this.locale;
        }
        if (this.modelLocale != null && logInfo) {
            String msg = "Locale language=" + this.modelLocale.getLanguage() + " Country=" + this.modelLocale.getCountry();
            logger.info((Object)msg);
        }
        this.soap = this.dataSource != null && this.dataSource.length() > 0 ? new XMLA_SOAP(this.uri, this.user, this.password, this.dataSource) : new XMLA_SOAP(this.uri, this.user, this.password);
        if (logInfo) {
            List dsprops = this.soap.discoverDSProps();
            Iterator iter = dsprops.iterator();
            while (iter.hasNext()) {
                OlapItem oi = (OlapItem)iter.next();
                Map pmap = oi.getProperties();
                logger.info((Object)("Property: " + oi.getName()));
                Iterator iterator = pmap.keySet().iterator();
                while (iterator.hasNext()) {
                    Object keyo = iterator.next();
                    logger.info((Object)(keyo + "=" + pmap.get(keyo)));
                }
            }
        }
        this.parse(this.mdxQuery);
        this.queryAdapter = new XMLA_QueryAdapter(this);
        XMLA_SortRank sortExt = (XMLA_SortRank)this.getExtension("sortRank");
        if (sortExt != null) {
            sortExt.reset();
        }
        this.isInitialized = true;
        Map extMap = this.getExtensions();
        Collection extensions = extMap.values();
        Iterator iter = extensions.iterator();
        while (iter.hasNext()) {
            Extension extension = (Extension)iter.next();
            extension.modelInitialized();
        }
        this.initCubeMetaData();
        this.isNewCube = false;
        this.calcMeasurePropMap = new HashMap();
    }

    public void setMdxQuery(String mdxQuery) {
        this.mdxQuery = mdxQuery;
        this.currentMdx = mdxQuery.replace('\r', ' ');
        if (logger.isInfoEnabled()) {
            logger.info((Object)("setMdxQuery: " + mdxQuery));
        }
    }

    public synchronized Result getResult() throws OlapException {
        if (this.result != null) {
            return this.result;
        }
        if (!this.isInitialized) {
            logger.fatal((Object)"Model not initialized");
            throw new OlapException("Model not initialized");
        }
        if (this.isNewCube) {
            this.initCubeMetaData();
        }
        this.isNewCube = false;
        this.queryAdapter.onExecute();
        long lBefore = System.currentTimeMillis();
        logger.debug((Object)this.currentMdx);
        XMLA_Result res = new XMLA_Result(this, this.soap, this.catalog, this.currentMdx);
        long lTime = System.currentTimeMillis() - lBefore;
        logger.debug((Object)("Time for executeQuery(ms)=" + lTime));
        this.result = res;
        this.queryAdapter.afterExecute(this.result);
        return this.result;
    }

    XMLA_Result currentResult() {
        return this.result;
    }

    public synchronized Result getDrillResult() throws OlapException {
        if (this.result != null) {
            return this.result;
        }
        if (!this.isInitialized) {
            logger.fatal((Object)"Model not initialized");
            throw new OlapException("Model not initialized");
        }
        if (this.isNewCube) {
            this.initCubeMetaData();
        }
        this.isNewCube = false;
        this.queryAdapter.onExecuteDrill();
        long lBefore = System.currentTimeMillis();
        logger.debug((Object)this.currentMdx);
        XMLA_Result res = new XMLA_Result(this, this.soap, this.catalog, this.currentMdx, true);
        long lTime = System.currentTimeMillis() - lBefore;
        logger.debug((Object)("Time for executeQuery(ms)=" + lTime));
        this.result = res;
        this.queryAdapter.afterExecute(this.result);
        return this.result;
    }

    public String getCurrentMdx() {
        if (this.queryAdapter != null) {
            return this.queryAdapter.getCurrentMdx();
        }
        return this.mdxQuery;
    }

    public void setUserMdx(String mdxQuery) throws OlapException {
        if (this.currentMdx.equals(mdxQuery)) {
            return;
        }
        this.parse(mdxQuery);
        this.mdxQuery = mdxQuery;
        this.result = null;
        this.queryAdapter = new XMLA_QueryAdapter(this);
        XMLA_SortRank sortExt = (XMLA_SortRank)this.getExtension("sortRank");
        if (sortExt != null) {
            sortExt.reset();
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("setUserMdx =" + mdxQuery));
        }
        this.currentMdx = mdxQuery.replace('\r', ' ');
    }

    String getMdxQuery() {
        return this.mdxQuery;
    }

    void setCurrentMdx(String currentMdx) {
        this.currentMdx = currentMdx.replaceAll("\r", "");
    }

    public Dimension[] getDimensions() {
        return this.aDimensions.toArray(new Dimension[0]);
    }

    public Member[] getMeasures() {
        return this.aMeasures.toArray(new Member[0]);
    }

    public void destroy() {
        super.destroy();
    }

    public Object getRootDecoree() {
        return this;
    }

    XMLA_Dimension lookupDimByUName(String uName) {
        Iterator iter = this.aDimensions.iterator();
        while (iter.hasNext()) {
            XMLA_Dimension dim = (XMLA_Dimension)iter.next();
            if (!dim.getUniqueName().equals(uName)) continue;
            return dim;
        }
        return null;
    }

    XMLA_Hierarchy lookupHierByUName(String uName) {
        Iterator iter = this.aHierarchies.iterator();
        while (iter.hasNext()) {
            XMLA_Hierarchy hier = (XMLA_Hierarchy)iter.next();
            if (!hier.getUniqueName().equals(uName)) continue;
            return hier;
        }
        return null;
    }

    XMLA_Level lookupLevelByUName(String uName) {
        Iterator iter = this.aLevels.iterator();
        while (iter.hasNext()) {
            XMLA_Level lev = (XMLA_Level)iter.next();
            if (!lev.getUniqueName().equals(uName)) continue;
            return lev;
        }
        return null;
    }

    public Member lookupMemberByUName(String uName) {
        Iterator iter = this.aMembers.iterator();
        while (iter.hasNext()) {
            XMLA_Member mem = (XMLA_Member)iter.next();
            if (!mem.getUniqueName().equals(uName)) continue;
            return mem;
        }
        return null;
    }

    void addMember(XMLA_Member mem) {
        this.aMembers.add(mem);
    }

    public void removeMember(XMLA_Member mem) {
        if (this.aMembers.contains(mem)) {
            this.aMembers.remove(mem);
        }
    }

    public Object getBookmarkState(int levelOfDetail) {
        try {
            XMLA_Memento memento = new XMLA_Memento();
            memento.setVersion(1);
            memento.setUri(this.uri);
            memento.setDataSource(this.dataSource);
            memento.setCatalog(this.catalog);
            memento.setUser(this.user);
            memento.setPassword(this.password);
            memento.setMdxQuery(this.currentMdx);
            boolean useQuax = this.queryAdapter.isUseQuax();
            memento.setUseQuax(useQuax);
            if (useQuax) {
                XMLA_Quax[] quaxes = (XMLA_Quax[])this.queryAdapter.getQuaxes();
                QuaxBean[] quaxBeans = new QuaxBean[quaxes.length];
                for (int i = 0; i < quaxes.length; ++i) {
                    quaxBeans[i] = new QuaxBean();
                    this.beanFromQuax(quaxBeans[i], quaxes[i]);
                }
                memento.setQuaxes(quaxBeans);
            }
            memento.setAxesSwapped(this.queryAdapter.isSwapAxes());
            XMLA_SortRank sortExt = (XMLA_SortRank)this.getExtension("sortRank");
            if (sortExt != null) {
                this.storeSort(sortExt, memento);
            }
            if (this.calcMeasurePropMap != null) {
                memento.setCalcMeasurePropMap(this.calcMeasurePropMap);
            }
            return memento;
        }
        catch (OlapException e) {
            logger.error(null, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void setBookmarkState(Object state) {
        XMLA_Memento memento = (XMLA_Memento)state;
        this.mdxQuery = memento.getMdxQuery();
        try {
            if (this.isInitialized) {
                this.parse(this.mdxQuery);
                this.queryAdapter = new XMLA_QueryAdapter(this);
                XMLA_SortRank sortExt = (XMLA_SortRank)this.getExtension("sortRank");
                if (sortExt != null) {
                    sortExt.reset();
                }
                this.isNewCube = false;
            } else {
                this.uri = memento.getUri();
                this.dataSource = memento.getDataSource();
                this.catalog = memento.getCatalog();
                this.mdxQuery = memento.getMdxQuery();
                this.initialize();
            }
            this.result = (XMLA_Result)this.getResult();
        }
        catch (OlapException e) {
            String err = e.getMessage();
            logger.fatal((Object)err);
            throw new RuntimeException(err);
        }
        boolean useQuax = memento.isUseQuax();
        this.queryAdapter.setUseQuax(useQuax);
        if (useQuax) {
            QuaxBean[] quaxBeans = memento.getQuaxes();
            Quax[] quaxes = this.queryAdapter.getQuaxes();
            try {
                this.quaxesFromBeans(quaxes, quaxBeans);
            }
            catch (OlapException e) {
                throw new IllegalArgumentException(e.toString());
            }
        }
        XMLA_SortRank sortExt = (XMLA_SortRank)this.getExtension("sortRank");
        this.restoreSort(sortExt, memento);
        this.queryAdapter.setSwapAxes(memento.isAxesSwapped());
        this.calcMeasurePropMap = memento.getCalcMeasurePropMap();
        if (this.calcMeasurePropMap == null) {
            this.calcMeasurePropMap = new HashMap();
        }
        this.result = null;
    }

    private TreeNode createPosTreeFromBean(PositionNodeBean rootBean) throws OlapException {
        ExpBean expBean = rootBean.getReference();
        Exp exp = expBean == null ? null : (Exp)this.createExpFromBean(expBean);
        TreeNode node = new TreeNode(exp);
        PositionNodeBean[] beanChildren = rootBean.getChildren();
        for (int i = 0; i < beanChildren.length; ++i) {
            TreeNode childNode = this.createPosTreeFromBean(beanChildren[i]);
            node.addChildNode(childNode);
        }
        return node;
    }

    protected Object createExpFromBean(ExpBean expBean) throws OlapException {
        if (expBean.getType() == 0) {
            XMLA_Member member = (XMLA_Member)this.lookupMemberByUName(expBean.getName());
            if (member == null) {
                this.retrieveMember(expBean.getName());
            }
            if ((member = (XMLA_Member)this.lookupMemberByUName(expBean.getName())) == null) {
                throw new OlapException("could not find member " + expBean.getName());
            }
            return member;
        }
        if (expBean.getType() == 1) {
            String name = expBean.getName();
            ExpBean[] argBeans = expBean.getArgs();
            Exp[] args = new Exp[argBeans.length];
            for (int i = 0; i < argBeans.length; ++i) {
                args[i] = (Exp)this.createExpFromBean(argBeans[i]);
            }
            int synType = XMLA_Util.funCallSyntax(name);
            FunCall f = new FunCall(name, args, synType);
            return f;
        }
        if (expBean.getType() == 2) {
            XMLA_Level lev = this.lookupLevelByUName(expBean.getName());
            if (lev == null) {
                throw new OlapException("could not find Level " + expBean.getName());
            }
            return lev;
        }
        if (expBean.getType() == 4) {
            XMLA_Hierarchy hier = this.lookupHierByUName(expBean.getName());
            if (hier == null) {
                throw new OlapException("could not find Hierarchy " + expBean.getName());
            }
            return hier;
        }
        if (expBean.getType() == 3) {
            XMLA_Dimension dim = this.lookupDimByUName(expBean.getName());
            if (dim == null) {
                throw new OlapException("could not find Dimension " + expBean.getName());
            }
            return dim;
        }
        if (expBean.getType() == 5) {
            String str = (String)expBean.getLiteralValue();
            return Literal.createString(str);
        }
        if (expBean.getType() == 6) {
            Integer iii = (Integer)expBean.getLiteralValue();
            return Literal.create(iii);
        }
        if (expBean.getType() == 7) {
            Double ddd = (Double)expBean.getLiteralValue();
            return Literal.create(ddd);
        }
        throw new OlapException("Invalid ExpBean Type " + expBean.getType());
    }

    protected ExpBean createBeanFromExp(Object exp) throws OlapException {
        ExpBean bean = new ExpBean();
        if (exp instanceof Member) {
            XMLA_Member m = (XMLA_Member)exp;
            bean.setType(0);
            bean.setName(m.getUniqueName());
            bean.setArgs(new ExpBean[0]);
        } else if (exp instanceof FunCall) {
            FunCall f = (FunCall)exp;
            bean.setType(1);
            bean.setName(f.getFunction());
            ExpBean[] args = new ExpBean[f.getArgs().length];
            for (int i = 0; i < args.length; ++i) {
                args[i] = this.createBeanFromExp(f.getArgs()[i]);
            }
            bean.setArgs(args);
        } else if (exp instanceof Level) {
            XMLA_Level lev = (XMLA_Level)exp;
            bean.setType(2);
            bean.setName(lev.getUniqueName());
            bean.setArgs(new ExpBean[0]);
        } else if (exp instanceof Hierarchy) {
            XMLA_Hierarchy hier = (XMLA_Hierarchy)exp;
            bean.setType(4);
            bean.setName(hier.getUniqueName());
            bean.setArgs(new ExpBean[0]);
        } else if (exp instanceof Dimension) {
            XMLA_Dimension dim = (XMLA_Dimension)exp;
            bean.setType(3);
            bean.setName(dim.getUniqueName());
            bean.setArgs(new ExpBean[0]);
        } else if (exp instanceof Literal) {
            Literal lit = (Literal)exp;
            Object val = lit.getValueObject();
            if (lit.type == 3) {
                if (val instanceof Integer) {
                    bean.setType(6);
                } else {
                    bean.setType(7);
                }
            } else {
                bean.setType(5);
            }
            bean.setLiteralValue(val);
            bean.setArgs(new ExpBean[0]);
        } else {
            logger.fatal((Object)("cannot create ExpBean type =" + exp.getClass().toString()));
        }
        return bean;
    }

    private void parse(String mdxQuery) throws OlapException {
        StringReader reader = new StringReader(mdxQuery);
        parser parser_obj = new parser(new Lexer(reader));
        Symbol parse_tree = null;
        this.pQuery = null;
        try {
            parse_tree = parser_obj.parse();
        }
        catch (Exception e) {
            throw new OlapException(e);
        }
        this.pQuery = (ParsedQuery)parse_tree.value;
        this.pQuery.afterParse();
        String newCube = this.pQuery.getCube();
        if (this.cube == null || !this.cube.equals(newCube)) {
            this.isNewCube = true;
            this.cube = newCube;
        }
    }

    private void initCubeMetaData() throws OlapException {
        XMLA_Hierarchy hier;
        List dims = this.soap.discoverDim(this.catalog, this.pQuery.getCube());
        this.evaluateDimensions(dims);
        List hiers = this.soap.discoverHier(this.catalog, this.pQuery.getCube(), null);
        this.evaluateHiers(hiers);
        HashMap<String, XMLA_Dimension> hDim = new HashMap<String, XMLA_Dimension>();
        Iterator iter = this.aDimensions.iterator();
        while (iter.hasNext()) {
            XMLA_Dimension dim = (XMLA_Dimension)iter.next();
            hDim.put(dim.getUniqueName(), dim);
        }
        iter = this.aHierarchies.iterator();
        while (iter.hasNext()) {
            XMLA_Hierarchy hier2 = (XMLA_Hierarchy)iter.next();
            XMLA_Dimension dim = (XMLA_Dimension)hDim.get(hier2.getDimUniqueName());
            if (dim == null) continue;
            dim.addHier(hier2);
            hier2.setDimension(dim);
        }
        List levels = this.soap.discoverLev(this.catalog, this.pQuery.getCube(), null, null);
        this.evaluateLevels(levels);
        HashMap<String, XMLA_Hierarchy> hHier = new HashMap<String, XMLA_Hierarchy>();
        Iterator iter2 = this.aHierarchies.iterator();
        while (iter2.hasNext()) {
            hier = (XMLA_Hierarchy)iter2.next();
            hHier.put(hier.getUniqueName(), hier);
        }
        iter2 = this.aLevels.iterator();
        while (iter2.hasNext()) {
            XMLA_Level lev = (XMLA_Level)iter2.next();
            XMLA_Hierarchy hier3 = (XMLA_Hierarchy)hHier.get(lev.getHierUniqueName());
            if (hier3 == null) continue;
            hier3.addLevel(lev);
            lev.setHierarchy(hier3);
        }
        iter2 = this.aHierarchies.iterator();
        while (iter2.hasNext()) {
            hier = (XMLA_Hierarchy)iter2.next();
            this.adjustLevels(hier);
        }
        List propList = null;
        try {
            propList = this.soap.discoverProp(this.getCatalog(), this.getCube(), null, null, null);
        }
        catch (OlapException e) {
            logger.error((Object)"?", (Throwable)e);
        }
        if (propList != null && propList.size() > 0) {
            Iterator iterator = propList.iterator();
            while (iterator.hasNext()) {
                OlapItem poi = (OlapItem)iterator.next();
                String name = poi.getName();
                String propType = poi.getProperty("PROPERTY_TYPE");
                if (!"1".equals(propType)) continue;
                String levUName = poi.getProperty("LEVEL_UNIQUE_NAME");
                String dimUName = poi.getProperty("DIMENSION_UNIQUE_NAME");
                String caption = poi.getCaption();
                if (caption == null) {
                    caption = name;
                }
                XMLA_Dimension dim = this.lookupDimByUName(dimUName);
                if (this.isSAP() || this.isMondrian()) {
                    XMLA_MemberProp prop = new XMLA_MemberProp(name, caption, dim);
                    dim.addProp(prop);
                    continue;
                }
                if (levUName == null || levUName.length() <= 0) continue;
                XMLA_Level level = this.lookupLevelByUName(levUName);
                XMLA_MemberProp prop = new XMLA_MemberProp(name, caption, level);
                level.addProp(prop);
            }
        }
    }

    private void adjustLevels(XMLA_Hierarchy hier) {
        int num;
        int i;
        XMLA_Level[] levels = (XMLA_Level[])hier.getLevels();
        XMLA_Level[] orderedLevels = new XMLA_Level[levels.length];
        for (i = 0; i < levels.length; ++i) {
            num = levels[i].getDepth();
            orderedLevels[num] = levels[i];
        }
        for (i = 0; i < levels.length; ++i) {
            num = levels[i].getDepth();
            if (num > 0) {
                levels[i].setParentLevel(orderedLevels[num - 1]);
            } else {
                levels[i].setParentLevel(null);
            }
            if (num < levels.length - 1) {
                levels[i].setChildLevel(orderedLevels[num + 1]);
                continue;
            }
            levels[i].setChildLevel(null);
        }
    }

    private void evaluateDimensions(List dims) {
        Iterator iter = dims.iterator();
        while (iter.hasNext()) {
            OlapItem dimit = (OlapItem)iter.next();
            XMLA_Dimension dim = new XMLA_Dimension();
            dim.setName(dimit.getName());
            dim.setCaption(dimit.getCaption());
            dim.setUniqueName(dimit.getUniqueName());
            String str = dimit.getProperty("DIMENSION_ORDINAL");
            if (str != null) {
                dim.setOrdinal(Integer.parseInt(str));
            }
            if ((str = dimit.getProperty("DIMENSION_TYPE")) != null) {
                dim.setType(Integer.parseInt(str));
            }
            if ((str = dimit.getProperty("DIMENSION_CARDINALITY")) != null) {
                dim.setCardinality(Integer.parseInt(str));
            }
            if ((str = dimit.getProperty("DEFAULT_HIERARCHY")) != null) {
                dim.setDefaultHier(str);
            }
            if ((str = dimit.getProperty("IS_VIRTUAL")) != null) {
                dim.setVirtual(str.equals("true"));
            }
            if ((str = dimit.getProperty("IS_READWRITE")) != null) {
                dim.setReadWrite(str.equals("true"));
            }
            if ((str = dimit.getProperty("DIMENSION_UNIQUE_SETTINGS")) != null) {
                dim.setUniqueSettings(Integer.parseInt(str));
            }
            if ((str = dimit.getProperty("DIMENSION_IS_VISIBLE")) != null) {
                dim.setVisible(str.equals("true"));
            }
            this.aDimensions.add(dim);
        }
    }

    private void evaluateHiers(List hiers) {
        Iterator iter = hiers.iterator();
        while (iter.hasNext()) {
            OlapItem hierit = (OlapItem)iter.next();
            XMLA_Hierarchy hier = new XMLA_Hierarchy(this);
            hier.setCaption(hierit.getCaption());
            hier.setUniqueName(hierit.getUniqueName());
            String str = hierit.getProperty("HIERARCHY_CAPTION");
            if (str != null) {
                hier.setCaption(str);
            }
            if ((str = hierit.getProperty("DIMENSION_UNIQUE_NAME")) != null) {
                hier.setDimUniqueName(str);
            }
            if ((str = hierit.getProperty("DIMENSION_TYPE")) != null) {
                hier.setDimType(Integer.parseInt(str));
            }
            if ((str = hierit.getProperty("HIERARCHY_CARDINALITY")) != null) {
                hier.setCardinality(Integer.parseInt(str));
            }
            if ((str = hierit.getProperty("DEFAULT_MEMBER")) != null) {
                hier.setDefaultMember(str);
            }
            if ((str = hierit.getProperty("ALL_MEMBER")) != null) {
                hier.setAllMember(str);
            }
            if ((str = hierit.getProperty("STRUCTURE")) != null) {
                hier.setStructure(Integer.parseInt(str));
            }
            if ((str = hierit.getProperty("IS_VIRTUAL")) != null) {
                hier.setVirtual(str.equals("true"));
            }
            if ((str = hierit.getProperty("IS_READWRITE")) != null) {
                hier.setReadWrite(str.equals("true"));
            }
            if ((str = hierit.getProperty("DIMENSION_UNIQUE_SETTINGS")) != null) {
                hier.setDimUniqueSettings(Integer.parseInt(str));
            }
            if ((str = hierit.getProperty("DIMENSION_IS_VISIBLE")) != null) {
                hier.setDimVisible(str.equals("true"));
            }
            if ((str = hierit.getProperty("HIERARCHY_ORDINAL")) != null) {
                hier.setOrdinal(Integer.parseInt(str));
            }
            if ((str = hierit.getProperty("DIMENSION_IS_SHARED")) != null) {
                hier.setDimShared(str.equals("true"));
            }
            this.aHierarchies.add(hier);
        }
    }

    private void evaluateLevels(List levels) {
        Iterator iter = levels.iterator();
        while (iter.hasNext()) {
            OlapItem levit = (OlapItem)iter.next();
            XMLA_Level lev = new XMLA_Level(this);
            lev.setName(levit.getName());
            lev.setCaption(levit.getCaption());
            lev.setUniqueName(levit.getUniqueName());
            String str = levit.getProperty("DIMENSION_UNIQUE_NAME");
            if (str != null) {
                lev.setDimUniqueName(str);
            }
            if ((str = levit.getProperty("HIERARCHY_UNIQUE_NAME")) != null) {
                lev.setHierUniqueName(str);
            }
            if ((str = levit.getProperty("LEVEL_NUMBER")) != null) {
                lev.setNumber(Integer.parseInt(str));
            }
            if ((str = levit.getProperty("LEVEL_CARDINALITY")) != null) {
                lev.setCardinality(Integer.parseInt(str));
            }
            if ((str = levit.getProperty("LEVEL_TYPE")) != null) {
                lev.setType(Integer.parseInt(str));
            }
            if ((str = levit.getProperty("CUSTOM_ROLLUP_SETTINGS")) != null) {
                lev.setCustomRollupSettings(Integer.parseInt(str));
            }
            if ((str = levit.getProperty("LEVEL_UNIQUE_SETTINGS")) != null) {
                lev.setUniqueSettings(Integer.parseInt(str));
            }
            if ((str = levit.getProperty("LEVEL_IS_VISIBLE")) != null) {
                lev.setVisible(str.equals("true"));
            }
            if ((str = levit.getProperty("LEVEL_ORDERING_PROPERTY")) != null) {
                lev.setOrderingProperty(str);
            }
            if ((str = levit.getProperty("LEVEL_DBTYPE")) != null) {
                lev.setDbType(Integer.parseInt(str));
            }
            if ((str = levit.getProperty("LEVEL_NAME_SQL_COLUMN_NAME")) != null) {
                lev.setNameSqlColumnName(str);
            }
            if ((str = levit.getProperty("LEVEL_KEY_SQL_COLUMN_NAME")) != null) {
                lev.setKeySqlColumnName(str);
            }
            if ((str = levit.getProperty("LEVEL_UNIQUE_NAME_SQL_COLUMN_NAME")) != null) {
                lev.setUniqueNameSqlColumnName(str);
            }
            this.aLevels.add(lev);
        }
    }

    void completeLevel(XMLA_Level level) throws OlapException {
        List mems = this.soap.discoverMem(this.catalog, this.cube, null, level.getHierUniqueName(), level.getUniqueName());
        ArrayList aNewMembers = new ArrayList();
        ArrayList aAllMembers = new ArrayList();
        this.evaluateMembers(mems, aNewMembers, aAllMembers);
        this.aMembers.addAll(aNewMembers);
        level.setMembers(aAllMembers);
    }

    void retrieveMemberChildren(XMLA_Member member) throws OlapException {
        List mems = this.soap.discoverMemTree(this.catalog, this.cube, member.getUniqueName(), 1);
        ArrayList aNewMembers = new ArrayList();
        ArrayList aAllMembers = new ArrayList();
        this.evaluateMembers(mems, aNewMembers, aAllMembers);
        this.aMembers.addAll(aNewMembers);
        this.setMemberChildren(member, aAllMembers);
    }

    void retrieveMemberParent(XMLA_Member member) throws OlapException {
        String pUname;
        member.setParentOk(true);
        if (((XMLA_Level)member.getLevel()).getDepth() == 0 || ((XMLA_Level)member.getLevel()).getParentLevel() == null) {
            member.setParent(null);
            return;
        }
        if (member.isComplete() && ((pUname = member.getParentUniqueName()) == null || pUname.length() == 0)) {
            member.setParent(null);
            return;
        }
        List mems = this.soap.discoverMemTree(this.catalog, this.cube, member.getUniqueName(), 4);
        Iterator iter = mems.iterator();
        while (iter.hasNext()) {
            OlapItem oli = (OlapItem)iter.next();
            if (!oli.getUniqueName().equals(member.getUniqueName())) continue;
            member.setParent(null);
            return;
        }
        if (mems.size() == 0) {
            member.setParent(null);
            return;
        }
        ArrayList aNewMembers = new ArrayList();
        ArrayList aAllMembers = new ArrayList();
        this.evaluateMembers(mems, aNewMembers, aAllMembers);
        this.aMembers.addAll(aNewMembers);
        XMLA_Member pmem = (XMLA_Member)aAllMembers.get(0);
        member.setParent(pmem);
    }

    void completeMember(XMLA_Member member) throws OlapException {
        List mems = this.soap.discoverMemTree(this.catalog, this.cube, member.getUniqueName(), 8);
        ArrayList aNewMembers = new ArrayList();
        ArrayList aAllMembers = new ArrayList();
        this.evaluateMembers(mems, aNewMembers, aAllMembers);
    }

    public void retrieveMember(String uniqueName) throws OlapException {
        List mems = this.soap.discoverMemTree(this.catalog, this.cube, uniqueName, 8);
        ArrayList aNewMembers = new ArrayList();
        ArrayList aAllMembers = new ArrayList();
        this.evaluateMembers(mems, aNewMembers, aAllMembers);
        this.aMembers.addAll(aNewMembers);
        XMLA_Member member = (XMLA_Member)this.lookupMemberByUName(uniqueName);
        if (member == null) {
            throw new OlapException("could not find member " + uniqueName);
        }
    }

    private void setMemberChildren(XMLA_Member member, ArrayList aAllMembers) {
        ArrayList<XMLA_Member> aChildren = new ArrayList<XMLA_Member>();
        Iterator iter = aAllMembers.iterator();
        while (iter.hasNext()) {
            XMLA_Member mem = (XMLA_Member)iter.next();
            if (!member.getUniqueName().equals(mem.getParentUniqueName())) continue;
            aChildren.add(mem);
        }
        member.setChildren(aChildren);
        member.setChildrenOk(true);
        iter = aChildren.iterator();
        while (iter.hasNext()) {
            XMLA_Member child = (XMLA_Member)iter.next();
            child.setParent(member);
            child.setParentOk(true);
        }
    }

    private void evaluateMembers(List mems, List aNewMembers, List aAllMembers) {
        Iterator iter = mems.iterator();
        while (iter.hasNext()) {
            OlapItem oi = (OlapItem)iter.next();
            String uName = oi.getUniqueName();
            XMLA_Member mem = (XMLA_Member)this.lookupMemberByUName(uName);
            if (mem != null) {
                aAllMembers.add(mem);
            } else {
                String caption = oi.getCaption();
                String levUName = oi.getProperty("LEVEL_UNIQUE_NAME");
                XMLA_Level lev = this.lookupLevelByUName(levUName);
                boolean isCalc = this.isMemberInFormulas(uName);
                mem = new XMLA_Member(this, uName, caption, lev, isCalc);
                aNewMembers.add(mem);
                aAllMembers.add(mem);
            }
            if (mem.isComplete()) continue;
            long ordinal = 0L;
            String sOrdinal = oi.getProperty("MEMBER_ORDINAL");
            if (sOrdinal != null) {
                ordinal = Long.parseLong(sOrdinal);
            }
            String name = oi.getName();
            int type = 0;
            String str = oi.getProperty("MEMBER_TYPE");
            if (str != null) {
                type = Integer.parseInt(str);
            }
            long childrenCard = 0L;
            String sCard = oi.getProperty("CHILDREN_CARDINALITY");
            if (sCard != null) {
                childrenCard = Long.parseLong(sCard);
            }
            long parentLevel = 0L;
            String sLev = oi.getProperty("PARENT_LEVEL");
            if (sLev != null) {
                parentLevel = Long.parseLong(sLev);
            }
            String parentUniqueName = oi.getProperty("PARENT_UNIQUE_NAME");
            String key = oi.getProperty("MEMBER_KEY");
            boolean isPlaceHolderMember = "true".equals(oi.getProperty("IS_PLACEHOLDERMEMBER"));
            boolean isDataMember = "true".equals(oi.getProperty("IS_DATAMEMBER"));
            mem.complete(name, type, ordinal, parentUniqueName, childrenCard, parentLevel, isDataMember, isPlaceHolderMember, key);
        }
    }

    public boolean isMemberInFormulas(String uName) {
        if (this.pQuery == null) {
            return false;
        }
        Formula[] formulas = this.pQuery.getFormulas();
        for (int i = 0; i < formulas.length; ++i) {
            if (!formulas[i].isMember() || !uName.equals(formulas[i].getUniqeName())) continue;
            return true;
        }
        return false;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getUri() {
        return this.uri;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public ParsedQuery getPQuery() {
        return this.pQuery;
    }

    public QueryAdapter getQueryAdapter() {
        return this.queryAdapter;
    }

    public String getID() {
        return this.ID;
    }

    public void setID(String string) {
        this.ID = string;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public boolean isSAP() {
        return this.soap.getProvider() == 2;
    }

    public boolean isMicrosoft() {
        return this.soap.getProvider() == 1;
    }

    public boolean isMondrian() {
        return this.soap.getProvider() == 3;
    }

    public String getCube() {
        if (this.pQuery == null) {
            return null;
        }
        return this.pQuery.getCube();
    }

    public Map getCalcMeasurePropMap() {
        return this.calcMeasurePropMap;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }
}

