/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.xmla;

import com.tonbeller.jpivot.olap.mdxparse.CompoundId;
import com.tonbeller.jpivot.olap.mdxparse.Exp;
import com.tonbeller.jpivot.olap.mdxparse.ExpVisitor;
import com.tonbeller.jpivot.olap.model.Dimension;
import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.Level;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.OlapException;
import com.tonbeller.jpivot.olap.model.Visitor;
import com.tonbeller.jpivot.olap.query.MDXElement;
import com.tonbeller.jpivot.util.StringUtil;
import com.tonbeller.jpivot.xmla.XMLA_Level;
import com.tonbeller.jpivot.xmla.XMLA_Model;
import com.tonbeller.tbutils.res.Resources;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class XMLA_Hierarchy
implements Hierarchy,
Exp,
MDXElement {
    static Logger logger = Logger.getLogger((Class)XMLA_Hierarchy.class);
    private String dimUniqueName;
    private String uniqueName;
    private String caption;
    private int dimType;
    private int cardinality;
    private String defaultMember;
    private String allMember;
    private XMLA_Model model;
    public static final int STRUCTURE_FULLYBALANCED = 0;
    public static final int STRUCTURE_RAGGEDBALANCED = 1;
    public static final int STRUCTURE_UNBALANCED = 2;
    private int structure = 0;
    private boolean isVirtual;
    private boolean isReadWrite;
    private int dimUniqueSettings;
    private boolean isDimVisible;
    private int ordinal;
    private boolean isDimShared;
    private boolean isMembersGotten = false;
    private Dimension dimension = null;
    private ArrayList aLevels = new ArrayList();

    public XMLA_Hierarchy(XMLA_Model model) {
        this.model = model;
    }

    public String getAllMemberName() {
        return this.allMember;
    }

    public Member getAllMember() {
        if (this.allMember == null) {
            return null;
        }
        Member mAll = this.model.lookupMemberByUName(this.allMember);
        if (mAll != null) {
            return mAll;
        }
        try {
            this.model.retrieveMember(this.allMember);
        }
        catch (OlapException e) {
            logger.error((Object)("could not retrieve member " + this.allMember), (Throwable)e);
        }
        return this.model.lookupMemberByUName(this.allMember);
    }

    public String getCaption() {
        return Resources.instance().getOptionalString(this.caption, this.caption);
    }

    public int getCardinality() {
        return this.cardinality;
    }

    public String getDefaultMember() {
        return this.defaultMember;
    }

    public int getDimType() {
        return this.dimType;
    }

    public String getDimUniqueName() {
        return this.dimUniqueName;
    }

    public int getDimUniqueSettings() {
        return this.dimUniqueSettings;
    }

    public boolean isDimShared() {
        return this.isDimShared;
    }

    public boolean isDimVisible() {
        return this.isDimVisible;
    }

    public boolean isReadWrite() {
        return this.isReadWrite;
    }

    public boolean isVirtual() {
        return this.isVirtual;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public int getStructure() {
        return this.structure;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public void setAllMember(String allMember) {
        this.allMember = allMember;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public void setCardinality(int cardinality) {
        this.cardinality = cardinality;
    }

    public void setDefaultMember(String defaultMember) {
        this.defaultMember = defaultMember;
    }

    public void setDimType(int dimType) {
        this.dimType = dimType;
    }

    public void setDimUniqueName(String dimUniqueName) {
        this.dimUniqueName = dimUniqueName;
    }

    public void setDimUniqueSettings(int dimUniqueSettings) {
        this.dimUniqueSettings = dimUniqueSettings;
    }

    public void setDimShared(boolean isDimShared) {
        this.isDimShared = isDimShared;
    }

    public void setDimVisible(boolean isDimVisible) {
        this.isDimVisible = isDimVisible;
    }

    public void setReadWrite(boolean isReadWrite) {
        this.isReadWrite = isReadWrite;
    }

    public void setVirtual(boolean isVirtual) {
        this.isVirtual = isVirtual;
    }

    public void setOrdinal(int ordinal) {
        this.ordinal = ordinal;
    }

    public void setStructure(int structure) {
        this.structure = structure;
    }

    public void setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public Level[] getLevels() {
        return this.aLevels.toArray(new XMLA_Level[0]);
    }

    public String getLabel() {
        return this.getCaption();
    }

    public void accept(Visitor visitor) {
        visitor.visitHierarchy(this);
    }

    public Object getRootDecoree() {
        return this;
    }

    public void setDimension(Dimension dimension) {
        this.dimension = dimension;
    }

    public void addLevel(Level lev) {
        this.aLevels.add(lev);
    }

    public boolean isEqual(XMLA_Hierarchy other) {
        return this.getUniqueName().equals(other.getUniqueName());
    }

    protected boolean isMembersGotten() {
        return this.isMembersGotten;
    }

    protected void setMembersGotten(boolean isMembersGotten) {
        this.isMembersGotten = isMembersGotten;
    }

    public String toMdx() {
        return this.uniqueName;
    }

    public Object clone() {
        String[] nameParts = StringUtil.splitUniqueName(this.uniqueName);
        CompoundId clone = new CompoundId(nameParts[0], false);
        for (int i = 1; i < nameParts.length; ++i) {
            clone.append(nameParts[i], false);
        }
        return clone;
    }

    public void accept(ExpVisitor visitor) {
        visitor.visitHierarchy(this);
    }

    public boolean hasAll() {
        return this.allMember != null;
    }
}

