/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.tags;

import com.tonbeller.jpivot.core.ModelChangeEvent;
import com.tonbeller.jpivot.core.ModelChangeListener;
import com.tonbeller.jpivot.olap.model.OlapException;
import com.tonbeller.jpivot.olap.model.OlapModel;
import com.tonbeller.jpivot.olap.model.OlapModelDecorator;
import com.tonbeller.jpivot.olap.model.impl.Empty;
import com.tonbeller.jpivot.tags.PageStateManager;
import com.tonbeller.jpivot.tags.StackStateManager;
import com.tonbeller.jpivot.tags.StateManager;
import com.tonbeller.jpivot.tags.TestStateLogger;
import com.tonbeller.tbutils.testenv.Environment;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import org.apache.log4j.Logger;

public class OlapModelProxy
extends OlapModelDecorator
implements HttpSessionBindingListener {
    ArrayList listeners = new ArrayList();
    public static final String DEFAULT_NAME = "default";
    private static final Logger logger = Logger.getLogger((Class)OlapModelProxy.class);
    private ModelChangeListener modelChangeListener = new ModelChangeListener(){

        public void modelChanged(ModelChangeEvent e) {
            OlapModelProxy.this.fireModelChanged();
        }

        public void structureChanged(ModelChangeEvent e) {
            OlapModelProxy.this.fireStructureChanged();
        }
    };
    StateManager stateManager;

    public OlapModelProxy() {
        this(true);
    }

    private OlapModelProxy(boolean stackMode) {
        super(Empty.EMPTY_MODEL);
        this.stateManager = stackMode ? new StackStateManager() : new PageStateManager();
        if (Environment.isTest()) {
            this.stateManager.setLogger(new TestStateLogger());
        }
    }

    public static OlapModelProxy instance(String id, HttpSession session) {
        return OlapModelProxy.instance(id, session, true);
    }

    public static OlapModelProxy instance(String id, HttpSession session, boolean stackMode) {
        OlapModelProxy omp = (OlapModelProxy)session.getAttribute(id);
        if (omp == null) {
            omp = new OlapModelProxy(stackMode);
            session.setAttribute(id, (Object)omp);
        }
        return omp;
    }

    public void initializeAndShow(OlapModel model) throws Exception {
        MyState s = new MyState(model);
        this.stateManager.initializeAndShow(s);
    }

    String nonEmptyQueryName(String queryName) {
        if (queryName == null || queryName.length() == 0) {
            return DEFAULT_NAME;
        }
        return queryName;
    }

    public void initializeAndShow(String queryName, OlapModel model) throws Exception {
        queryName = this.nonEmptyQueryName(queryName);
        MyState s = new MyState(queryName, model);
        this.stateManager.initializeAndShow(s);
    }

    public void showByName(String queryName) throws Exception {
        queryName = this.nonEmptyQueryName(queryName);
        this.stateManager.showByName(queryName);
    }

    public void destroyAll() throws Exception {
        this.stateManager.destroyAll();
    }

    public void destroyQuery(String queryName) throws Exception {
        queryName = this.nonEmptyQueryName(queryName);
        this.stateManager.destroyByName(queryName);
    }

    private void fireModelChanged() {
        ModelChangeEvent e = new ModelChangeEvent(this);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ModelChangeListener l = (ModelChangeListener)iter.next();
            l.modelChanged(e);
        }
    }

    private void fireStructureChanged() {
        ModelChangeEvent e = new ModelChangeEvent(this);
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ModelChangeListener l = (ModelChangeListener)iter.next();
            l.structureChanged(e);
        }
    }

    public void addModelChangeListener(ModelChangeListener l) {
        this.listeners.add(l);
    }

    public void removeModelChangeListener(ModelChangeListener l) {
        this.listeners.remove(l);
    }

    public void valueBound(HttpSessionBindingEvent ev) {
    }

    public void valueUnbound(HttpSessionBindingEvent ev) {
        logger.info((Object)"session timeout");
        try {
            this.stateManager.destroyAll();
        }
        catch (Exception e) {
            logger.error(null, (Throwable)e);
        }
    }

    public void destroy() {
        throw new RuntimeException("must not be called");
    }

    public void initialize() {
        throw new RuntimeException("must not be called");
    }

    public StateManager getStateManager() {
        return this.stateManager;
    }

    class MyState
    implements StateManager.State {
        String name;
        OlapModel model;

        MyState(OlapModel model) {
            this.name = OlapModelProxy.DEFAULT_NAME;
            this.model = model;
        }

        MyState(String name, OlapModel model) {
            this.name = name;
            this.model = model;
        }

        public void initialize() throws Exception {
            try {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("initializing: " + this.model));
                }
                this.model.initialize();
            }
            catch (OlapException e) {
                logger.error(null, (Throwable)e);
                throw e;
            }
        }

        public void destroy() throws Exception {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("destroying: " + this.model));
            }
            this.model.destroy();
        }

        public void show() throws OlapException {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("activating: " + this.model));
            }
            this.model.addModelChangeListener(OlapModelProxy.this.modelChangeListener);
            OlapModelProxy.this.setDelegate(this.model);
            OlapModelProxy.this.fireStructureChanged();
        }

        public void hide() throws OlapException {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("deactivating: " + this.model));
            }
            this.model.removeModelChangeListener(OlapModelProxy.this.modelChangeListener);
            OlapModelProxy.this.setDelegate(Empty.EMPTY_MODEL);
            OlapModelProxy.this.fireStructureChanged();
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

