/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.print;

import com.tonbeller.jpivot.chart.ChartComponent;
import com.tonbeller.jpivot.print.PrintComponent;
import com.tonbeller.jpivot.table.TableComponent;
import com.tonbeller.tbutils.res.Resources;
import com.tonbeller.wcf.component.RendererParameters;
import com.tonbeller.wcf.controller.RequestContext;
import com.tonbeller.wcf.controller.RequestContextFactoryFinder;
import com.tonbeller.wcf.utils.XmlUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.fop.apps.Driver;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.Options;
import org.apache.fop.configuration.Configuration;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class PrintServlet
extends HttpServlet {
    private static Logger logger = Logger.getLogger((Class)PrintServlet.class);
    private static final int XML = 0;
    private static final int PDF = 1;
    String basePath;
    String filename;
    Resources resources = Resources.instance();

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            Configuration.put((String)"fontBaseDir", (Object)config.getServletContext().getRealPath("/WEB-INF/jpivot/print/"));
            String fopConfigPath = config.getServletContext().getRealPath("/WEB-INF/jpivot/print/userconfig.xml");
            new Options(new File(fopConfigPath));
        }
        catch (FOPException e) {
            e.printStackTrace();
            logger.error((Object)"FOP user config file not loaded");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)"FOP user config file not loaded");
        }
    }

    public void destroy() {
    }

    protected void processRequest(RequestContext context) throws ServletException, IOException {
        block17: {
            HttpServletRequest request = context.getRequest();
            HttpServletResponse response = context.getResponse();
            if (request.getParameter("cube") != null && request.getParameter("type") != null) {
                try {
                    ChartComponent chart;
                    String xslUri = null;
                    int type = Integer.parseInt(request.getParameter("type"));
                    switch (type) {
                        case 0: {
                            xslUri = "/WEB-INF/jpivot/table/xls_mdxtable.xsl";
                            RendererParameters.setParameter((HttpServletRequest)context.getRequest(), (String)"mode", (Object)"excel", (String)"request");
                            response.setContentType("application/vnd.ms-excel");
                            this.filename = "xls_export.xls";
                            break;
                        }
                        case 1: {
                            xslUri = "/WEB-INF/jpivot/table/fo_mdxtable.xsl";
                            RendererParameters.setParameter((HttpServletRequest)context.getRequest(), (String)"mode", (Object)"print", (String)"request");
                            response.setContentType("application/pdf");
                            this.filename = "xls_export.pdf";
                        }
                    }
                    if (xslUri == null) break block17;
                    boolean xslCache = true;
                    String tableRef = "table" + request.getParameter("cube");
                    String chartRef = "chart" + request.getParameter("cube");
                    String printRef = "print" + request.getParameter("cube");
                    HashMap<String, Object> parameters = new HashMap<String, Object>();
                    ServletOutputStream outStream = response.getOutputStream();
                    PrintWriter out = new PrintWriter((OutputStream)outStream);
                    HttpSession session = request.getSession();
                    response.setHeader("Content-Disposition", "attachment; filename=" + this.filename);
                    TableComponent table = (TableComponent)context.getModelReference(tableRef);
                    if (table == null) break block17;
                    PrintComponent printConfig = (PrintComponent)((Object)context.getModelReference(printRef));
                    if (printConfig != null) {
                        if (printConfig.isSetTableWidth()) {
                            parameters.put(printConfig.PRINT_TABLE_WIDTH, new Double(printConfig.getTableWidth()));
                        }
                        if (printConfig.getReportTitle().trim().length() != 0) {
                            parameters.put(printConfig.PRINT_TITLE, printConfig.getReportTitle().trim());
                        }
                        parameters.put(printConfig.PRINT_PAGE_ORIENTATION, printConfig.getPageOrientation());
                        parameters.put(printConfig.PRINT_PAPER_TYPE, printConfig.getPaperType());
                        if (printConfig.getPaperType().equals(this.resources.getString("jsp.wcf.print.custom"))) {
                            parameters.put(printConfig.PRINT_PAGE_WIDTH, new Double(printConfig.getPageWidth()));
                            parameters.put(printConfig.PRINT_PAGE_HEIGHT, new Double(printConfig.getPageHeight()));
                        }
                        parameters.put(printConfig.PRINT_CHART_PAGEBREAK, new Boolean(printConfig.isChartPageBreak()));
                    }
                    if ((chart = (ChartComponent)request.getSession().getAttribute(chartRef)) != null && chart.isVisible()) {
                        String host = request.getServerName();
                        int port = request.getServerPort();
                        String location = request.getContextPath();
                        String scheme = request.getScheme();
                        String chartServlet = scheme + "://" + host + ":" + port + location + "/GetChart";
                        parameters.put("chartimage", chartServlet + "?filename=" + chart.getFilename());
                        parameters.put("chartheight", new Integer(chart.getChartHeight()));
                        parameters.put("chartwidth", new Integer(chart.getChartWidth()));
                    }
                    parameters.put("context", context.getRequest().getContextPath());
                    table.setDirty(true);
                    Document document = table.render(context);
                    table.setDirty(true);
                    DOMSource source = new DOMSource(document);
                    Transformer transformer = XmlUtils.getTransformer((HttpSession)session, (String)xslUri, (boolean)xslCache);
                    Iterator it = parameters.keySet().iterator();
                    while (it.hasNext()) {
                        String name = (String)it.next();
                        Object value = parameters.get(name);
                        transformer.setParameter(name, value);
                    }
                    StringWriter sw = new StringWriter();
                    StreamResult result = new StreamResult(sw);
                    transformer.transform(source, result);
                    sw.flush();
                    if (type == 0) {
                        System.out.println("Writing XLS");
                        response.setContentLength(sw.toString().length());
                        out.write(sw.toString());
                        RendererParameters.removeParameter((HttpServletRequest)context.getRequest(), (String)"mode", (Object)"excel", (String)"request");
                    } else {
                        System.out.println("Creating PDF!");
                        try {
                            logger.debug((Object)this.resources.getString("jpivot.PrintServlet.message.encoding", new Object[]{this.resources.getCharacterEncoding()}));
                            ByteArrayInputStream bain = new ByteArrayInputStream(sw.toString().getBytes(this.resources.getCharacterEncoding()));
                            ByteArrayOutputStream baout = new ByteArrayOutputStream(16384);
                            this.convertFO2PDF(bain, baout);
                            byte[] content = baout.toByteArray();
                            response.setContentLength(content.length);
                            outStream.write(content);
                            RendererParameters.removeParameter((HttpServletRequest)context.getRequest(), (String)"mode", (Object)"print", (String)"request");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    out.flush();
                    out.close();
                    outStream.flush();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertFO2PDF(ByteArrayInputStream bain, ByteArrayOutputStream baout) throws IOException, FOPException {
        System.out.println("Construct driver");
        Driver driver = new Driver();
        System.out.println("Setup Renderer (output format)");
        driver.setRenderer(1);
        driver.setOutputStream((OutputStream)baout);
        System.out.println("Setup input");
        driver.setInputSource(new InputSource(bain));
        System.out.println("Process FO");
        driver.run();
        System.out.println("PDF file generation completed");
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        RequestContext context = RequestContextFactoryFinder.createContext((HttpServletRequest)request, (HttpServletResponse)response, (boolean)true);
        try {
            this.processRequest(context);
        }
        finally {
            context.invalidate();
        }
    }

    public String getServletInfo() {
        return "Export OLAP table";
    }
}

