/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.olap.model.impl;

import com.tonbeller.jpivot.olap.model.Cell;
import com.tonbeller.jpivot.olap.model.CellFormatter;
import com.tonbeller.jpivot.olap.model.impl.PropertyImpl;
import com.tonbeller.tbutils.res.Resources;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class FormatStringParser {
    private static Map cellFormatters = new HashMap();
    private RE regex1;
    private RE regex2;
    private Logger logger = Logger.getLogger((Class)FormatStringParser.class);
    Resources resources;

    public FormatStringParser() {
        try {
            this.regex1 = new RE("\\s*([a-zA-Z][\\w\\.]*)\\s*=\\s*'([^']*)'");
            this.regex2 = new RE("\\s*([a-zA-Z][\\w\\.]*)\\s*=\\s*([^\\s]*)");
            this.resources = Resources.instance((Class)FormatStringParser.class);
        }
        catch (RESyntaxException e) {
            this.logger.error(null, (Throwable)e);
        }
    }

    public Result parse(Cell cell, String formattedValue) {
        if (formattedValue == null) {
            return new Result("", Collections.EMPTY_LIST);
        }
        ArrayList<PropertyImpl> properties = Collections.EMPTY_LIST;
        if (formattedValue.startsWith("|")) {
            properties = new ArrayList<PropertyImpl>();
            String[] strs = formattedValue.substring(1).split("\\|");
            formattedValue = strs[0];
            for (int i = 1; i < strs.length; ++i) {
                String propName = null;
                String propValue = null;
                if (this.regex1.match(strs[i])) {
                    propName = this.regex1.getParen(1);
                    propValue = this.regex1.getParen(2);
                } else if (this.regex2.match(strs[i])) {
                    propName = this.regex2.getParen(1);
                    propValue = this.regex2.getParen(2);
                } else {
                    formattedValue = formattedValue + strs[i];
                    continue;
                }
                if (propName.equalsIgnoreCase("exit")) {
                    CellFormatter cf = this.getCellFormatter(propValue);
                    if (cf == null) continue;
                    formattedValue = cf.formatCell(cell);
                    continue;
                }
                PropertyImpl prop = new PropertyImpl();
                prop.setName(propName);
                prop.setLabel(propName);
                prop.setValue(propValue);
                properties.add(prop);
            }
        }
        return new Result(formattedValue, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CellFormatter getCellFormatter(String propValue) {
        Map map = cellFormatters;
        synchronized (map) {
            CellFormatter cf = (CellFormatter)cellFormatters.get(propValue);
            if (cf == null) {
                try {
                    String className = this.resources.getString("jsp.jpivot.cellfmt." + propValue);
                    Class<?> clazz = Class.forName(className);
                    Constructor<?> ctor = clazz.getConstructor(new Class[0]);
                    cf = (CellFormatter)ctor.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    this.logger.error((Object)("could not instantiate cell formatter " + propValue), (Throwable)e);
                }
                cellFormatters.put(propValue, cf);
            } else {
                this.logger.error((Object)("Could not find a property definition for exit = " + propValue));
            }
            return cf;
        }
    }

    public static class Result {
        String formattedValue;
        List properties;

        private Result(String formattedValue, List properties) {
            this.formattedValue = formattedValue;
            this.properties = properties;
        }

        public String getFormattedValue() {
            return this.formattedValue;
        }

        public List getProperties() {
            return this.properties;
        }
    }
}

