/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.mondrian;

import com.tonbeller.jpivot.core.ExtensionSupport;
import com.tonbeller.jpivot.mondrian.MondrianAxis;
import com.tonbeller.jpivot.mondrian.MondrianHierarchy;
import com.tonbeller.jpivot.mondrian.MondrianModel;
import com.tonbeller.jpivot.mondrian.MondrianQueryAdapter;
import com.tonbeller.jpivot.mondrian.MondrianUtil;
import com.tonbeller.jpivot.olap.model.Axis;
import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.navi.PlaceHierarchiesOnAxes;
import com.tonbeller.jpivot.olap.query.Quax;
import com.tonbeller.tbutils.res.Resources;
import java.util.ArrayList;
import java.util.List;
import mondrian.mdx.MemberExpr;
import mondrian.mdx.UnresolvedFunCall;
import mondrian.olap.Exp;
import mondrian.olap.Member;
import mondrian.olap.SchemaReader;
import mondrian.olap.Syntax;
import org.apache.log4j.Logger;

public class MondrianPlaceHierarchies
extends ExtensionSupport
implements PlaceHierarchiesOnAxes {
    private boolean expandAllMember = false;
    ArrayList aMemberSet = null;
    static Logger logger = Logger.getLogger((Class)MondrianPlaceHierarchies.class);
    Resources resources = Resources.instance();

    public MondrianPlaceHierarchies() {
        super.setId("hierarchiesOnAxes");
    }

    public Object createMemberExpression(Hierarchy hier) {
        mondrian.olap.Hierarchy monHier = ((MondrianHierarchy)hier).getMonHierarchy();
        MondrianModel model = (MondrianModel)this.getModel();
        MondrianQueryAdapter adapter = (MondrianQueryAdapter)model.getQueryAdapter();
        Quax quax = adapter.findQuax(hier.getDimension());
        if (quax == null) {
            SchemaReader scr = ((MondrianModel)this.getModel()).getMonConnection().getSchemaReader();
            return MondrianUtil.topLevelMembers(monHier, this.expandAllMember, scr);
        }
        int iDimension = quax.dimIdx(hier.getDimension());
        return quax.genExpForDim(iDimension);
    }

    public void setQueryAxis(Axis target, Object[] memberExpressions) {
        MondrianModel model = (MondrianModel)this.getModel();
        MondrianQueryAdapter adapter = (MondrianQueryAdapter)model.getQueryAdapter();
        int iQuax = ((MondrianAxis)target).getOrdinal();
        if (adapter.isSwapAxes()) {
            iQuax = (iQuax + 1) % 2;
        }
        Quax quax = adapter.getQuaxes()[iQuax];
        int nDimension = 0;
        for (int i = 0; i < memberExpressions.length; ++i) {
            if (memberExpressions[i] == null) continue;
            ++nDimension;
        }
        Object[] sets = new Object[nDimension];
        boolean changedMemberSet = false;
        int j = 0;
        for (int i = 0; i < memberExpressions.length; ++i) {
            if (memberExpressions[i] instanceof List) {
                List memberList = (List)memberExpressions[i];
                Exp[] members = new Exp[memberList.size()];
                for (int k = 0; k < members.length; ++k) {
                    members[k] = new MemberExpr((Member)memberList.get(k));
                }
                sets[j++] = members.length == 1 ? members[0] : new UnresolvedFunCall("{}", Syntax.Braces, members);
                changedMemberSet = true;
                continue;
            }
            if (memberExpressions[i] == null) continue;
            sets[j++] = memberExpressions[i];
        }
        quax.regeneratePosTree(sets, true);
        if (logger.isInfoEnabled()) {
            String changed = "";
            if (changedMemberSet) {
                changed = this.resources.getString("jpivot.MondrianPlaceHierarchies.message.changedByNavi");
            }
            logger.info((Object)(this.resources.getString("jpivot.MondrianPlaceHierarchies.message.setQueryAxis", new Object[]{new Integer(quax.getOrdinal()), new Integer(nDimension)}) + changed));
            logger.info((Object)this.resources.getString("jpivot.MondrianPlaceHierarchies.message.axisExpression", new Object[]{quax.toString()}));
        }
        quax.changed(this, changedMemberSet);
        model.fireModelChanged();
    }

    public void setExpandAllMember(boolean expandAllMember) {
        this.expandAllMember = expandAllMember;
    }

    public boolean getExpandAllMember() {
        return this.expandAllMember;
    }
}

