/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.mondrian;

import com.tonbeller.jpivot.core.ExtensionSupport;
import com.tonbeller.jpivot.mondrian.MondrianCell;
import com.tonbeller.jpivot.mondrian.MondrianDrillThroughTableModel;
import com.tonbeller.jpivot.mondrian.MondrianModel;
import com.tonbeller.jpivot.olap.model.Cell;
import com.tonbeller.jpivot.olap.navi.DrillThrough;
import com.tonbeller.tbutils.res.Resources;
import com.tonbeller.wcf.table.TableModel;
import mondrian.olap.Util;
import mondrian.rolap.RolapConnectionProperties;
import org.apache.log4j.Logger;

public class MondrianDrillThrough
extends ExtensionSupport
implements DrillThrough {
    private static Logger logger = Logger.getLogger((Class)MondrianDrillThrough.class);
    private boolean extendedContext = true;

    public MondrianDrillThrough() {
        super.setId("drillThrough");
    }

    public boolean canDrillThrough(Cell cell) {
        return ((MondrianCell)cell).getMonCell().canDrillThrough();
    }

    public TableModel drillThrough(Cell cell) {
        logger.debug((Object)Resources.instance().getString("jpivot.MondrianDrillThrough.debug.generateSql"));
        String sql = ((MondrianCell)cell).getMonCell().getDrillThroughSQL(this.extendedContext);
        if (sql == null) {
            String msg = Resources.instance().getString("jpivot.MondrianDrillThrough.error.drillThroughSQLReturnedNull");
            logger.error((Object)msg);
            throw new NullPointerException(msg);
        }
        logger.debug((Object)(Resources.instance().getString("jpivot.MondrianDrillThrough.debug.sqlEqual") + sql));
        MondrianDrillThroughTableModel dtm = new MondrianDrillThroughTableModel(cell);
        dtm.setSql(sql);
        Util.PropertyList connectInfo = ((MondrianModel)this.getModel()).getConnectProperties();
        String jdbcUrl = connectInfo.get(RolapConnectionProperties.Jdbc.name());
        String jdbcUser = connectInfo.get(RolapConnectionProperties.JdbcUser.name());
        String jdbcPassword = connectInfo.get(RolapConnectionProperties.JdbcPassword.name());
        String dataSourceName = connectInfo.get(RolapConnectionProperties.DataSource.name());
        dtm.setJdbcUrl(jdbcUrl);
        dtm.setJdbcUser(jdbcUser);
        dtm.setJdbcPassword(jdbcPassword);
        dtm.setDataSourceName(dataSourceName);
        return dtm;
    }

    public boolean isExtendedContext() {
        return this.extendedContext;
    }

    public void setExtendedContext(boolean extendedContext) {
        this.extendedContext = extendedContext;
    }
}

