/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.sample.ofc;

import com.jaspersoft.sample.ofc.BarChartCompiler;
import com.jaspersoft.sample.ofc.BarDataset;
import com.jaspersoft.sample.ofc.BarSeries;
import com.jaspersoft.sample.ofc.DefaultBarSeries;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.base.JRBaseElementDataset;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompiledBarDataset
extends JRBaseElementDataset
implements BarDataset {
    private static final long serialVersionUID = 1L;
    private List<BarSeries> seriesList;

    public CompiledBarDataset(BarDataset dataset, JRBaseObjectFactory factory) {
        super((JRElementDataset)dataset, factory);
        List<BarSeries> series = dataset.getSeries();
        this.seriesList = new ArrayList<BarSeries>(series.size());
        for (BarSeries barSeries : series) {
            DefaultBarSeries compiledSeries = new DefaultBarSeries();
            compiledSeries.setSeriesExpression(factory.getExpression(barSeries.getSeriesExpression()));
            compiledSeries.setCategoryExpression(factory.getExpression(barSeries.getCategoryExpression()));
            compiledSeries.setValueExpression(factory.getExpression(barSeries.getValueExpression()));
            this.seriesList.add(compiledSeries);
        }
    }

    public void collectExpressions(JRExpressionCollector collector) {
        BarChartCompiler.collectExpressions(this, collector);
    }

    @Override
    public List<BarSeries> getSeries() {
        return this.seriesList;
    }
}

