/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.sample.ofc;

import com.jaspersoft.sample.ofc.BarChartXmlFactory;
import com.jaspersoft.sample.ofc.BarDataset;
import com.jaspersoft.sample.ofc.BarSeries;
import com.jaspersoft.sample.ofc.DefaultBarSeries;
import com.jaspersoft.sample.ofc.DesignBarDataset;
import com.jaspersoft.sample.ofc.DesignPieDataset;
import com.jaspersoft.sample.ofc.PieChartXmlFactory;
import com.jaspersoft.sample.ofc.PieDataset;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.component.XmlDigesterConfigurer;
import net.sf.jasperreports.engine.xml.JRExpressionFactory;
import org.apache.commons.digester.Digester;

public class ChartsDigester
implements XmlDigesterConfigurer {
    public void configureDigester(Digester digester) {
        this.setPieChartRules(digester);
        this.setBarChartRules(digester);
    }

    protected void setBarChartRules(Digester digester) {
        String barChartPattern = "*/componentElement/barChart";
        digester.addFactoryCreate(barChartPattern, BarChartXmlFactory.class.getName());
        String titleExpressionPattern = String.valueOf(barChartPattern) + "/titleExpression";
        digester.addFactoryCreate(titleExpressionPattern, JRExpressionFactory.StringExpressionFactory.class.getName());
        digester.addCallMethod(titleExpressionPattern, "setText", 0);
        digester.addSetNext(titleExpressionPattern, "setTitleExpression", JRExpression.class.getName());
        String barDatasetPattern = String.valueOf(barChartPattern) + "/barDataset";
        digester.addObjectCreate(barDatasetPattern, DesignBarDataset.class.getName());
        digester.addSetNext(barDatasetPattern, "setDataset", BarDataset.class.getName());
        String barSeriesPattern = String.valueOf(barDatasetPattern) + "/barSeries";
        digester.addObjectCreate(barSeriesPattern, DefaultBarSeries.class.getName());
        digester.addSetNext(barSeriesPattern, "addSeries", BarSeries.class.getName());
        String seriesExpressionPattern = String.valueOf(barSeriesPattern) + "/seriesExpression";
        digester.addFactoryCreate(seriesExpressionPattern, JRExpressionFactory.StringExpressionFactory.class.getName());
        digester.addCallMethod(seriesExpressionPattern, "setText", 0);
        digester.addSetNext(seriesExpressionPattern, "setSeriesExpression", JRExpression.class.getName());
        String categoryExpressionPattern = String.valueOf(barSeriesPattern) + "/categoryExpression";
        digester.addFactoryCreate(categoryExpressionPattern, JRExpressionFactory.StringExpressionFactory.class.getName());
        digester.addCallMethod(categoryExpressionPattern, "setText", 0);
        digester.addSetNext(categoryExpressionPattern, "setCategoryExpression", JRExpression.class.getName());
        String valueExpressionPattern = String.valueOf(barSeriesPattern) + "/valueExpression";
        digester.addFactoryCreate(valueExpressionPattern, JRExpressionFactory.NumberExpressionFactory.class.getName());
        digester.addCallMethod(valueExpressionPattern, "setText", 0);
        digester.addSetNext(valueExpressionPattern, "setValueExpression", JRExpression.class.getName());
    }

    protected void setPieChartRules(Digester digester) {
        String pieChartPattern = "*/componentElement/pieChart";
        digester.addFactoryCreate(pieChartPattern, PieChartXmlFactory.class.getName());
        String pieDatasetPattern = String.valueOf(pieChartPattern) + "/pieDataset";
        digester.addObjectCreate(pieDatasetPattern, DesignPieDataset.class.getName());
        digester.addSetNext(pieDatasetPattern, "setDataset", PieDataset.class.getName());
        String keyExpressionPattern = String.valueOf(pieDatasetPattern) + "/keyExpression";
        digester.addFactoryCreate(keyExpressionPattern, JRExpressionFactory.StringExpressionFactory.class.getName());
        digester.addCallMethod(keyExpressionPattern, "setText", 0);
        digester.addSetNext(keyExpressionPattern, "setKeyExpression", JRExpression.class.getName());
        String valueExpressionPattern = String.valueOf(pieDatasetPattern) + "/valueExpression";
        digester.addFactoryCreate(valueExpressionPattern, JRExpressionFactory.NumberExpressionFactory.class.getName());
        digester.addCallMethod(valueExpressionPattern, "setText", 0);
        digester.addSetNext(valueExpressionPattern, "setValueExpression", JRExpression.class.getName());
        String titleExpressionPattern = String.valueOf(pieChartPattern) + "/titleExpression";
        digester.addFactoryCreate(titleExpressionPattern, JRExpressionFactory.StringExpressionFactory.class.getName());
        digester.addCallMethod(titleExpressionPattern, "setText", 0);
        digester.addSetNext(titleExpressionPattern, "setTitleExpression", JRExpression.class.getName());
    }
}

