/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.mondrian;

import com.tonbeller.jpivot.mondrian.MondrianMember;
import com.tonbeller.jpivot.mondrian.MondrianModel;
import com.tonbeller.jpivot.mondrian.MondrianQuax;
import com.tonbeller.jpivot.mondrian.MondrianUtil;
import com.tonbeller.jpivot.olap.model.Dimension;
import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.query.Quax;
import com.tonbeller.jpivot.olap.query.QuaxChangeListener;
import com.tonbeller.jpivot.olap.query.QueryAdapter;
import com.tonbeller.tbutils.res.Resources;
import java.util.List;
import mondrian.mdx.MemberExpr;
import mondrian.mdx.UnresolvedFunCall;
import mondrian.olap.AxisOrdinal;
import mondrian.olap.Exp;
import mondrian.olap.Query;
import mondrian.olap.SchemaReader;
import mondrian.olap.Syntax;
import org.apache.log4j.Logger;

public class MondrianQueryAdapter
extends QueryAdapter
implements QuaxChangeListener {
    static Logger logger = Logger.getLogger(MondrianQueryAdapter.class);
    Resources resources = Resources.instance(MondrianQueryAdapter.class);
    private String originalMDX;
    private Query monQuery = null;
    private Query cloneQuery = null;
    private int nAxes;
    private final SchemaReader scr;

    MondrianQueryAdapter(MondrianModel model, Query monQuery) {
        super(model);
        this.monQuery = monQuery;
        this.scr = monQuery.getSchemaReader(true);
        this.genMDXHierarchize = true;
        this.nAxes = monQuery.getAxes().length;
        this.quaxes = new MondrianQuax[this.nAxes];
        for (int i = 0; i < monQuery.getAxes().length; ++i) {
            mondrian.olap.Hierarchy[] monHiers = monQuery.getMdxHierarchiesOnAxis(AxisOrdinal.forLogicalOrdinal((int)i));
            monHiers = MondrianUtil.removeNull(monHiers);
            this.quaxes[i] = new MondrianQuax(i, monQuery.getAxes()[i], model);
            Hierarchy[] hiers = new Hierarchy[monHiers.length];
            for (int j = 0; j < hiers.length; ++j) {
                if (monHiers[j] == null) continue;
                hiers[j] = model.lookupHierarchy(monHiers[j].getUniqueName());
            }
            this.quaxes[i].setHiers(hiers);
            this.quaxes[i].addChangeListener(this);
        }
    }

    public SchemaReader getSchemaReader() {
        return this.scr;
    }

    public void quaxChanged(Quax quax, Object source, boolean changedByNavi) {
        this.useQuax = true;
    }

    public Query getMonQuery() {
        if (this.monQuery != null) {
            return this.monQuery;
        }
        try {
            logger.warn((Object)this.resources.getString("jpivot.MondrianQueryAdapter.message.parserQueryNotExpected"));
            MondrianModel mmodel = (MondrianModel)this.model;
            this.monQuery = mmodel.getConnection().parseQuery(mmodel.getMdxQuery());
        }
        catch (Exception ex) {
            logger.fatal((Object)this.resources.getString("jpivot.MondrianQueryAdapter.error.parseError"), (Throwable)ex);
        }
        return this.monQuery;
    }

    public void setMonQuery(Query q) {
        this.monQuery = q;
    }

    protected void onExecute() {
        if (this.useQuax) {
            int iQuaxToSort = -1;
            if (this.sortMan != null) {
                iQuaxToSort = this.sortMan.activeQuaxToSort();
            }
            for (int i = 0; i < this.quaxes.length; ++i) {
                if (this.quaxes[i].getPosTreeRoot() == null) continue;
                boolean doHierarchize = false;
                if (this.genMDXHierarchize && this.quaxes[i].isHierarchizeNeeded() && i != iQuaxToSort) {
                    doHierarchize = true;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)this.resources.getString("jpivot.MondrianQueryAdapter.debug.addedHierarchize"));
                    }
                }
                this.monQuery.getAxes()[this.iASwap(i)].setSet((Exp)this.quaxes[i].genExp(doHierarchize));
            }
        }
        if (this.sortMan != null) {
            if (!this.useQuax) {
                if (this.cloneQuery == null) {
                    if (this.sortMan.isSortOnQuery()) {
                        this.cloneQuery = this.monQuery.safeClone();
                    }
                } else {
                    this.monQuery = this.sortMan.isSortOnQuery() ? this.cloneQuery.safeClone() : this.cloneQuery;
                }
            }
            this.sortMan.addSortToQuery();
        }
        long t1 = System.currentTimeMillis();
        String mdx = this.monQuery.toString();
        long t2 = System.currentTimeMillis();
        if (logger.isInfoEnabled()) {
            logger.info((Object)this.resources.getString("jpivot.MondrianQueryAdapter.message.queryExecTime", new Object[]{new Long(t2 - t1)}));
        }
        ((MondrianModel)this.model).setCurrentMdx(mdx);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)mdx);
        }
    }

    protected String getCurrentMdx() {
        String mdx = this.monQuery.toString();
        return mdx;
    }

    protected Object createMemberSet(List memList) {
        Exp[] exps = new Exp[memList.size()];
        int i = 0;
        for (MondrianMember m : memList) {
            exps[i++] = new MemberExpr(m.getMonMember());
        }
        UnresolvedFunCall f = new UnresolvedFunCall("{}", Syntax.Braces, exps);
        return f;
    }

    public boolean canExpand(Member member) {
        mondrian.olap.Member monMember = ((MondrianMember)member).getMonMember();
        if (monMember.isCalculatedInQuery()) {
            return false;
        }
        if (!this.scr.isDrillable(monMember)) {
            return false;
        }
        Dimension dim = member.getLevel().getHierarchy().getDimension();
        Quax quax = this.findQuax(dim);
        return quax == null ? false : quax.canExpand(member);
    }

    public boolean canExpand(Member[] pathMembers) {
        MondrianMember m = (MondrianMember)pathMembers[pathMembers.length - 1];
        mondrian.olap.Member monMember = m.getMonMember();
        if (monMember.isCalculatedInQuery()) {
            return false;
        }
        if (!this.scr.isDrillable(monMember)) {
            return false;
        }
        Dimension dim = m.getLevel().getHierarchy().getDimension();
        Quax quax = this.findQuax(dim);
        return quax == null ? false : quax.canExpand(pathMembers);
    }

    public boolean canCollapse(Member member) {
        if (((MondrianMember)member).getMonMember().isCalculatedInQuery()) {
            return false;
        }
        Dimension dim = member.getLevel().getHierarchy().getDimension();
        Quax quax = this.findQuax(dim);
        return quax == null ? false : quax.canCollapse(member);
    }

    public boolean canCollapse(Member[] pathMembers) {
        Member member = pathMembers[pathMembers.length - 1];
        if (((MondrianMember)member).getMonMember().isCalculatedInQuery()) {
            return false;
        }
        Dimension dim = member.getLevel().getHierarchy().getDimension();
        Quax quax = this.findQuax(dim);
        return quax == null ? false : quax.canCollapse(pathMembers);
    }

    public void expand(Member member) {
        Dimension dim = member.getLevel().getHierarchy().getDimension();
        Quax quax = this.findQuax(dim);
        if (logger.isInfoEnabled()) {
            logger.info((Object)this.resources.getString("jpivot.MondrianQueryAdapter.message.expandMember", new Object[]{this.poString(null, member)}));
        }
        if (quax == null || !quax.canExpand(member)) {
            logger.fatal((Object)this.resources.getString("jpivot.MondrianQueryAdapter.error.cannotExpandMember", new Object[]{((MondrianMember)member).getUniqueName()}));
            return;
        }
        quax.expand(member);
        this.model.fireModelChanged();
    }

    public void expand(Member[] pathMembers) {
        MondrianMember m = (MondrianMember)pathMembers[pathMembers.length - 1];
        Dimension dim = m.getLevel().getHierarchy().getDimension();
        Quax quax = this.findQuax(dim);
        if (logger.isDebugEnabled()) {
            logger.info((Object)this.resources.getString("jpivot.MondrianQueryAdapter.message.expandPath", new Object[]{this.poString(pathMembers, null)}));
        }
        if (quax == null || !quax.canExpand(pathMembers)) {
            logger.fatal((Object)this.resources.getString("jpivot.MondrianQueryAdapter.error.cannotExpandPath", new Object[]{this.poString(pathMembers, null)}));
            throw new IllegalArgumentException("cannot expand");
        }
        quax.expand(pathMembers);
        this.model.fireModelChanged();
    }

    public boolean canDrillDown(Member member) {
        mondrian.olap.Member monMember = ((MondrianMember)member).getMonMember();
        if (!this.scr.isDrillable(monMember)) {
            return false;
        }
        Dimension dim = member.getLevel().getHierarchy().getDimension();
        Quax quax = this.findQuax(dim);
        return quax == null ? false : quax.canDrillDown(member);
    }

    public void setSwapAxes(boolean swap) {
        if (this.monQuery.getAxes().length != 2) {
            return;
        }
        if (swap != this.axesSwapped) {
            this.monQuery.swapAxes();
            this.axesSwapped = swap;
            if (logger.isInfoEnabled()) {
                logger.info((Object)this.resources.getString("jpivot.MondrianQueryAdapter.message.swapAxes", new Object[]{new Boolean(this.axesSwapped)}));
            }
            this.model.fireModelChanged();
        }
    }
}

