/*
// $Id: SelectionFactory.java 401 2011-02-04 00:24:40Z lucboudreau $
// This software is subject to the terms of the Eclipse Public License v1.0
// Agreement, available at the following URL:
// http://www.eclipse.org/legal/epl-v10.html.
// Copyright (C) 2007-2010 Julian Hyde
// All Rights Reserved.
// You must accept the terms of that agreement to use this software.
*/
package org.olap4j.query;

import org.olap4j.metadata.Level;
import org.olap4j.metadata.Member;

/**
 * Contains factory methods for creating implementations of {@link Selection}.
 *
 * <p>Created using {@link Query#getSelectionFactory()}.
 *
 * @author jhyde
 * @version $Id: SelectionFactory.java 401 2011-02-04 00:24:40Z lucboudreau $
 * @since May 30, 2007
 */
class SelectionFactory {

    Selection createMemberSelection(
        Member member,
        Selection.Operator operator)
    {
        return
            new MemberSelectionImpl(
                member,
                member.getDimension(),
                operator);
    }

    Selection createLevelSelection(
            Level level)
        {
            return
                new LevelSelectionImpl(
                    level,
                    level.getDimension(),
                    Selection.Operator.MEMBERS);
        }
}

// End SelectionFactory.java
