<%--
  ~ Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
  ~ http://www.jaspersoft.com.
  ~
  ~ Unless you have purchased  a commercial license agreement from Jaspersoft,
  ~ the following license terms  apply:
  ~
  ~ This program is free software: you can redistribute it and/or  modify
  ~ it under the terms of the GNU Affero General Public License  as
  ~ published by the Free Software Foundation, either version 3 of  the
  ~ License, or (at your option) any later version.
  ~
  ~ This program is distributed in the hope that it will be useful,
  ~ but WITHOUT ANY WARRANTY; without even the implied warranty of
  ~ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  ~ GNU Affero  General Public License for more details.
  ~
  ~ You should have received a copy of the GNU Affero General Public  License
  ~ along with this program. If not, see <http://www.gnu.org/licenses/>.
  --%>

<%-- Markup that is common to all or most pages --%>

<%@ include file="../jsp/modules/webHelp/webHelp.jsp" %>
<%@ include file="../jsp/modules/common/jsEdition.jsp" %>

<%--
***********************************************************************
templates (for cloning) shared by all/most JasperServer pages
***********************************************************************
--%>
<%@ include file="../jsp/templates/menu.jsp" %>
<%@ include file="../jsp/templates/list.jsp" %>
<%@ include file="../jsp/modules/common/tooltip.jsp" %>
<%@ include file="../jsp/modules/common/dnd.jsp" %>

<%--
***********************************************************************
components (not for cloning) shared by all/most JasperServer pages
***********************************************************************
--%>
<!-- save as dialog -->
<tiles:insertTemplate template="/WEB-INF/jsp/templates/saveAs.jsp">
     <tiles:putAttribute name="containerClass" value="hidden centered_vert centered_horz"/>
     <tiles:putAttribute name="bodyContent" >
        <ul class="responsive collapsible folders hideRoot" id="saveAsFoldersTree"></ul>
     </tiles:putAttribute>
</tiles:insertTemplate>

<!-- system confirm --><%-- not used? --%>
<jsp:include page="../jsp/modules/system/systemConfirm.jsp"/>

<!-- dimmer - for modal dialogs -->
<div id="pageDimmer" class="dimmer hidden"></div>

<!-- logo -->
<div id="logo"></div>

<!-- global search box -->

<t:insertTemplate template="/WEB-INF/jsp/templates/control_searchLockup.jsp">
    <t:putAttribute name="containerID" value="globalSearch"/>
    <t:putAttribute name="containerAttr" value="data-tab-index='1' data-component-type='search'"/>
    <t:putAttribute name="inputID" value="searchInput"/>
</t:insertTemplate>

<c:if test="${isProVersion}">
    <c:if test="<%= com.jaspersoft.jasperserver.api.engine.common.service.impl.NavigationActionModelSupport.getInstance().isUsersExceeded() %>">
        <t:insertTemplate template="/WEB-INF/jsp/templates/userCountExceeded.jsp">
            <t:putAttribute name="containerID" value="userCountExceeded"/>
            <t:putAttribute name="containerClass" value="userCountExceeded"/>
        </t:insertTemplate>
    </c:if>
</c:if>

<!-- about dialog -->
<jsp:include page="../jsp/modules/about/about.jsp"/>

<!-- loading cue -->
<tiles:insertTemplate template="/WEB-INF/jsp/templates/loading.jsp">
    <tiles:putAttribute name="containerID" value="loading"/>
    <tiles:putAttribute name="containerClass" value="hidden"/>
</tiles:insertTemplate>

<!-- ajax alert popup dialog -->
<t:insertTemplate template="/WEB-INF/jsp/templates/standardAlert.jsp">
    <t:putAttribute name="containerClass" value="sizeable hidden"/>
    <t:putAttribute name="bodyContent">
        <div id="errorPopupContents"></div>
    </t:putAttribute>
</t:insertTemplate>

<%--
***********************************************************************
authorization for logged in user
***********************************************************************
--%>
<ul id="metaLinks" class="horizontal">
    <li id="userID">
        <authz:authorize ifNotGranted="ROLE_ANONYMOUS">
            <span id="casted">
                <c:if test="<%= com.jaspersoft.jasperserver.api.metadata.user.service.impl.UserAuthorityServiceImpl.isUserSwitched() %>">
                    <%= ((com.jaspersoft.jasperserver.api.metadata.user.domain.User)
                          com.jaspersoft.jasperserver.api.metadata.user.service.impl.UserAuthorityServiceImpl.
                          getSourceAuthentication().getPrincipal()).getFullName() %>
                    <spring:message code="jsp.main.as"/>
                </c:if>
            </span>
            <authz:authentication property="principal.fullName"/>
        </authz:authorize>
    </li>
	<li id="help"><c:if test="${isProVersion}"><a href="#" id="helpLink"><spring:message code="decorator.helpLink"/></a></c:if></li>	
    <li id="main_logOut" class="last"><a id="main_logOut_link" href="#"><spring:message code="menu.logout"/></a></li>
</ul>

<%--
Hidden iframe for ajax downloads
--%>
<iframe id="ajax-download-iframe" style="visibility:hidden"></iframe>

<%--
Hidden iframe for ajax uploads
--%>
<iframe id="ajax-upload-iframe" style="visibility:hidden" src="about:blank" ></iframe>

<%--heat beat info--%>
<jsp:include page="../jsp/modules/heartbeat/heartbeat.jsp"/>

	
