/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.jasperserver.api.test;

import com.jaspersoft.jasperserver.api.metadata.MultiLingualInputControlsTest;
import junit.framework.Test;
import junit.framework.TestSuite;

import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.EngineServiceImplTest;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.ReportSchedulingTest;
import com.jaspersoft.jasperserver.api.metadata.OlapConnectionTest;
import com.jaspersoft.jasperserver.api.metadata.view.service.impl.AuthenticationTest;
import com.jaspersoft.jasperserver.api.metadata.view.service.impl.MetadataImplTestSuite;
import com.jaspersoft.jasperserver.util.test.ExportImportTestSuite;
import com.jaspersoft.jasperserver.util.test.SampleDataExportTest;
import com.jaspersoft.jasperserver.util.test.SampleDataImportTest;
import com.jaspersoft.jasperserver.war.themes.test.ThemeTest;

/**
 * @author swood
 *
 */
public class ImplTestSuite extends TestSuite {

    static public void main(String[] args) {
    	junit.textui.TestRunner.run(suite());
    }

    /**
     * Creates a TestSuite to run all the tests in the right order. Methods with the
     * signature <code>public static Test suite()</code> are recognized
     * automatically by JUnit test-harnesses; see {@link TestSuite}.
     */
    public static Test suite() {

        TestSuite suite = new TestSuite();

        suite.addTest(MetadataImplTestSuite.suite());
//        TODO: commented to fix build.
//        suite.addTestSuite(SearchServiceTest.class);
        suite.addTestSuite(OlapConnectionTest.class);
        suite.addTestSuite(MultiLingualInputControlsTest.class);
        suite.addTestSuite(EngineServiceImplTest.class);
        suite.addTest(ExportImportTestSuite.suite());
        suite.addTestSuite(ReportSchedulingTest.class);
        suite.addTestSuite(AuthenticationTest.class);
        suite.addTestSuite(SampleDataImportTest.class);
        suite.addTestSuite(SampleDataExportTest.class);
        suite.addTestSuite(ThemeTest.class);

        return suite;
    }

}
