package com.jaspersoft.jasperserver.rest.test;

import org.apache.http.client.methods.HttpDelete;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DELETETest extends RESTTest {
	
	//server 
	private static final String SAMPLE_LINKED_RESOURCE_SERVER_PATH = "/resource/datasources/JServerJNDIDS";
	
	@Before
	public void setUp() {
    	super.setUp();
    	httpReq = new HttpDelete();
     }
    
    //Successful delete
	@Test 
	public void Delete200File() throws Exception{
		putSampleImageFileResource(SAMPLE_IMAGE_FILE_SERVER_PATH);
		httpRes = executeCall(httpReq, SAMPLE_IMAGE_FILE_SERVER_PATH);
    	
    	Assert.assertTrue("basic response check did not pass", isValidResposnse());
    }
	
	//Successful delete of folder
	@Test 
	public void Delete200Folder() throws Exception{
		putSampleResource(SAMPLE_FOLDER_RD, SAMPLE_FOLDER_SERVER_PATH);
		httpRes = executeCall(httpReq, SAMPLE_FOLDER_SERVER_PATH);
    	
    	Assert.assertTrue("basic response check did not pass", isValidResposnse());
    }
	
	//returns a list of resources under the folder
	@Test 
    public void Delete200Job() throws Exception{
		httpRes = executeCall(httpReq, "/job/1"); 
    	Assert.assertTrue("basic response check did not pass", isValidResposnse());
    }
    
    //Error in case of a delete request with a resource linked to another resource (like report). the refusal should be expressed in the entity
	@Test 
	public void Delete403() throws Exception{
    	httpRes = executeCall(httpReq, SAMPLE_LINKED_RESOURCE_SERVER_PATH);
    	
    	Assert.assertTrue("basic response check did not pass", isValidResposnse(500));
    }
    
    
    //Error the server did not find the resource in the mentioned URI.
	@Test 
	public void Delete404() throws Exception{
    	httpRes = executeCall(httpReq, SAMPLE_IMAGE_FILE_SERVER_PATH);
    	Assert.assertTrue("basic response check did not pass", isValidResposnse(500));
    	
    }
}
