/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.jaspersoft.jasperserver.rest.services;

import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElementOr;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.remote.ResourceHandler;
import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.remote.services.ListService;
import com.jaspersoft.jasperserver.rest.RESTAbstractService;
import com.jaspersoft.jasperserver.rest.RESTUtils;
import com.jaspersoft.jasperserver.ws.xml.Marshaller;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import sun.misc.Perf.GetPerfAction;

/**
 * Resources REST implementation performs a list of resource starting from the uri specified.
 * Based on the parameters, this class add several filters to a list that is then passed
 * to the ListService to list the resource.
 *
 * To the client is sent a flat list of ResourceDescriptors in the tag resourceDescriptors.
 *
 * @author gtoffoli
 */
public class RESTResources extends RESTAbstractService {

    private final static Log log = LogFactory.getLog(RESTResources.class);

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServiceException {

            // Extract the uri from which list the resources...
            String uri = RESTUtils.extractRepositoryUri(req.getPathInfo());

            if (uri == null) uri = "/";


            // Extract the criteria
            String queryString = req.getParameter("q");
            String[] resourceTypes = req.getParameterValues("type");

            int limit = 0;

            if (req.getParameter("limit") != null)
            {
                try {
                    limit = Integer.parseInt(req.getParameter("limit"));
                    if (limit <0) throw new Exception();
                } catch (Throwable ex)
                {
                    RESTUtils.setStatusAndBody(HttpServletResponse.SC_BAD_REQUEST, resp, "Invalid value set for parameter limit.");
                    return;
                }
            }

            List list = new ArrayList();

            // Instance the list service
            ListService service = new ListService(context);


            // If not a search, just list the content of the specified folder...
            if(queryString == null && (resourceTypes == null || resourceTypes.length == 0))
            {
                list = service.listResources( uri, limit );
            }
            else
            {

                boolean recursive = false;
                if (req.getParameter("recursive") != null &&
                    (req.getParameter("recursive").equals("1") ||
                     req.getParameter("recursive").equalsIgnoreCase("true") ||
                     req.getParameter("recursive").equalsIgnoreCase("yes")))
                {
                    recursive = true;
                }


                //list = service.getResources(criteria, limit, resourceTypes == null ? null : Arrays.asList(resourceTypes));
                list = service.getResources(uri, queryString, resourceTypes == null ? null : Arrays.asList(resourceTypes), recursive,limit);

            }

            StringBuilder xml = new StringBuilder();

            Marshaller m = new Marshaller();
            xml.append("<resourceDescriptors>\n");
            for (Object rd : list)
            {
                // we assume the objects are actually resource descriptors...
                xml.append( m.writeResourceDescriptor((ResourceDescriptor)rd));
            }

            xml.append("</resourceDescriptors>");

            RESTUtils.setStatusAndBody(HttpServletResponse.SC_OK, resp, xml.toString() );
    }

  

}
