/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */


package com.jaspersoft.jasperserver.rest;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.OperationResult;
import com.jaspersoft.jasperserver.remote.ServicesUtils;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;
import org.springframework.security.AuthenticationManager;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.ui.WebAuthenticationDetails;
import org.springframework.security.ui.webapp.AuthenticationProcessingFilter;

/**
 * This filter allows a client to authenticate to the REST services without using the Basic HTTP
 * Authentication, which does not work well with UTF8 usernames.
 * 
 * The filter looks inside the request for an username and a password parameters:
 * AuthenticationProcessingFilter.SPRING_SECURITY_FORM_USERNAME_KEY
 * AuthenticationProcessingFilter.SPRING_SECURITY_FORM_PASSWORD_KEY
 *
 * Username could be in the form of user|organization
 *
 * @author gtoffoli
 */
public class RESTLoginAuthenticationFilter implements Filter, ApplicationContextAware  {

    private static final Log log = LogFactory.getLog(RESTLoginAuthenticationFilter.class);
    private static ApplicationContext applicationContext = null;
    private static ServicesUtils servicesUtils = null;
    
    private AuthenticationManager authenticationManager;
    private String authenticationFailureUrl;
    private String[] excludeUrls;

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain)
        throws IOException, ServletException {

    	HttpServletRequest httpRequest = (HttpServletRequest) request;
    	HttpServletResponse httpResponse = (HttpServletResponse) response;

 
        String username = request.getParameter(
                                    AuthenticationProcessingFilter.SPRING_SECURITY_FORM_USERNAME_KEY);
        String password = request.getParameter(
                        AuthenticationProcessingFilter.SPRING_SECURITY_FORM_PASSWORD_KEY);
        UsernamePasswordAuthenticationToken authRequest =
                new UsernamePasswordAuthenticationToken(username, password);
        authRequest.setDetails(new WebAuthenticationDetails(httpRequest));

        Authentication authResult;
        try {
            authResult = authenticationManager.authenticate(authRequest);
        } catch (AuthenticationException e) {
            if (log.isDebugEnabled()) {
                log.debug("User " + username + " failed to authenticate: " + e.toString());
            }


            log.warn("User " + username + " failed to authenticate: " + e.toString() + " " + e, e.getRootCause());

            SecurityContextHolder.getContext().setAuthentication(null);

            // Send an error message in the form of OperationResult...
            httpResponse.setStatus(HttpServletResponse.SC_UNAUTHORIZED);
            OperationResult or = servicesUtils.createOperationResult(1, "Invalid username " + username);
            PrintWriter pw = httpResponse.getWriter();
            pw.print("Unauthorized");
            return;
        }

        if (log.isDebugEnabled()) {
            log.debug("User " + username + " authenticated: " + authResult);
        }

        SecurityContextHolder.getContext().setAuthentication(authResult);

        chain.doFilter(request, response);
    }


    public AuthenticationManager getAuthenticationManager() {
        return authenticationManager;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setApplicationContext(ApplicationContext ac) throws BeansException {
        applicationContext = ac;
        servicesUtils = new ServicesUtils(applicationContext);
    }

    
    public void init(FilterConfig fc) throws ServletException {
    }


}

