package com.jaspersoft.jasperserver.remote.services;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.remote.AbstractService;
import com.jaspersoft.jasperserver.remote.ResourceHandler;
import com.jaspersoft.jasperserver.remote.ServiceException;
import org.springframework.context.ApplicationContext;
import org.springframework.security.AccessDeniedException;


public class PutService extends AbstractService{

    public PutService(ApplicationContext context)
    {
        super(context);
    }


    /**
     * Generic entry point to create a new resource.
     *
     * @param res_descriptor
     * @param save
     */
    public ResourceDescriptor putResource(ResourceDescriptor res_descriptor, boolean save) throws ServiceException {

        try {
            ResourceHandler handler = getManagementServices().getHandlerRegistry().getHandler(res_descriptor.getWsType());

            if (handler == null)
            {
                throw new ServiceException(ServiceException.RESOURCE_BAD_REQUEST, "The resource type is not supported by this server" );
            }
            return handler.update(res_descriptor, null, true);
        } catch (ServiceException se)
        {
            throw se;
        }
        catch (AccessDeniedException ex)
        {
            // Let's try to be as specific as possible with the errors...
            throw new ServiceException(ServiceException.FORBIDDEN, ex.getLocalizedMessage());
        }
    }


}
