/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.jasperserver.remote.services;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;

import com.jaspersoft.jasperserver.remote.AbstractService;
import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.remote.handlers.ReportUnitHandler;

import java.util.HashMap;
import java.util.Map;

import com.jaspersoft.jasperserver.ws.scheduling.Job;
import com.jaspersoft.jasperserver.ws.scheduling.JobSummary;
import org.apache.axis.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;

/**
 * Login REST service
 * The dirty job of loggin a user and sending out an error is done by the RESTLoginAuthenticationFilter.
 * This service just return a succesful login message
 * @author gtoffoli
 */
public class GetService extends AbstractService {

    private final static Log log = LogFactory.getLog(GetService.class);


    public GetService(ApplicationContext context)
    {
        super(context);
    }

    /**
     * Return a descriptor
     * Attachments, if requested, are placed inside the attachments list.
     * If the list is null, no attachment is returned.
     *
     * @throws JSException
     */
    public ResourceDescriptor getResource(String resourceURI, Map<String, Object> options) throws ServiceException
    {
        Resource resource = getManagementServices().locateResource(resourceURI);
        if (resource == null) {
            log.warn("Get: null resourceDescriptor for " + resourceURI);
            throw new ServiceException(ServiceException.RESOURCE_NOT_FOUND, getMessage("webservices.error.resourceNotFound"));
        } else {
            ResourceDescriptor rd = getManagementServices().createResourceDescriptor(resource, processDescriptorOptions(options));
            return rd;
        }
    }

    /**
     * This method add to the options map the flag OPTION_REPORT_UNIT_CONTENTS.
     * This is used to force the load method of the ReportUnit handler to provide not just the
     * basic informations about the report unit, but even the children descriptors.
     *
     * @param options
     * @return
     */
    protected Map processDescriptorOptions(Map options) {
        if (options == null) {
            options = new HashMap();
        }
        if (!options.containsKey(ReportUnitHandler.OPTION_REPORT_UNIT_CONTENTS)) {
            options.put(ReportUnitHandler.OPTION_REPORT_UNIT_CONTENTS, Boolean.TRUE);
        }
        return options;
    }

    public Job getJob(long jobId) throws ServiceException{
        try {
            return getManagementServices().getSchedulerService().getJob(jobId);
        } catch (AxisFault axisFault) {
            throw new ServiceException(ServiceException.INTERNAL_SERVER_ERROR, axisFault.getLocalizedMessage());
        }
    }

    public JobSummary[] getJobSummery(String reportURI) throws ServiceException{
        try {
            return getManagementServices().getSchedulerService().getReportJobs(reportURI);
        } catch (AxisFault axisFault) {
            throw new ServiceException(ServiceException.INTERNAL_SERVER_ERROR, axisFault.getLocalizedMessage());
        }
    }
}
