/*
 * Copyright (C) 2005 - 2011 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased  a commercial license agreement from Jaspersoft,
 * the following license terms  apply:
 *
 * This program is free software: you can redistribute it and/or  modify
 * it under the terms of the GNU Affero General Public License  as
 * published by the Free Software Foundation, either version 3 of  the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero  General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public  License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.jasperserver.irplugin.gui;
import com.jaspersoft.jasperserver.irplugin.JServer;
import com.jaspersoft.jasperserver.irplugin.RepositoryFolder;
import com.jaspersoft.jasperserver.irplugin.gui.dndobjects.FileObject;
import java.awt.datatransfer.Transferable;
import javax.swing.*;
import javax.swing.tree.*;
/**
 *
 * @author  Administrator
 */
public class ReportElementTransferHandler extends javax.swing.TransferHandler {
    
    /** Creates a new instance of TreeTransfertHandler */
    public ReportElementTransferHandler() {
        super();
    }
    
    public int getSourceActions(JComponent c) 
    {
        
        return COPY_OR_MOVE;
    }
    
    protected Transferable createTransferable(JComponent c) 
    {
        RepositoryFolder rf = getSelectedRepositoryObject(c);
        if (rf != null)
        {
            FileObject fo = new FileObject(rf);
            return new it.businesslogic.ireport.gui.dnd.TransferableObject(fo);
        }
        return new it.businesslogic.ireport.gui.dnd.TransferableObject(c);
    }
    
    protected RepositoryFolder getSelectedRepositoryObject(JComponent c)
    {
        if (c instanceof JTree)
        {
            JTree tree = (JTree)c;
            TreePath path = tree.getLeadSelectionPath();
	    DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
            
            if ( selectedNode.getUserObject() instanceof RepositoryFolder )
            {
                RepositoryFolder rf = (RepositoryFolder)selectedNode.getUserObject();
                return rf;
            }
        }
        
        return null;
    }
}
