/*
// $Id: //open/mondrian/src/main/mondrian/olap/QueryTimeoutException.java#2 $
// This software is subject to the terms of the Common Public License
// Agreement, available at the following URL:
// http://www.opensource.org/licenses/cpl.html.
// Copyright (C) 2004-2005 TONBELLER AG
// Copyright (C) 2005-2007 Julian Hyde and others
// All Rights Reserved.
// You must accept the terms of that agreement to use this software.
*/
package mondrian.olap;

/**
 * Exception which indicates that a query executed for longer than its allowed
 * time and was automatically canceled.
 *
 * @version $Id: //open/mondrian/src/main/mondrian/olap/QueryTimeoutException.java#2 $
 */
public class QueryTimeoutException extends ResultLimitExceededException {
    /**
     * Creates a QueryTimeoutException.
     *
     * @param message Localized error message
     */
    public QueryTimeoutException(String message) {
        super(message);
    }
}

// End QueryTimeoutException.java
