/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.sql;

import java.util.ArrayList;
import java.util.List;
import mondrian.olap.MondrianProperties;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.SqlConstraintUtils;
import mondrian.rolap.aggmatcher.AggStar;
import mondrian.rolap.sql.CrossJoinArg;
import mondrian.rolap.sql.SqlQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemberListCrossJoinArg
implements CrossJoinArg {
    private final List<RolapMember> members;
    private final RolapLevel level;
    private final boolean restrictMemberTypes;
    private final boolean hasCalcMembers;
    private final boolean hasNonCalcMembers;
    private final boolean hasAllMember;
    private final boolean exclude;

    private MemberListCrossJoinArg(RolapLevel level, List<RolapMember> members, boolean restrictMemberTypes, boolean hasCalcMembers, boolean hasNonCalcMembers, boolean hasAllMember, boolean exclude) {
        this.level = level;
        this.members = members;
        this.restrictMemberTypes = restrictMemberTypes;
        this.hasCalcMembers = hasCalcMembers;
        this.hasNonCalcMembers = hasNonCalcMembers;
        this.hasAllMember = hasAllMember;
        this.exclude = exclude;
    }

    private static boolean isArgSizeSupported(RolapEvaluator evaluator, int argSize) {
        boolean argSizeNotSupported = false;
        if (argSize > MondrianProperties.instance().MaxConstraints.get()) {
            argSizeNotSupported = true;
        }
        return !argSizeNotSupported;
    }

    public static CrossJoinArg create(RolapEvaluator evaluator, List<RolapMember> args, boolean restrictMemberTypes, boolean exclude) {
        if (!MemberListCrossJoinArg.isArgSizeSupported(evaluator, args.size())) {
            return null;
        }
        RolapLevel level = null;
        RolapLevel nullLevel = null;
        boolean hasCalcMembers = false;
        boolean hasNonCalcMembers = false;
        if (args.size() == 0) {
            hasNonCalcMembers = true;
        }
        boolean hasAllMember = false;
        try {
            for (RolapMember m : args) {
                if (m.isNull()) {
                    nullLevel = m.getLevel();
                    continue;
                }
                if (m.isAll()) {
                    hasAllMember = true;
                }
                if (m.isCalculated() && !m.isParentChildLeaf()) {
                    if (restrictMemberTypes) {
                        return null;
                    }
                    hasCalcMembers = true;
                } else {
                    hasNonCalcMembers = true;
                }
                if (level == null) {
                    level = m.getLevel();
                    continue;
                }
                if (level.equals(m.getLevel())) continue;
                return null;
            }
        }
        catch (ClassCastException cce) {
            return null;
        }
        if (level == null) {
            level = nullLevel;
        }
        if (level != null && !level.isSimple() && !MemberListCrossJoinArg.supportedParentChild(level, args)) {
            return null;
        }
        ArrayList<RolapMember> members = new ArrayList<RolapMember>();
        for (RolapMember m : args) {
            if (m.isNull()) continue;
            members.add(m);
        }
        return new MemberListCrossJoinArg(level, members, restrictMemberTypes, hasCalcMembers, hasNonCalcMembers, hasAllMember, exclude);
    }

    private static boolean supportedParentChild(RolapLevel level, List<RolapMember> args) {
        if (level.isParentChild()) {
            boolean allArgsLeaf = true;
            for (RolapMember rolapMember : args) {
                if (rolapMember.isParentChildLeaf()) continue;
                allArgsLeaf = false;
                break;
            }
            return allArgsLeaf;
        }
        return false;
    }

    @Override
    public RolapLevel getLevel() {
        return this.level;
    }

    @Override
    public List<RolapMember> getMembers() {
        return this.members;
    }

    @Override
    public boolean isPreferInterpreter(boolean joinArg) {
        if (joinArg) {
            return this.hasCalcMembers && !this.hasNonCalcMembers;
        }
        return true;
    }

    @Override
    public void addConstraint(SqlQuery sqlQuery, RolapCube baseCube, AggStar aggStar) {
        SqlConstraintUtils.addMemberConstraint(sqlQuery, baseCube, aggStar, this.members, this.restrictMemberTypes, true, this.exclude);
    }

    public boolean isEmptyCrossJoinArg() {
        return this.level == null && this.members.size() == 0;
    }

    public boolean hasCalcMembers() {
        return this.hasCalcMembers;
    }

    public boolean hasAllMember() {
        return this.hasAllMember;
    }

    public int hashCode() {
        int c = 12;
        for (RolapMember member : this.members) {
            c = 31 * c + member.hashCode();
        }
        if (this.restrictMemberTypes) {
            ++c;
        }
        if (this.exclude) {
            c += 7;
        }
        return c;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MemberListCrossJoinArg)) {
            return false;
        }
        MemberListCrossJoinArg that = (MemberListCrossJoinArg)obj;
        if (this.restrictMemberTypes != that.restrictMemberTypes) {
            return false;
        }
        if (this.exclude != that.exclude) {
            return false;
        }
        for (int i = 0; i < this.members.size(); ++i) {
            if (this.members.get(i) == that.members.get(i)) continue;
            return false;
        }
        return true;
    }
}

