/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.lang.reflect.Array;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import java.util.Set;
import mondrian.calc.Calc;
import mondrian.calc.DummyExp;
import mondrian.calc.ExpCompiler;
import mondrian.calc.IterCalc;
import mondrian.calc.ListCalc;
import mondrian.calc.ResultStyle;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.calc.impl.AbstractTupleIterCalc;
import mondrian.mdx.MdxVisitorImpl;
import mondrian.mdx.MemberExpr;
import mondrian.mdx.ParameterExpr;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Formula;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NativeEvaluator;
import mondrian.olap.Parameter;
import mondrian.olap.Query;
import mondrian.olap.ResultStyleException;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.MultiResolver;
import mondrian.olap.fun.ReflectiveMultiResolver;
import mondrian.olap.fun.Resolver;
import mondrian.olap.fun.SetFunDef;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;
import mondrian.rolap.RolapEvaluator;
import mondrian.util.UnsupportedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrossJoinFunDef
extends FunDefBase {
    static final ReflectiveMultiResolver Resolver = new ReflectiveMultiResolver("Crossjoin", "Crossjoin(<Set1>, <Set2>)", "Returns the cross product of two sets.", new String[]{"fxxx"}, CrossJoinFunDef.class);
    static final StarCrossJoinResolver StarResolver = new StarCrossJoinResolver();
    private static int counterTag = 0;
    private final int ctag = counterTag++;

    public CrossJoinFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    @Override
    public Type getResultType(Validator validator, Exp[] args) {
        ArrayList<MemberType> list = new ArrayList<MemberType>();
        for (Exp arg : args) {
            Type type = arg.getType();
            if (type instanceof SetType) {
                CrossJoinFunDef.addTypes(type, list);
                continue;
            }
            if (this.getName().equals("*")) {
                CrossJoinFunDef.addTypes(type, list);
                continue;
            }
            throw Util.newInternal("arg to crossjoin must be a set");
        }
        Type[] types = list.toArray(new MemberType[list.size()]);
        TupleType.checkHierarchies((MemberType[])types);
        TupleType tupleType = new TupleType(types);
        return new SetType(tupleType);
    }

    private static void addTypes(Type type, List<MemberType> list) {
        if (type instanceof SetType) {
            SetType setType = (SetType)type;
            CrossJoinFunDef.addTypes(setType.getElementType(), list);
        } else if (type instanceof TupleType) {
            TupleType tupleType = (TupleType)type;
            for (Type elementType : tupleType.elementTypes) {
                CrossJoinFunDef.addTypes(elementType, list);
            }
        } else if (type instanceof MemberType) {
            list.add((MemberType)type);
        } else {
            throw Util.newInternal("Unexpected type: " + type);
        }
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        for (ResultStyle r : compiler.getAcceptableResultStyles()) {
            switch (r) {
                case ITERABLE: 
                case ANY: {
                    return this.compileCallIterable(call, compiler);
                }
                case LIST: {
                    return this.compileCallImmutableList(call, compiler);
                }
                case MUTABLE_LIST: {
                    return this.compileCallMutableList(call, compiler);
                }
            }
        }
        throw ResultStyleException.generate(ResultStyle.ITERABLE_LIST_MUTABLELIST_ANY, compiler.getAcceptableResultStyles());
    }

    protected IterCalc compileCallIterable(ResolvedFunCall call, ExpCompiler compiler) {
        Calc calc1 = this.toIter(compiler, call.getArg(0));
        Calc calc2 = this.toIter(compiler, call.getArg(1));
        Calc[] calcs = new Calc[]{calc1, calc2};
        CrossJoinFunDef.checkIterListResultStyles(calc1);
        CrossJoinFunDef.checkIterListResultStyles(calc2);
        if (CrossJoinFunDef.isMemberType(calc1)) {
            if (CrossJoinFunDef.isMemberType(calc2)) {
                if (calc1.getResultStyle() == ResultStyle.ITERABLE) {
                    if (calc2.getResultStyle() == ResultStyle.ITERABLE) {
                        return new IterMemberIterMemberIterCalc(call, calcs);
                    }
                    return new IterMemberListMemberIterCalc(call, calcs);
                }
                if (calc2.getResultStyle() == ResultStyle.ITERABLE) {
                    return new ListMemberIterMemberIterCalc(call, calcs);
                }
                return new ListMemberListMemberIterCalc(call, calcs);
            }
            if (calc1.getResultStyle() == ResultStyle.ITERABLE) {
                if (calc2.getResultStyle() == ResultStyle.ITERABLE) {
                    return new IterMemberIterMemberArrayIterCalc(call, calcs);
                }
                return new IterMemberListMemberArrayIterCalc(call, calcs);
            }
            if (calc2.getResultStyle() == ResultStyle.ITERABLE) {
                return new ListMemberIterMemberArrayIterCalc(call, calcs);
            }
            return new ListMemberListMemberArrayIterCalc(call, calcs);
        }
        if (CrossJoinFunDef.isMemberType(calc2)) {
            if (calc1.getResultStyle() == ResultStyle.ITERABLE) {
                if (calc2.getResultStyle() == ResultStyle.ITERABLE) {
                    return new IterMemberArrayIterMemberIterCalc(call, calcs);
                }
                return new IterMemberArrayListMemberIterCalc(call, calcs);
            }
            if (calc2.getResultStyle() == ResultStyle.ITERABLE) {
                return new ListMemberArrayIterMemberIterCalc(call, calcs);
            }
            return new ListMemberArrayListMemberIterCalc(call, calcs);
        }
        if (calc1.getResultStyle() == ResultStyle.ITERABLE) {
            if (calc2.getResultStyle() == ResultStyle.ITERABLE) {
                return new IterMemberArrayIterMemberArrayIterCalc(call, calcs);
            }
            return new IterMemberArrayListMemberArrayIterCalc(call, calcs);
        }
        if (calc2.getResultStyle() == ResultStyle.ITERABLE) {
            return new ListMemberArrayIterMemberArrayIterCalc(call, calcs);
        }
        return new ListMemberArrayListMemberArrayIterCalc(call, calcs);
    }

    private Calc toIter(ExpCompiler compiler, Exp exp) {
        Type type = exp.getType();
        if (type instanceof SetType) {
            return compiler.compileAs(exp, null, ResultStyle.ITERABLE_LIST_MUTABLELIST);
        }
        if (type instanceof TupleType) {
            return new SetFunDef.ExprTupleIterCalc(new DummyExp(new SetType(type)), new Exp[]{exp}, compiler, ResultStyle.ITERABLE_LIST_MUTABLELIST);
        }
        return new SetFunDef.ExprMemberIterCalc(new DummyExp(new SetType(type)), new Exp[]{exp}, compiler, ResultStyle.ITERABLE_LIST_MUTABLELIST);
    }

    protected ListCalc compileCallImmutableList(ResolvedFunCall call, ExpCompiler compiler) {
        ListCalc listCalc1 = this.toList(compiler, call.getArg(0));
        ListCalc listCalc2 = this.toList(compiler, call.getArg(1));
        Calc[] calcs = new Calc[]{listCalc1, listCalc2};
        CrossJoinFunDef.checkListResultStyles(listCalc1);
        CrossJoinFunDef.checkListResultStyles(listCalc2);
        if (CrossJoinFunDef.isMemberType(listCalc1)) {
            if (CrossJoinFunDef.isMemberType(listCalc2)) {
                return new ImmutableListMemberListMemberListCalc(call, calcs);
            }
            return new ImmutableListMemberListMemberArrayListCalc(call, calcs);
        }
        if (CrossJoinFunDef.isMemberType(listCalc2)) {
            return new ImmutableListMemberArrayListMemberListCalc(call, calcs);
        }
        return new ImmutableListMemberArrayListMemberArrayListCalc(call, calcs);
    }

    private ListCalc toList(ExpCompiler compiler, Exp exp) {
        Type type = exp.getType();
        if (type instanceof SetType) {
            Calc calc = compiler.compileAs(exp, null, ResultStyle.LIST_MUTABLELIST);
            if (calc == null) {
                return compiler.compileList(exp, false);
            }
            return (ListCalc)calc;
        }
        return new SetFunDef.MemberSetListCalc(new DummyExp(new SetType(type)), new Exp[]{exp}, compiler, ResultStyle.LIST_MUTABLELIST);
    }

    protected ListCalc compileCallMutableList(ResolvedFunCall call, ExpCompiler compiler) {
        ListCalc listCalc1 = this.toList(compiler, call.getArg(0));
        ListCalc listCalc2 = this.toList(compiler, call.getArg(1));
        Calc[] calcs = new Calc[]{listCalc1, listCalc2};
        CrossJoinFunDef.checkListResultStyles(listCalc1);
        CrossJoinFunDef.checkListResultStyles(listCalc2);
        if (CrossJoinFunDef.isMemberType(listCalc1)) {
            if (CrossJoinFunDef.isMemberType(listCalc2)) {
                return new MutableListMemberListMemberListCalc(call, calcs);
            }
            return new MutableListMemberListMemberArrayListCalc(call, calcs);
        }
        if (CrossJoinFunDef.isMemberType(listCalc2)) {
            return new MutableListMemberArrayListMemberListCalc(call, calcs);
        }
        return new MutableListMemberArrayListMemberArrayListCalc(call, calcs);
    }

    protected List nonEmptyOptimizeList(Evaluator evaluator, List list, ResolvedFunCall call) {
        int opSize = MondrianProperties.instance().CrossJoinOptimizerSize.get();
        if (list.isEmpty()) {
            return list;
        }
        try {
            Object o = list.get(0);
            if (o instanceof Member && ((Member)o).getDimension().isHighCardinality()) {
                return list;
            }
        }
        catch (IndexOutOfBoundsException ioobe) {
            return Collections.EMPTY_LIST;
        }
        int size = list.size();
        if (size > opSize && evaluator.isNonEmpty()) {
            int missCount = evaluator.getMissCount();
            size = (list = this.nonEmptyList(evaluator, list, call)).size();
            if (size == 0) {
                return Collections.EMPTY_LIST;
            }
            int missCount2 = evaluator.getMissCount();
            int puntMissCountListSize = 1000;
            if (missCount2 > missCount && size > 1000) {
                return Collections.EMPTY_LIST;
            }
        }
        return list;
    }

    public static List<Member[]> crossJoin(List list1, List list2) {
        if (list1.isEmpty() || list2.isEmpty()) {
            return Collections.emptyList();
        }
        long size = (long)list1.size() * (long)list2.size();
        Util.checkCJResultLimit(size);
        ArrayList<Member[]> result = new ArrayList<Member[]>((int)size);
        boolean neitherSideIsTuple = true;
        int arity0 = 1;
        int arity1 = 1;
        if (list1.get(0) instanceof Member[]) {
            arity0 = ((Member[])list1.get(0)).length;
            neitherSideIsTuple = false;
        }
        if (list2.get(0) instanceof Member[]) {
            arity1 = ((Member[])list2.get(0)).length;
            neitherSideIsTuple = false;
        }
        if (neitherSideIsTuple) {
            for (Member o0 : list1) {
                for (Member o1 : list2) {
                    result.add(new Member[]{o0, o1});
                }
            }
        } else {
            Member[] row = new Member[arity0 + arity1];
            int m = list1.size();
            for (int i = 0; i < m; ++i) {
                int x = 0;
                Object o0 = list1.get(i);
                if (o0 instanceof Member) {
                    row[x++] = (Member)o0;
                } else {
                    Member[] members;
                    CrossJoinFunDef.assertTrue(o0 instanceof Member[]);
                    for (Member member : members = (Member[])o0) {
                        row[x++] = member;
                    }
                }
                int n = list2.size();
                for (int j = 0; j < n; ++j) {
                    Object o1 = list2.get(j);
                    if (o1 instanceof Member) {
                        row[x++] = (Member)o1;
                    } else {
                        Member[] members;
                        CrossJoinFunDef.assertTrue(o1 instanceof Member[]);
                        for (Member member : members = (Member[])o1) {
                            row[x++] = member;
                        }
                    }
                    result.add((Member[])row.clone());
                    x = arity0;
                }
            }
        }
        return result;
    }

    protected <T> List<T> nonEmptyList(Evaluator evaluator, List<T> list, ResolvedFunCall call) {
        String measureSetKey;
        if (list.isEmpty()) {
            return list;
        }
        ArrayList<Object> result = new ArrayList<Object>(list.size() + 2 >> 1);
        Query query = evaluator.getQuery();
        Set<Member> measureSet = Util.cast((Set)query.getEvalCache(measureSetKey = "MEASURE_SET-" + this.ctag));
        if (measureSet == null) {
            measureSet = new HashSet();
            Set<Member> queryMeasureSet = query.getMeasuresMembers();
            MeasureVisitor visitor = new MeasureVisitor(measureSet, call);
            for (Member m : queryMeasureSet) {
                if (m.isCalculated()) {
                    Exp exp = m.getExpression();
                    exp.accept(visitor);
                    continue;
                }
                measureSet.add(m);
            }
            Formula[] formula = query.getFormulas();
            if (formula != null) {
                for (Formula f : formula) {
                    f.accept(visitor);
                }
            }
            query.putEvalCache(measureSetKey, measureSet);
        }
        String allMemberListKey = "ALL_MEMBER_LIST-" + this.ctag;
        List<Member> allMemberList = Util.cast((List)query.getEvalCache(allMemberListKey));
        String nonAllMembersKey = "NON_ALL_MEMBERS-" + this.ctag;
        Member[][] nonAllMembers = (Member[][])query.getEvalCache(nonAllMembersKey);
        if (nonAllMembers == null) {
            Member[] listMembers;
            Member[] memberArray;
            Member[] evalMembers = (Member[])evaluator.getMembers().clone();
            if (list.get(0) instanceof Member[]) {
                memberArray = (Member[])list.get(0);
            } else {
                Member[] memberArray2 = new Member[1];
                memberArray = memberArray2;
                memberArray2[0] = (Member)list.get(0);
            }
            for (Member lm : listMembers = memberArray) {
                Hierarchy h = lm.getHierarchy();
                for (int i = 0; i < evalMembers.length; ++i) {
                    Member em = evalMembers[i];
                    if (em == null || !h.equals(em.getHierarchy())) continue;
                    evalMembers[i] = null;
                }
            }
            List<Member> slicerMembers = null;
            if (evaluator instanceof RolapEvaluator) {
                RolapEvaluator rev = (RolapEvaluator)evaluator;
                slicerMembers = rev.getSlicerMembers();
            }
            HashMap mapOfSlicerMembers = new HashMap();
            if (slicerMembers != null) {
                for (Member slicerMember : slicerMembers) {
                    Hierarchy hierarchy = slicerMember.getHierarchy();
                    if (!mapOfSlicerMembers.containsKey(hierarchy)) {
                        mapOfSlicerMembers.put(hierarchy, new HashSet());
                    }
                    ((Set)mapOfSlicerMembers.get(hierarchy)).add(slicerMember);
                }
            }
            SchemaReader schemaReader = evaluator.getSchemaReader();
            allMemberList = new ArrayList<Member>();
            ArrayList<Member[]> nonAllMemberList = new ArrayList<Member[]>();
            Member[] arr$ = evalMembers;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                boolean isSlicerMember;
                Member evalMember;
                Member em = evalMember = arr$[i$];
                boolean bl = isSlicerMember = slicerMembers != null && slicerMembers.contains(em);
                if (em == null || em.isMeasure()) continue;
                if (isSlicerMember && !em.isCalculated() || !isSlicerMember && em.isCalculated()) {
                    if (!isSlicerMember || ((Set)mapOfSlicerMembers.get(em.getHierarchy())).size() <= 1) continue;
                    nonAllMemberList.add(((Set)mapOfSlicerMembers.get(em.getHierarchy())).toArray(new Member[0]));
                    continue;
                }
                if (!isSlicerMember && em.isAll()) continue;
                Hierarchy h = em.getHierarchy();
                List<Member> rootMemberList = schemaReader.getHierarchyRootMembers(h);
                if (h.hasAll()) {
                    boolean found = false;
                    for (Member m : rootMemberList) {
                        if (!m.isAll()) continue;
                        allMemberList.add(m);
                        found = true;
                        break;
                    }
                    if (found) continue;
                    System.out.println("CrossJoinFunDef.nonEmptyListNEW: ERROR");
                    continue;
                }
                Member[] rootMembers = rootMemberList.toArray(new Member[rootMemberList.size()]);
                nonAllMemberList.add(rootMembers);
            }
            nonAllMembers = (Member[][])nonAllMemberList.toArray((T[])new Member[nonAllMemberList.size()][]);
            query.putEvalCache(allMemberListKey, allMemberList);
            query.putEvalCache(nonAllMembersKey, nonAllMembers);
        }
        evaluator = evaluator.push();
        evaluator.setContext(allMemberList);
        if (list.get(0) instanceof Member[]) {
            for (Member[] ms : list) {
                evaluator.setContext(ms);
                if (!CrossJoinFunDef.checkData(nonAllMembers, nonAllMembers.length - 1, measureSet, evaluator)) continue;
                result.add(ms);
            }
        } else {
            for (Member m : list) {
                evaluator.setContext(m);
                if (!CrossJoinFunDef.checkData(nonAllMembers, nonAllMembers.length - 1, measureSet, evaluator)) continue;
                result.add(m);
            }
        }
        return result;
    }

    private static boolean checkData(Member[][] nonAllMembers, int cnt, Set<Member> measureSet, Evaluator evaluator) {
        if (cnt < 0) {
            if (measureSet.isEmpty()) {
                Object value = evaluator.evaluateCurrent();
                return value != null && !(value instanceof Throwable);
            }
            boolean found = false;
            for (Member measure : measureSet) {
                evaluator.setContext(measure);
                Object value = evaluator.evaluateCurrent();
                if (value == null || value instanceof Throwable) continue;
                found = true;
            }
            return found;
        }
        boolean found = false;
        for (Member m : nonAllMembers[cnt]) {
            evaluator.setContext(m);
            if (!CrossJoinFunDef.checkData(nonAllMembers, cnt - 1, measureSet, evaluator)) continue;
            found = true;
        }
        return found;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StarCrossJoinResolver
    extends MultiResolver {
        public StarCrossJoinResolver() {
            super("*", "<Set1> * <Set2>", "Returns the cross product of two sets.", new String[]{"ixxx", "ixmx", "ixxm", "ixmm"});
        }

        @Override
        public FunDef resolve(Exp[] args, Validator validator, List<Resolver.Conversion> conversions) {
            if (validator.requiresExpression()) {
                return null;
            }
            return super.resolve(args, validator, conversions);
        }

        @Override
        protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
            return new CrossJoinFunDef(dummyFunDef);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MeasureVisitor
    extends MdxVisitorImpl {
        private final Set<Member> queryMeasureSet;
        private final ResolvedFunCallFinder finder;
        private final Set<Member> activeMeasures = new HashSet<Member>();

        MeasureVisitor(Set<Member> queryMeasureSet, ResolvedFunCall crossJoinCall) {
            this.queryMeasureSet = queryMeasureSet;
            this.finder = new ResolvedFunCallFinder(crossJoinCall);
        }

        @Override
        public Object visit(ParameterExpr parameterExpr) {
            Object value;
            Parameter parameter = parameterExpr.getParameter();
            Type type = parameter.getType();
            if (type instanceof MemberType && (value = parameter.getValue()) instanceof Member) {
                Member member = (Member)value;
                this.process(member);
            }
            return null;
        }

        @Override
        public Object visit(MemberExpr memberExpr) {
            Member member = memberExpr.getMember();
            this.process(member);
            return null;
        }

        private void process(Member member) {
            if (member.isMeasure()) {
                if (member.isCalculated()) {
                    if (this.activeMeasures.add(member)) {
                        Exp exp = member.getExpression();
                        this.finder.found = false;
                        exp.accept(this.finder);
                        if (!this.finder.found) {
                            exp.accept(this);
                        }
                        this.activeMeasures.remove(member);
                    }
                } else {
                    this.queryMeasureSet.add(member);
                }
            }
        }
    }

    private static class ResolvedFunCallFinder
    extends MdxVisitorImpl {
        private final ResolvedFunCall call;
        public boolean found;
        private final Set<Member> activeMembers = new HashSet<Member>();

        public ResolvedFunCallFinder(ResolvedFunCall call) {
            this.call = call;
            this.found = false;
        }

        public Object visit(ResolvedFunCall funCall) {
            if (funCall == this.call) {
                this.found = true;
            }
            return null;
        }

        public Object visit(MemberExpr memberExpr) {
            Member member = memberExpr.getMember();
            if (member.isCalculated() && this.activeMembers.add(member)) {
                Exp memberExp = member.getExpression();
                memberExp.accept(this);
                this.activeMembers.remove(member);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MutableListMemberArrayListMemberArrayListCalc
    extends BaseListCalc {
        MutableListMemberArrayListMemberArrayListCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs, true);
        }

        @Override
        protected List<Member[]> makeList(List _l1, List _l2) {
            List l1 = _l1;
            List l2 = _l2;
            int size1 = l1.size();
            int len1 = ((Member[])l1.get(0)).length;
            int size2 = l2.size();
            int len2 = ((Member[])l2.get(0)).length;
            int totalLen = len1 + len2;
            int arraySize = totalLen * (size1 * size2);
            ArrayList<Member> members = new ArrayList<Member>(arraySize);
            for (int i = 0; i < size1; ++i) {
                Member[] ma1 = (Member[])l1.get(i);
                for (int j = 0; j < size2; ++j) {
                    for (int k = 0; k < len1; ++k) {
                        Member m1 = ma1[k];
                        members.add(m1);
                    }
                    Member[] ma2 = (Member[])l2.get(j);
                    for (int k = 0; k < len2; ++k) {
                        Member m2 = ma2[k];
                        members.add(m2);
                    }
                }
            }
            return this.makeList(members, totalLen);
        }

        protected List<Member[]> makeList(List<Member> members, final int totalLen) {
            return new BaseMutableList(members){
                int size;
                {
                    super(x0);
                    this.size = this.members.size() / totalLen;
                }

                @Override
                public int size() {
                    return this.size;
                }

                @Override
                public Member[] get(int index) {
                    int base = totalLen * index;
                    Member[] m = new Member[totalLen];
                    for (int i = 0; i < totalLen; ++i) {
                        m[i] = (Member)this.members.get(base + i);
                    }
                    return m;
                }

                @Override
                public Member[] set(int index, Member[] element) {
                    int base = totalLen * index;
                    Member[] oldValue = new Member[totalLen];
                    for (int j = 0; j < totalLen; ++j) {
                        oldValue[j] = this.members.set(base + j, element[j]);
                    }
                    return oldValue;
                }

                @Override
                public Member[] remove(int index) {
                    int base = totalLen * index;
                    Member[] oldValue = new Member[totalLen];
                    for (int i = 0; i < totalLen; ++i) {
                        oldValue[i] = (Member)this.members.remove(base);
                    }
                    --this.size;
                    return oldValue;
                }

                @Override
                public List<Member[]> subList(int fromIndex, int toIndex) {
                    int from = totalLen * fromIndex;
                    int to = totalLen * toIndex;
                    List<Member> sublist = this.members.subList(from, to);
                    return MutableListMemberArrayListMemberArrayListCalc.this.makeList(sublist, totalLen);
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MutableListMemberArrayListMemberListCalc
    extends BaseListCalc {
        MutableListMemberArrayListMemberListCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs, true);
        }

        @Override
        protected List<Member[]> makeList(List _l1, List _l2) {
            List l1 = _l1;
            List l2 = _l2;
            int size1 = _l1.size();
            int len1 = ((Member[])l1.get(0)).length;
            int size2 = l2.size();
            int totalLen = 1 + len1;
            int arraySize = totalLen * (size1 * size2);
            Member[] members = new Member[arraySize];
            int x = 0;
            for (int i = 0; i < size1; ++i) {
                Member[] ma1 = (Member[])l1.get(i);
                int ii = i * size2;
                for (int j = 0; j < size2; ++j) {
                    for (int k = 0; k < len1; ++k) {
                        Member m1 = ma1[k];
                        members[x++] = m1;
                    }
                    Member m2 = (Member)l2.get(j);
                    members[x++] = m2;
                }
            }
            assert (x == arraySize);
            ArrayList<Member> list = new ArrayList<Member>(Arrays.asList(members));
            return this.makeList(list, totalLen);
        }

        protected List<Member[]> makeList(List<Member> members, final int totalLen) {
            return new BaseMutableList(members){
                int size;
                {
                    super(x0);
                    this.size = this.members.size() / totalLen;
                }

                @Override
                public int size() {
                    return this.size;
                }

                @Override
                public Member[] get(int index) {
                    int base = totalLen * index;
                    List memberList = this.members.subList(base, totalLen + base);
                    return memberList.toArray(new Member[totalLen]);
                }

                @Override
                public Member[] set(int index, Member[] element) {
                    int base = totalLen * index;
                    Member[] oldValue = new Member[totalLen];
                    for (int j = 0; j < totalLen; ++j) {
                        oldValue[j] = this.members.set(base + j, element[j]);
                    }
                    return oldValue;
                }

                @Override
                public Member[] remove(int index) {
                    int base = totalLen * index;
                    Member[] oldValue = new Member[totalLen];
                    for (int i = 0; i < totalLen; ++i) {
                        oldValue[i] = (Member)this.members.remove(base);
                    }
                    --this.size;
                    return oldValue;
                }

                @Override
                public List<Member[]> subList(int fromIndex, int toIndex) {
                    int from = totalLen * fromIndex;
                    int to = totalLen * toIndex;
                    List<Member> sublist = this.members.subList(from, to);
                    return MutableListMemberArrayListMemberListCalc.this.makeList(sublist, totalLen);
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MutableListMemberListMemberArrayListCalc
    extends BaseListCalc {
        MutableListMemberListMemberArrayListCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs, true);
        }

        @Override
        protected List<Member[]> makeList(List _l1, List _l2) {
            List l1 = _l1;
            List l2 = _l2;
            int size1 = l1.size();
            int size2 = l2.size();
            int len2 = ((Member[])l2.get(0)).length;
            int totalLen = 1 + len2;
            int arraySize = totalLen * (size1 * size2);
            ArrayList<Member> memberList = new ArrayList<Member>(arraySize);
            for (int i = 0; i < size1; ++i) {
                Member m1 = (Member)l1.get(i);
                for (int j = 0; j < size2; ++j) {
                    Member[] ma2 = (Member[])l2.get(j);
                    memberList.add(m1);
                    for (int k = 0; k < len2; ++k) {
                        Member m2 = ma2[k];
                        memberList.add(m2);
                    }
                }
            }
            return this.makeList(memberList, totalLen);
        }

        protected List<Member[]> makeList(List<Member> members, final int totalLen) {
            return new BaseMutableList(members){
                int size;
                {
                    super(x0);
                    this.size = this.members.size() / totalLen;
                }

                @Override
                public int size() {
                    return this.size;
                }

                @Override
                public Member[] get(int index) {
                    int base = totalLen * index;
                    Member[] ma = new Member[totalLen];
                    for (int i = 0; i < totalLen; ++i) {
                        ma[i] = (Member)this.members.get(base + i);
                    }
                    return ma;
                }

                @Override
                public Member[] set(int index, Member[] element) {
                    int base = totalLen * index;
                    Member[] oldValue = new Member[totalLen];
                    for (int i = 0; i < totalLen; ++i) {
                        oldValue[i] = this.members.set(base + i, element[i]);
                    }
                    return oldValue;
                }

                @Override
                public Member[] remove(int index) {
                    int base = totalLen * index;
                    Member[] oldValue = new Member[totalLen];
                    for (int i = 0; i < totalLen; ++i) {
                        oldValue[i] = (Member)this.members.remove(base);
                    }
                    --this.size;
                    return oldValue;
                }

                @Override
                public List<Member[]> subList(int fromIndex, int toIndex) {
                    int from = totalLen * fromIndex;
                    int to = totalLen * toIndex;
                    List<Member> sublist = this.members.subList(from, to);
                    return MutableListMemberListMemberArrayListCalc.this.makeList(sublist, totalLen);
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MutableListMemberListMemberListCalc
    extends BaseListCalc {
        MutableListMemberListMemberListCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs, true);
        }

        @Override
        protected List<Member[]> makeList(List _l1, List _l2) {
            final List l1 = _l1;
            final List l2 = _l2;
            if (l1.isEmpty() || l2.isEmpty()) {
                return Collections.emptyList();
            }
            final Iterator it1 = l1.iterator();
            final Member first = (Member)it1.next();
            if (first.getDimension().isHighCardinality()) {
                return new AbstractSequentialList<Member[]>(){

                    @Override
                    public int size() {
                        return l1.size() * l2.size();
                    }

                    @Override
                    public ListIterator<Member[]> listIterator(int index) {
                        return new ListIterator<Member[]>(){
                            private int idx = 0;
                            private Member m1;
                            private Iterator<Member> it2;
                            {
                                this.m1 = first;
                                this.it2 = l2.iterator();
                            }

                            @Override
                            public boolean hasNext() {
                                return this.it2.hasNext() || it1.hasNext();
                            }

                            @Override
                            public Member[] next() {
                                if (!this.it2.hasNext()) {
                                    this.it2 = l2.iterator();
                                    this.m1 = (Member)it1.next();
                                }
                                ++this.idx;
                                return new Member[]{this.m1, this.it2.next()};
                            }

                            @Override
                            public int nextIndex() {
                                return this.idx;
                            }

                            @Override
                            public void add(Member[] t) {
                                throw new UnsupportedOperationException();
                            }

                            @Override
                            public void set(Member[] t) {
                                throw new UnsupportedOperationException();
                            }

                            @Override
                            public boolean hasPrevious() {
                                throw new UnsupportedOperationException();
                            }

                            @Override
                            public Member[] previous() {
                                throw new UnsupportedOperationException();
                            }

                            @Override
                            public int previousIndex() {
                                throw new UnsupportedOperationException();
                            }

                            @Override
                            public void remove() {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }
                };
            }
            ArrayList<Member[]> members = new ArrayList<Member[]>(l1.size() * l2.size());
            for (Member m1 : l1) {
                for (Member m2 : l2) {
                    members.add(new Member[]{m1, m2});
                }
            }
            return members;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class BaseMutableList
    extends UnsupportedList<Member[]> {
        protected final List<Member> members;

        protected BaseMutableList(List<Member> members) {
            this.members = members;
        }

        @Override
        public abstract int size();

        @Override
        public abstract Member[] get(int var1);

        @Override
        public abstract Member[] set(int var1, Member[] var2);

        @Override
        public abstract Member[] remove(int var1);

        @Override
        public abstract List<Member[]> subList(int var1, int var2);

        @Override
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            for (int i = 0; i < size; ++i) {
                result[i] = this.get(i);
            }
            return result;
        }

        public List<Member[]> toArrayList() {
            ArrayList<Member[]> l = new ArrayList<Member[]>(this.size());
            Iterator<Member[]> i = this.iterator();
            while (i.hasNext()) {
                l.add(i.next());
            }
            return l;
        }

        @Override
        public ListIterator<Member[]> listIterator() {
            return new LocalListItr(0);
        }

        @Override
        public ListIterator<Member[]> listIterator(int index) {
            return new LocalListItr(index);
        }

        @Override
        public Iterator<Member[]> iterator() {
            return new LocalItr();
        }

        private class LocalListItr
        extends UnsupportedList.ListItr {
            public LocalListItr(int index) {
                super(BaseMutableList.this, index);
            }

            public void set(Member[] o) {
                if (this.lastRet == -1) {
                    throw new IllegalStateException();
                }
                try {
                    BaseMutableList.this.set(this.lastRet, o);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new ConcurrentModificationException();
                }
            }
        }

        private class LocalItr
        extends UnsupportedList.Itr {
            public LocalItr() {
                super(BaseMutableList.this);
            }

            public void remove() {
                if (this.lastRet == -1) {
                    throw new IllegalStateException();
                }
                try {
                    BaseMutableList.this.remove(this.lastRet);
                    if (this.lastRet < this.cursor) {
                        --this.cursor;
                    }
                    this.lastRet = -1;
                }
                catch (IndexOutOfBoundsException e) {
                    throw new ConcurrentModificationException();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ImmutableListMemberArrayListMemberArrayListCalc
    extends BaseListCalc {
        ImmutableListMemberArrayListMemberArrayListCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs, false);
        }

        @Override
        protected List<Member[]> makeList(final List l1, final List l2) {
            final int len1 = ((Member[])l1.get(0)).length;
            final int len2 = ((Member[])l2.get(0)).length;
            final int size = l1.size() * l2.size();
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class Outer
            extends BaseImmutableList {
                Outer() {
                }

                @Override
                public int size() {
                    return size;
                }

                @Override
                public Member[] get(int index) {
                    int i = index / l2.size();
                    int j = index % l2.size();
                    Member[] ma = new Member[len1 + len2];
                    Member[] ma1 = (Member[])l1.get(i);
                    Member[] ma2 = (Member[])l2.get(j);
                    System.arraycopy(ma1, 0, ma, 0, len1);
                    System.arraycopy(ma2, 0, ma, len1, len2);
                    return ma;
                }

                @Override
                public List<Member[]> subList(int fromIndex, int toIndex) {
                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    class Inner
                    extends Outer {
                        int fromIndex;
                        int toIndex;
                        final /* synthetic */ List val$l1;
                        final /* synthetic */ int val$len2;
                        final /* synthetic */ int val$len1;
                        final /* synthetic */ List val$l2;
                        final /* synthetic */ int val$size;

                        Inner(int fromIndex, int toIndex) {
                            this.val$l1 = list;
                            this.val$len2 = n;
                            this.val$len1 = n2;
                            this.val$l2 = list2;
                            this.val$size = n3;
                            super(ImmutableListMemberArrayListMemberArrayListCalc.this, n3, list2, n2, n, list);
                            this.fromIndex = fromIndex;
                            this.toIndex = toIndex;
                        }

                        @Override
                        public int size() {
                            return this.toIndex - this.fromIndex;
                        }

                        @Override
                        public Member[] get(int index) {
                            return this.get(index + this.fromIndex);
                        }

                        @Override
                        public List<Member[]> subList(int fromIndex, int toIndex) {
                            return new Inner(this.fromIndex + fromIndex, this.fromIndex + toIndex);
                        }
                    }
                    return new Inner(fromIndex, toIndex);
                }
            }
            return new Outer();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ImmutableListMemberArrayListMemberListCalc
    extends BaseListCalc {
        ImmutableListMemberArrayListMemberListCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs, false);
        }

        @Override
        protected List<Member[]> makeList(final List l1, final List l2) {
            final int len1 = ((Member[])l1.get(0)).length;
            final int size = l1.size() * l2.size();
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class Outer
            extends BaseImmutableList {
                Outer() {
                }

                @Override
                public int size() {
                    return size;
                }

                @Override
                public Member[] get(int index) {
                    int i = index / l2.size();
                    int j = index % l2.size();
                    Member[] ma = new Member[len1 + 1];
                    Member[] ma1 = (Member[])l1.get(i);
                    Member m2 = (Member)l2.get(j);
                    System.arraycopy(ma1, 0, ma, 0, len1);
                    ma[len1] = m2;
                    return ma;
                }

                @Override
                public List<Member[]> subList(int fromIndex, int toIndex) {
                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    class Inner
                    extends Outer {
                        int fromIndex;
                        int toIndex;
                        final /* synthetic */ List val$l1;
                        final /* synthetic */ int val$len1;
                        final /* synthetic */ List val$l2;
                        final /* synthetic */ int val$size;

                        Inner(int fromIndex, int toIndex) {
                            this.val$l1 = list;
                            this.val$len1 = n;
                            this.val$l2 = list2;
                            this.val$size = n2;
                            super(ImmutableListMemberArrayListMemberListCalc.this, n2, list2, n, list);
                            this.fromIndex = fromIndex;
                            this.toIndex = toIndex;
                        }

                        @Override
                        public int size() {
                            return this.toIndex - this.fromIndex;
                        }

                        @Override
                        public Member[] get(int index) {
                            return this.get(index + this.fromIndex);
                        }

                        @Override
                        public List<Member[]> subList(int fromIndex, int toIndex) {
                            return new Inner(this.fromIndex + fromIndex, this.fromIndex + toIndex);
                        }
                    }
                    return new Inner(fromIndex, toIndex);
                }
            }
            return new Outer();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ImmutableListMemberListMemberArrayListCalc
    extends BaseListCalc {
        ImmutableListMemberListMemberArrayListCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs, false);
        }

        @Override
        protected List<Member[]> makeList(final List l1, final List l2) {
            final int len2 = ((Member[])l2.get(0)).length;
            final int size = l1.size() * l2.size();
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class Outer
            extends BaseImmutableList {
                Outer() {
                }

                @Override
                public int size() {
                    return size;
                }

                @Override
                public Member[] get(int index) {
                    int i = index / l2.size();
                    int j = index % l2.size();
                    Member[] ma = new Member[1 + len2];
                    Member m1 = (Member)l1.get(i);
                    Member[] ma2 = (Member[])l2.get(j);
                    ma[0] = m1;
                    System.arraycopy(ma2, 0, ma, 1, len2);
                    return ma;
                }

                @Override
                public List<Member[]> subList(int fromIndex, int toIndex) {
                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    class Inner
                    extends Outer {
                        int fromIndex;
                        int toIndex;
                        final /* synthetic */ List val$l1;
                        final /* synthetic */ int val$len2;
                        final /* synthetic */ List val$l2;
                        final /* synthetic */ int val$size;

                        Inner(int fromIndex, int toIndex) {
                            this.val$l1 = list;
                            this.val$len2 = n;
                            this.val$l2 = list2;
                            this.val$size = n2;
                            super(ImmutableListMemberListMemberArrayListCalc.this, n2, list2, n, list);
                            this.fromIndex = fromIndex;
                            this.toIndex = toIndex;
                        }

                        @Override
                        public int size() {
                            return this.toIndex - this.fromIndex;
                        }

                        @Override
                        public Member[] get(int index) {
                            return this.get(index + this.fromIndex);
                        }

                        @Override
                        public List<Member[]> subList(int fromIndex, int toIndex) {
                            return new Inner(this.fromIndex + fromIndex, this.fromIndex + toIndex);
                        }
                    }
                    return new Inner(fromIndex, toIndex);
                }
            }
            return new Outer();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ImmutableListMemberListMemberListCalc
    extends BaseListCalc {
        ImmutableListMemberListMemberListCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs, false);
        }

        @Override
        protected List<Member[]> makeList(final List l1, final List l2) {
            final int size = l1.size() * l2.size();
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class Outer
            extends BaseImmutableList {
                Outer() {
                }

                @Override
                public int size() {
                    return size;
                }

                @Override
                public Member[] get(int index) {
                    int i = index / l2.size();
                    int j = index % l2.size();
                    Member m1 = (Member)l1.get(i);
                    Member m2 = (Member)l2.get(j);
                    return new Member[]{m1, m2};
                }

                @Override
                public List<Member[]> subList(int fromIndex, int toIndex) {
                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    class Inner
                    extends Outer {
                        int fromIndex;
                        int toIndex;
                        final /* synthetic */ List val$l1;
                        final /* synthetic */ List val$l2;
                        final /* synthetic */ int val$size;

                        Inner(int fromIndex, int toIndex) {
                            this.val$l1 = list;
                            this.val$l2 = list2;
                            this.val$size = n;
                            super(ImmutableListMemberListMemberListCalc.this, n, list2, list);
                            this.fromIndex = fromIndex;
                            this.toIndex = toIndex;
                        }

                        @Override
                        public int size() {
                            return this.toIndex - this.fromIndex;
                        }

                        @Override
                        public Member[] get(int index) {
                            return this.get(index + this.fromIndex);
                        }

                        @Override
                        public List<Member[]> subList(int fromIndex, int toIndex) {
                            return new Inner(this.fromIndex + fromIndex, this.fromIndex + toIndex);
                        }
                    }
                    return new Inner(fromIndex, toIndex);
                }
            }
            return new Outer();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class BaseImmutableList
    extends UnsupportedList<Member[]> {
        protected BaseImmutableList() {
        }

        @Override
        public abstract int size();

        @Override
        public abstract Member[] get(int var1);

        @Override
        public Object[] toArray() {
            int size = this.size();
            Object[] result = new Object[size];
            for (int i = 0; i < size; ++i) {
                result[i] = this.get(i);
            }
            return result;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            int size = this.size();
            if (a.length < size) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
            }
            for (int i = 0; i < size; ++i) {
                a[i] = this.get(i);
            }
            if (a.length > size) {
                a[size] = null;
            }
            return a;
        }

        public List<Member[]> toArrayList() {
            ArrayList<Member[]> l = new ArrayList<Member[]>(this.size());
            Iterator<Member[]> i = this.iterator();
            while (i.hasNext()) {
                l.add(i.next());
            }
            return l;
        }

        @Override
        public ListIterator<Member[]> listIterator() {
            return new UnsupportedList.ListItr(this, 0);
        }

        @Override
        public ListIterator<Member[]> listIterator(int index) {
            return new UnsupportedList.ListItr(this, index);
        }

        @Override
        public Iterator<Member[]> iterator() {
            return new UnsupportedList.Itr(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class BaseListCalc
    extends AbstractListCalc {
        protected BaseListCalc(ResolvedFunCall call, Calc[] calcs, boolean mutable) {
            super(call, calcs, mutable);
        }

        @Override
        public List<Member[]> evaluateList(Evaluator evaluator) {
            ResolvedFunCall call = (ResolvedFunCall)this.exp;
            SchemaReader schemaReader = evaluator.getSchemaReader();
            NativeEvaluator nativeEvaluator = schemaReader.getNativeSetEvaluator(call.getFunDef(), call.getArgs(), evaluator, this);
            if (nativeEvaluator != null) {
                return (List)nativeEvaluator.execute(ResultStyle.LIST);
            }
            Calc[] calcs = this.getCalcs();
            ListCalc listCalc1 = (ListCalc)calcs[0];
            ListCalc listCalc2 = (ListCalc)calcs[1];
            Evaluator oldEval = null;
            assert ((oldEval = evaluator.push()) != null);
            List l1 = listCalc1.evaluateList(evaluator);
            assert (oldEval.equals(evaluator)) : "listCalc1 changed context";
            List l2 = listCalc2.evaluateList(evaluator);
            assert (oldEval.equals(evaluator)) : "listCalc2 changed context";
            if ((l1 = CrossJoinFunDef.this.nonEmptyOptimizeList(evaluator, l1, call)).isEmpty()) {
                return Collections.emptyList();
            }
            if ((l2 = CrossJoinFunDef.this.nonEmptyOptimizeList(evaluator, l2, call)).isEmpty()) {
                return Collections.emptyList();
            }
            return this.makeList(l1, l2);
        }

        protected abstract List<Member[]> makeList(List var1, List var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ListMemberArrayListMemberArrayIterCalc
    extends BaseMemberArrayMemberArrayIterCalc {
        ListMemberArrayListMemberArrayIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        @Override
        protected Iterable<Member[]> makeIterable(Object o1, Object o2) {
            List l1 = (List)o1;
            List l2 = (List)o2;
            if (l1 instanceof RandomAccess) {
                if (l2 instanceof RandomAccess) {
                    return this.makeListList(l1, l2);
                }
                return this.makeListIterable(l1, l2);
            }
            if (l2 instanceof RandomAccess) {
                return this.makeIterableList(l1, l2);
            }
            return this.makeIterableIterable(l1, l2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ListMemberArrayIterMemberArrayIterCalc
    extends BaseMemberArrayMemberArrayIterCalc {
        ListMemberArrayIterMemberArrayIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        @Override
        protected Iterable<Member[]> makeIterable(Object o1, Object o2) {
            List l1 = (List)o1;
            Iterable it2 = (Iterable)o2;
            if (l1 instanceof RandomAccess) {
                return this.makeListIterable(l1, it2);
            }
            return this.makeIterableIterable(l1, it2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class IterMemberArrayListMemberArrayIterCalc
    extends BaseMemberArrayMemberArrayIterCalc {
        IterMemberArrayListMemberArrayIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        @Override
        protected Iterable<Member[]> makeIterable(Object o1, Object o2) {
            Iterable it1 = (Iterable)o1;
            List l2 = (List)o2;
            if (l2 instanceof RandomAccess) {
                return this.makeIterableList(it1, l2);
            }
            return this.makeIterableIterable(it1, l2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class IterMemberArrayIterMemberArrayIterCalc
    extends BaseMemberArrayMemberArrayIterCalc {
        IterMemberArrayIterMemberArrayIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        @Override
        protected Iterable<Member[]> makeIterable(Object o1, Object o2) {
            Iterable it1 = (Iterable)o1;
            Iterable it2 = (Iterable)o2;
            return this.makeIterableIterable(it1, it2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ListMemberArrayListMemberIterCalc
    extends BaseMemberArrayMemberIterCalc {
        ListMemberArrayListMemberIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        @Override
        protected Iterable<Member[]> makeIterable(Object o1, Object o2) {
            List l1 = (List)o1;
            List l2 = (List)o2;
            if (l1 instanceof RandomAccess) {
                if (l2 instanceof RandomAccess) {
                    return this.makeListList(l1, l2);
                }
                return this.makeListIterable(l1, l2);
            }
            if (l2 instanceof RandomAccess) {
                return this.makeIterableList(l1, l2);
            }
            return this.makeIterableIterable(l1, l2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ListMemberArrayIterMemberIterCalc
    extends BaseMemberArrayMemberIterCalc {
        ListMemberArrayIterMemberIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        @Override
        protected Iterable<Member[]> makeIterable(Object o1, Object o2) {
            List l1 = (List)o1;
            Iterable it2 = Util.castToIterable(o2);
            if (l1 instanceof RandomAccess) {
                return this.makeListIterable(l1, it2);
            }
            return this.makeIterableIterable(l1, it2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class IterMemberArrayListMemberIterCalc
    extends BaseMemberArrayMemberIterCalc {
        IterMemberArrayListMemberIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        @Override
        protected Iterable<Member[]> makeIterable(Object o1, Object o2) {
            Iterable it1 = (Iterable)o1;
            List l2 = (List)o2;
            if (l2 instanceof RandomAccess) {
                return this.makeIterableList(it1, l2);
            }
            return this.makeIterableIterable(it1, l2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class IterMemberArrayIterMemberIterCalc
    extends BaseMemberArrayMemberIterCalc {
        IterMemberArrayIterMemberIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        @Override
        protected Iterable<Member[]> makeIterable(Object o1, Object o2) {
            Iterable it1 = Util.castToIterable(o1);
            Iterable it2 = Util.castToIterable(o2);
            return this.makeIterableIterable(it1, it2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ListMemberListMemberArrayIterCalc
    extends BaseMemberMemberArrayIterCalc {
        ListMemberListMemberArrayIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        @Override
        protected Iterable<Member[]> makeIterable(Object o1, Object o2) {
            List l1 = (List)o1;
            List l2 = (List)o2;
            if (l1 instanceof RandomAccess) {
                if (l2 instanceof RandomAccess) {
                    return this.makeListList(l1, l2);
                }
                return this.makeListIterable(l1, l2);
            }
            if (l2 instanceof RandomAccess) {
                return this.makeIterableList(l1, l2);
            }
            return this.makeIterableIterable(l1, l2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ListMemberIterMemberArrayIterCalc
    extends BaseMemberMemberArrayIterCalc {
        ListMemberIterMemberArrayIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        @Override
        protected Iterable<Member[]> makeIterable(Object o1, Object o2) {
            List l1 = (List)o1;
            Iterable it2 = (Iterable)o2;
            if (l1 instanceof RandomAccess) {
                return this.makeListIterable(l1, it2);
            }
            return this.makeIterableIterable(l1, it2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class IterMemberListMemberArrayIterCalc
    extends BaseMemberMemberArrayIterCalc {
        IterMemberListMemberArrayIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        @Override
        protected Iterable<Member[]> makeIterable(Object o1, Object o2) {
            Iterable it1 = Util.castToIterable(o1);
            List l2 = (List)o2;
            if (l2 instanceof RandomAccess) {
                return this.makeIterableList(it1, l2);
            }
            return this.makeIterableIterable(it1, l2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class IterMemberIterMemberArrayIterCalc
    extends BaseMemberMemberArrayIterCalc {
        IterMemberIterMemberArrayIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        @Override
        protected Iterable<Member[]> makeIterable(Object o1, Object o2) {
            Iterable it1 = Util.castToIterable(o1);
            Iterable it2 = Util.castToIterable(o2);
            return this.makeIterableIterable(it1, it2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ListMemberListMemberIterCalc
    extends BaseMemberMemberIterCalc {
        ListMemberListMemberIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        @Override
        protected Iterable<Member[]> makeIterable(Object o1, Object o2) {
            List l1 = (List)o1;
            List l2 = (List)o2;
            if (l1 instanceof RandomAccess) {
                if (l2 instanceof RandomAccess) {
                    return this.makeListList(l1, l2);
                }
                return this.makeListIterable(l1, l2);
            }
            if (l2 instanceof RandomAccess) {
                return this.makeIterableList(l1, l2);
            }
            return this.makeIterableIterable(l1, l2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ListMemberIterMemberIterCalc
    extends BaseMemberMemberIterCalc {
        ListMemberIterMemberIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        @Override
        protected Iterable<Member[]> makeIterable(Object o1, Object o2) {
            List l1 = (List)o1;
            Iterable it2 = (Iterable)o2;
            if (l1 instanceof RandomAccess) {
                return this.makeListIterable(l1, it2);
            }
            return this.makeIterableIterable(l1, it2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class IterMemberListMemberIterCalc
    extends BaseMemberMemberIterCalc {
        IterMemberListMemberIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        @Override
        protected Iterable<Member[]> makeIterable(Object o1, Object o2) {
            Iterable it1 = Util.castToIterable(o1);
            List l2 = (List)o2;
            if (l2 instanceof RandomAccess) {
                return this.makeIterableList(it1, l2);
            }
            return this.makeIterableIterable(it1, l2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class IterMemberIterMemberIterCalc
    extends BaseMemberMemberIterCalc {
        IterMemberIterMemberIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        @Override
        protected Iterable<Member[]> makeIterable(Object o1, Object o2) {
            Iterable it1 = Util.castToIterable(o1);
            Iterable it2 = Util.castToIterable(o2);
            return this.makeIterableIterable(it1, it2);
        }
    }

    abstract class BaseMemberArrayMemberArrayIterCalc
    extends BaseTupleIterCalc {
        BaseMemberArrayMemberArrayIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        protected Member[] makeNext(Object o1, Object o2) {
            Member[] ma1 = (Member[])o1;
            Member[] ma2 = (Member[])o2;
            Member[] ma = new Member[ma1.length + ma2.length];
            System.arraycopy(ma1, 0, ma, 0, ma1.length);
            System.arraycopy(ma2, 0, ma, ma1.length, ma2.length);
            return ma;
        }
    }

    abstract class BaseMemberArrayMemberIterCalc
    extends BaseTupleIterCalc {
        BaseMemberArrayMemberIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        protected Member[] makeNext(Object o1, Object o2) {
            Member[] ma1 = (Member[])o1;
            Member m2 = (Member)o2;
            Member[] ma = new Member[ma1.length + 1];
            System.arraycopy(ma1, 0, ma, 0, ma1.length);
            ma[ma1.length] = m2;
            return ma;
        }
    }

    abstract class BaseMemberMemberArrayIterCalc
    extends BaseTupleIterCalc {
        BaseMemberMemberArrayIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        protected Member[] makeNext(Object o1, Object o2) {
            Member m1 = (Member)o1;
            Member[] ma2 = (Member[])o2;
            Member[] ma = new Member[ma2.length + 1];
            ma[0] = m1;
            System.arraycopy(ma2, 0, ma, 1, ma2.length);
            return ma;
        }
    }

    abstract class BaseMemberMemberIterCalc
    extends BaseTupleIterCalc {
        BaseMemberMemberIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        protected Member[] makeNext(Object o1, Object o2) {
            return new Member[]{(Member)o1, (Member)o2};
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class BaseTupleIterCalc
    extends AbstractTupleIterCalc {
        protected BaseTupleIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        @Override
        public Iterable<Member[]> evaluateTupleIterable(Evaluator evaluator) {
            ResolvedFunCall call = (ResolvedFunCall)this.exp;
            SchemaReader schemaReader = evaluator.getSchemaReader();
            NativeEvaluator nativeEvaluator = schemaReader.getNativeSetEvaluator(call.getFunDef(), call.getArgs(), evaluator, this);
            if (nativeEvaluator != null) {
                return (Iterable)nativeEvaluator.execute(ResultStyle.ITERABLE);
            }
            Calc[] calcs = this.getCalcs();
            Calc calc1 = calcs[0];
            Calc calc2 = calcs[1];
            Evaluator oldEval = null;
            assert ((oldEval = evaluator.push()) != null);
            Object o1 = calc1.evaluate(evaluator);
            assert (oldEval.equals(evaluator)) : "calc1 changed context";
            if (o1 instanceof List) {
                List l1 = (List)o1;
                if ((l1 = CrossJoinFunDef.this.nonEmptyOptimizeList(evaluator, l1, call)).isEmpty()) {
                    return Collections.emptyList();
                }
                o1 = l1;
            }
            Object o2 = calc2.evaluate(evaluator);
            assert (oldEval.equals(evaluator)) : "calc2 changed context";
            if (o2 instanceof List) {
                List l2 = (List)o2;
                if ((l2 = CrossJoinFunDef.this.nonEmptyOptimizeList(evaluator, l2, call)).isEmpty()) {
                    return Collections.emptyList();
                }
                o2 = l2;
            }
            return this.makeIterable(o1, o2);
        }

        protected abstract Iterable<Member[]> makeIterable(Object var1, Object var2);

        protected abstract Member[] makeNext(Object var1, Object var2);

        protected Iterable<Member[]> makeIterableIterable(final Iterable it1, final Iterable it2) {
            return new Iterable<Member[]>(){

                @Override
                public Iterator<Member[]> iterator() {
                    return new Iterator<Member[]>(){
                        Iterator i1;
                        Object o1;
                        Iterator i2;
                        Object o2;
                        {
                            this.i1 = it1.iterator();
                            this.o1 = null;
                            this.i2 = it2.iterator();
                            this.o2 = null;
                        }

                        @Override
                        public boolean hasNext() {
                            if (this.o2 != null) {
                                return true;
                            }
                            if (!this.hasNextO1()) {
                                return false;
                            }
                            if (!this.hasNextO2()) {
                                this.o1 = null;
                                if (!this.hasNextO1()) {
                                    return false;
                                }
                                this.i2 = it2.iterator();
                                if (!this.hasNextO2()) {
                                    return false;
                                }
                            }
                            return true;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Member[] next() {
                            try {
                                Member[] memberArray = BaseTupleIterCalc.this.makeNext(this.o1, this.o2);
                                return memberArray;
                            }
                            finally {
                                this.o2 = null;
                            }
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException("remove");
                        }

                        private boolean hasNextO1() {
                            while (this.o1 == null) {
                                if (!this.i1.hasNext()) {
                                    return false;
                                }
                                this.o1 = this.i1.next();
                            }
                            return true;
                        }

                        private boolean hasNextO2() {
                            this.o2 = null;
                            while (this.o2 == null) {
                                if (!this.i2.hasNext()) {
                                    return false;
                                }
                                this.o2 = this.i2.next();
                            }
                            return true;
                        }
                    };
                }
            };
        }

        protected Iterable<Member[]> makeIterableList(final Iterable it1, final List l2) {
            return new Iterable<Member[]>(){

                @Override
                public Iterator<Member[]> iterator() {
                    return new Iterator<Member[]>(){
                        Iterator i1;
                        Object o1;
                        int index2;
                        Object o2;
                        {
                            this.i1 = it1.iterator();
                            this.o1 = null;
                            this.index2 = 0;
                            this.o2 = null;
                        }

                        @Override
                        public boolean hasNext() {
                            if (this.o2 != null) {
                                return true;
                            }
                            if (!this.hasNextO1()) {
                                return false;
                            }
                            if (!this.hasNextO2()) {
                                this.o1 = null;
                                if (!this.hasNextO1()) {
                                    return false;
                                }
                                this.index2 = 0;
                                if (!this.hasNextO2()) {
                                    return false;
                                }
                            }
                            return true;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Member[] next() {
                            try {
                                Member[] memberArray = BaseTupleIterCalc.this.makeNext(this.o1, this.o2);
                                return memberArray;
                            }
                            finally {
                                this.o2 = null;
                            }
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException("remove");
                        }

                        private boolean hasNextO1() {
                            while (this.o1 == null) {
                                if (!this.i1.hasNext()) {
                                    return false;
                                }
                                this.o1 = this.i1.next();
                            }
                            return true;
                        }

                        private boolean hasNextO2() {
                            this.o2 = null;
                            while (this.o2 == null) {
                                if (this.index2 == l2.size()) {
                                    return false;
                                }
                                this.o2 = l2.get(this.index2++);
                            }
                            return true;
                        }
                    };
                }
            };
        }

        protected Iterable<Member[]> makeListIterable(final List l1, final Iterable it2) {
            return new Iterable<Member[]>(){

                @Override
                public Iterator<Member[]> iterator() {
                    return new Iterator<Member[]>(){
                        int index1 = 0;
                        Object o1 = null;
                        Iterator i2;
                        Object o2;
                        {
                            this.i2 = it2.iterator();
                            this.o2 = null;
                        }

                        @Override
                        public boolean hasNext() {
                            if (this.o2 != null) {
                                return true;
                            }
                            if (!this.hasNextO1()) {
                                return false;
                            }
                            if (!this.hasNextO2()) {
                                this.o1 = null;
                                if (!this.hasNextO1()) {
                                    return false;
                                }
                                this.i2 = it2.iterator();
                                if (!this.hasNextO2()) {
                                    return false;
                                }
                            }
                            return true;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Member[] next() {
                            try {
                                Member[] memberArray = BaseTupleIterCalc.this.makeNext(this.o1, this.o2);
                                return memberArray;
                            }
                            finally {
                                this.o2 = null;
                            }
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException("remove");
                        }

                        private boolean hasNextO1() {
                            while (this.o1 == null) {
                                if (this.index1 == l1.size()) {
                                    return false;
                                }
                                this.o1 = l1.get(this.index1++);
                            }
                            return true;
                        }

                        private boolean hasNextO2() {
                            this.o2 = null;
                            while (this.o2 == null) {
                                if (!this.i2.hasNext()) {
                                    return false;
                                }
                                this.o2 = this.i2.next();
                            }
                            return true;
                        }
                    };
                }
            };
        }

        protected Iterable<Member[]> makeListList(final List l1, final List l2) {
            return new Iterable<Member[]>(){

                @Override
                public Iterator<Member[]> iterator() {
                    return new Iterator<Member[]>(){
                        int index1 = 0;
                        Object o1 = null;
                        int index2 = 0;
                        Object o2 = null;

                        @Override
                        public boolean hasNext() {
                            if (this.o2 != null) {
                                return true;
                            }
                            if (!this.hasNextO1()) {
                                return false;
                            }
                            if (!this.hasNextO2()) {
                                this.o1 = null;
                                if (!this.hasNextO1()) {
                                    return false;
                                }
                                this.index2 = 0;
                                if (!this.hasNextO2()) {
                                    return false;
                                }
                            }
                            return true;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Member[] next() {
                            try {
                                Member[] memberArray = BaseTupleIterCalc.this.makeNext(this.o1, this.o2);
                                return memberArray;
                            }
                            finally {
                                this.o2 = null;
                            }
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException("remove");
                        }

                        private boolean hasNextO1() {
                            while (this.o1 == null) {
                                if (this.index1 == l1.size()) {
                                    return false;
                                }
                                this.o1 = l1.get(this.index1++);
                            }
                            return true;
                        }

                        private boolean hasNextO2() {
                            this.o2 = null;
                            while (this.o2 == null) {
                                if (this.index2 == l2.size()) {
                                    return false;
                                }
                                this.o2 = l2.get(this.index2++);
                            }
                            return true;
                        }
                    };
                }
            };
        }
    }
}

