/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.MethodKey;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class MethodCache {
    private static MethodCache _instance = new MethodCache();
    private Map _classes = new HashMap();
    private Map _methods = new HashMap();

    public static Method get(String className, String methodName) throws ClassNotFoundException, NoSuchMethodException {
        return MethodCache.get(className, methodName, new Class[0]);
    }

    public static Method get(String className, String methodName, Class[] parameterTypes) throws ClassNotFoundException, NoSuchMethodException {
        MethodKey methodKey = new MethodKey(className, methodName, parameterTypes);
        return MethodCache.get(methodKey);
    }

    public static Method get(MethodKey methodKey) throws ClassNotFoundException, NoSuchMethodException {
        return _instance._get(methodKey);
    }

    private final Method _get(MethodKey methodKey) throws ClassNotFoundException, NoSuchMethodException {
        Method method = (Method)this._methods.get(methodKey);
        if (method == null) {
            String className = methodKey.getClassName();
            String methodName = methodKey.getMethodName();
            Class[] types = methodKey.getTypes();
            Class<?> classObj = (Class<?>)this._classes.get(className);
            if (classObj == null) {
                ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                classObj = contextClassLoader.loadClass(className);
                this._classes.put(className, classObj);
            }
            method = classObj.getMethod(methodName, types);
            this._methods.put(methodKey, method);
        }
        return method;
    }

    private MethodCache() {
    }
}

