/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.HashSet;
import java.util.Set;

public class ClassUtil {
    public static Set getClasses(File file) throws IOException {
        HashSet<String> classes = new HashSet<String>();
        StreamTokenizer st = new StreamTokenizer(new BufferedReader(new FileReader(file)));
        st.resetSyntax();
        st.slashSlashComments(true);
        st.slashStarComments(true);
        st.wordChars(97, 122);
        st.wordChars(65, 90);
        st.wordChars(46, 46);
        st.wordChars(48, 57);
        st.wordChars(95, 95);
        st.lowerCaseMode(false);
        st.eolIsSignificant(false);
        st.quoteChar(34);
        st.quoteChar(39);
        st.parseNumbers();
        while (st.nextToken() != -1) {
            if (st.ttype == -3 && (st.sval.equals("class") || st.sval.equals("interface"))) break;
        }
        while (st.nextToken() != -1) {
            if (st.ttype == -3) {
                if (!Character.isUpperCase(st.sval.charAt(0))) continue;
                if (st.sval.indexOf(46) >= 0) {
                    classes.add(st.sval.substring(0, st.sval.indexOf(46)));
                    continue;
                }
                classes.add(st.sval);
                continue;
            }
            if (st.ttype == -2 || st.ttype == 10 || !Character.isUpperCase((char)st.ttype)) continue;
            classes.add(String.valueOf((char)st.ttype));
        }
        String fileName = file.getName();
        if (fileName.endsWith(".java")) {
            fileName = fileName.substring(0, fileName.length() - 5);
        }
        classes.remove(fileName);
        return classes;
    }

    public static boolean isSubclass(Class a, Class b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        Class x = a;
        while (x != null) {
            if (x == b) {
                return true;
            }
            if (b.isInterface()) {
                Class<?>[] interfaces = x.getInterfaces();
                int i = 0;
                while (i < interfaces.length) {
                    if (ClassUtil.isSubclass(interfaces[i], b)) {
                        return true;
                    }
                    ++i;
                }
            }
            x = x.getSuperclass();
        }
        return false;
    }

    public static boolean isSubclass(Class a, String s) {
        if (a == null || s == null) {
            return false;
        }
        if (a.getName().equals(s)) {
            return true;
        }
        Class x = a;
        while (x != null) {
            if (x.getName().equals(s)) {
                return true;
            }
            Class<?>[] interfaces = x.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                if (ClassUtil.isSubclass(interfaces[i], s)) {
                    return true;
                }
                ++i;
            }
            x = x.getSuperclass();
        }
        return false;
    }
}

