/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ByteArrayMaker;
import com.liferay.portal.kernel.util.StringMaker;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Base64 {
    private static Log _log;
    static /* synthetic */ Class class$com$liferay$portal$kernel$util$Base64;

    protected static char getChar(int sixbit) {
        if (sixbit >= 0 && sixbit <= 25) {
            return (char)(65 + sixbit);
        }
        if (sixbit >= 26 && sixbit <= 51) {
            return (char)(97 + (sixbit - 26));
        }
        if (sixbit >= 52 && sixbit <= 61) {
            return (char)(48 + (sixbit - 52));
        }
        if (sixbit == 62) {
            return '+';
        }
        return sixbit != 63 ? (char)'?' : '/';
    }

    protected static int getValue(char c) {
        if (c >= 'A' && c <= 'Z') {
            return c - 65;
        }
        if (c >= 'a' && c <= 'z') {
            return c - 97 + 26;
        }
        if (c >= '0' && c <= '9') {
            return c - 48 + 52;
        }
        if (c == '+') {
            return 62;
        }
        if (c == '/') {
            return 63;
        }
        int n = 0;
        if (c != '=') {
            n = 1;
        }
        return 0 - n;
    }

    public static String encode(byte[] raw) {
        StringMaker encoded = new StringMaker();
        int i = 0;
        while (i < raw.length) {
            encoded.append(Base64.encodeBlock(raw, i));
            i += 3;
        }
        return encoded.toString();
    }

    protected static char[] encodeBlock(byte[] raw, int offset) {
        int block = 0;
        int slack = raw.length - offset - 1;
        int end = slack < 2 ? slack : 2;
        int i = 0;
        while (i <= end) {
            int b = raw[offset + i];
            int neuter = b >= 0 ? b : b + 256;
            block += neuter << 8 * (2 - i);
            ++i;
        }
        char[] base64 = new char[4];
        int i2 = 0;
        while (i2 < 4) {
            int sixbit = block >>> 6 * (3 - i2) & 0x3F;
            base64[i2] = Base64.getChar(sixbit);
            ++i2;
        }
        if (slack < 1) {
            base64[2] = 61;
        }
        if (slack < 2) {
            base64[3] = 61;
        }
        return base64;
    }

    public static byte[] decode(String base64) {
        int pad = 0;
        int i = base64.length() - 1;
        while (base64.charAt(i) == '=') {
            ++pad;
            --i;
        }
        int length = base64.length() * 6 / 8 - pad;
        byte[] raw = new byte[length];
        int rawindex = 0;
        int i2 = 0;
        while (i2 < base64.length()) {
            int block = (Base64.getValue(base64.charAt(i2)) << 18) + (Base64.getValue(base64.charAt(i2 + 1)) << 12) + (Base64.getValue(base64.charAt(i2 + 2)) << 6) + Base64.getValue(base64.charAt(i2 + 3));
            int j = 0;
            while (j < 3 && rawindex + j < raw.length) {
                raw[rawindex + j] = (byte)(block >> 8 * (2 - j) & 0xFF);
                ++j;
            }
            rawindex += 3;
            i2 += 4;
        }
        return raw;
    }

    public static String objectToString(Object o) {
        if (o == null) {
            return null;
        }
        ByteArrayMaker bam = new ByteArrayMaker(32000);
        try {
            ObjectOutputStream os = new ObjectOutputStream(new BufferedOutputStream(bam));
            os.flush();
            os.writeObject(o);
            os.flush();
        }
        catch (IOException e) {
            _log.error(e.getMessage());
        }
        return Base64.encode(bam.toByteArray());
    }

    public static Object stringToObject(String s) {
        if (s == null) {
            return null;
        }
        byte[] byteArray = Base64.decode(s);
        ByteArrayInputStream bais = new ByteArrayInputStream(byteArray);
        try {
            ObjectInputStream is = new ObjectInputStream(new BufferedInputStream(bais));
            return is.readObject();
        }
        catch (Exception e) {
            _log.error(e.getMessage());
            return null;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        Class clazz = class$com$liferay$portal$kernel$util$Base64;
        if (clazz == null) {
            clazz = class$com$liferay$portal$kernel$util$Base64 = Base64.class("[Lcom.liferay.portal.kernel.util.Base64;", false);
        }
        _log = LogFactoryUtil.getLog(clazz);
    }
}

