/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.jdbc.DrvConn;
import com.ingres.gcf.jdbc.DrvObj;
import com.ingres.gcf.jdbc.JdbcRSMD;
import com.ingres.gcf.util.DbmsConst;
import com.ingres.gcf.util.SqlEx;
import com.ingres.gcf.util.SqlLongByte;
import com.ingres.gcf.util.SqlLongChar;
import com.ingres.gcf.util.SqlLongNChar;
import com.ingres.gcf.util.SqlStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.SQLException;

class DrvLOB
extends DrvObj
implements DbmsConst,
SqlStream.StreamListener {
    protected short loc_type = (short)-1;
    protected int locator = 0;
    protected short resultType;
    protected short resultLength;
    protected long intResult;
    protected byte[] baResult;
    protected String stringResult;
    protected InputStream bsResult;
    protected Reader csResult;

    protected DrvLOB(DrvConn drvConn, short s, int n) {
        super(drvConn);
        this.loc_type = s;
        this.locator = n;
    }

    public String toString() {
        return Integer.toString(this.locator);
    }

    public short getType() {
        return this.loc_type;
    }

    public int getLocator() {
        return this.locator;
    }

    public boolean hasSameDomain(DrvLOB drvLOB) {
        return this.hasSameDomain(drvLOB.conn);
    }

    public boolean hasSameDomain(DrvConn drvConn) {
        return this.conn == drvConn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long length() throws SQLException {
        long l = -1L;
        this.msg.lock();
        try {
            this.sendQuery("select length( ~V )");
            this.startDesc((short)1);
            this.descParam();
            this.msg.done(false);
            this.msg.begin((byte)7);
            this.sendParam();
            this.msg.done(true);
            this.initResults((short)30);
            this.readResults();
            l = this.intResult;
            this.closeQuery();
        }
        finally {
            this.msg.unlock();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getBytes(long l, int n, boolean bl) throws SQLException {
        byte[] byArray = null;
        this.msg.lock();
        try {
            this.sendQuery(bl ? "select varbyte( substring( ~V from ~V for ~V ), ~V )" : "select substring( ~V from ~V for ~V )");
            this.startDesc((short)(bl ? 4 : 3));
            this.descParam();
            this.descParam((int)l);
            this.descParam(n);
            if (bl) {
                this.descParam(n);
            }
            this.msg.done(false);
            this.msg.begin((byte)7);
            this.sendParam();
            this.sendParam((int)l);
            this.sendParam(n);
            if (bl) {
                this.sendParam(n);
            }
            this.msg.done(true);
            this.initResults(bl ? (short)24 : 25);
            this.readResults();
            if (bl) {
                byArray = this.baResult;
            } else {
                byArray = SqlLongByte.strm2array(this.bsResult);
                try {
                    this.bsResult.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.readResults();
            }
            this.closeQuery();
        }
        finally {
            this.msg.unlock();
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getChars(long l, int n, boolean bl) throws SQLException {
        String string = null;
        boolean bl2 = this.loc_type == 29;
        this.msg.lock();
        try {
            if (bl) {
                this.sendQuery("select " + (bl2 ? "nvarchar" : "varchar") + "( substring( ~V from ~V for ~V ), ~V )");
            } else {
                this.sendQuery("select substring( ~V from ~V for ~V )");
            }
            this.startDesc((short)(bl ? 4 : 3));
            this.descParam();
            this.descParam((int)l);
            this.descParam(n);
            if (bl) {
                this.descParam(n);
            }
            this.msg.done(false);
            this.msg.begin((byte)7);
            this.sendParam();
            this.sendParam((int)l);
            this.sendParam(n);
            if (bl) {
                this.sendParam(n);
            }
            this.msg.done(true);
            this.initResults(bl ? (bl2 ? (short)27 : 21) : (bl2 ? (short)28 : 22));
            this.readResults();
            if (bl) {
                string = this.stringResult;
            } else {
                if (bl2) {
                    string = SqlLongNChar.strm2str(this.csResult);
                    try {
                        this.csResult.close();
                    }
                    catch (IOException iOException) {}
                } else {
                    string = SqlLongChar.strm2str(this.bsResult, this.msg.getCharSet());
                    try {
                        this.bsResult.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.readResults();
            }
            this.closeQuery();
        }
        finally {
            this.msg.unlock();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long position(byte[] byArray, long l) throws SQLException {
        long l2 = -1L;
        this.msg.lock();
        try {
            this.sendQuery("select position( ~V , ~V , ~V )");
            this.startDesc((short)3);
            this.descParam(byArray);
            this.descParam();
            this.descParam((int)l);
            this.msg.done(false);
            this.msg.begin((byte)7);
            this.sendParam(byArray);
            this.sendParam();
            this.sendParam((int)l);
            this.msg.done(true);
            this.initResults((short)30);
            this.readResults();
            l2 = this.intResult;
            this.closeQuery();
        }
        finally {
            this.msg.unlock();
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long position(String string, long l) throws SQLException {
        long l2 = -1L;
        this.msg.lock();
        try {
            this.sendQuery("select position( ~V , ~V , ~V )");
            this.startDesc((short)3);
            this.descParam(string);
            this.descParam();
            this.descParam((int)l);
            this.msg.done(false);
            this.msg.begin((byte)7);
            this.sendParam(string);
            this.sendParam();
            this.sendParam((int)l);
            this.msg.done(true);
            this.initResults((short)30);
            this.readResults();
            l2 = this.intResult;
            this.closeQuery();
        }
        finally {
            this.msg.unlock();
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long position(DrvLOB drvLOB, long l) throws SQLException {
        long l2 = -1L;
        this.msg.lock();
        try {
            this.sendQuery("select position( ~V , ~V , ~V )");
            this.startDesc((short)3);
            this.descParam(drvLOB);
            this.descParam();
            this.descParam((int)l);
            this.msg.done(false);
            this.msg.begin((byte)7);
            this.sendParam(drvLOB);
            this.sendParam();
            this.sendParam((int)l);
            this.msg.done(true);
            this.initResults((short)30);
            this.readResults();
            l2 = this.intResult;
            this.closeQuery();
        }
        finally {
            this.msg.unlock();
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long position(InputStream inputStream, long l) throws SQLException {
        long l2 = -1L;
        this.msg.lock();
        try {
            this.sendQuery("select position( ~V , ~V , ~V )");
            this.startDesc((short)3);
            this.descParam(inputStream);
            this.descParam();
            this.descParam((int)l);
            this.msg.done(false);
            this.msg.begin((byte)7);
            this.sendParam(inputStream);
            this.sendParam();
            this.sendParam((int)l);
            this.msg.done(true);
            this.initResults((short)30);
            this.readResults();
            l2 = this.intResult;
            this.closeQuery();
        }
        finally {
            this.msg.unlock();
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long position(Reader reader, long l) throws SQLException {
        long l2 = -1L;
        this.msg.lock();
        try {
            this.sendQuery("select position( ~V , ~V , ~V )");
            this.startDesc((short)3);
            this.descParam(reader);
            this.descParam();
            this.descParam((int)l);
            this.msg.done(false);
            this.msg.begin((byte)7);
            this.sendParam(reader);
            this.sendParam();
            this.sendParam((int)l);
            this.msg.done(true);
            this.initResults((short)30);
            this.readResults();
            l2 = this.intResult;
            this.closeQuery();
        }
        finally {
            this.msg.unlock();
        }
        return l2;
    }

    protected InputStream getByteStream(boolean bl) throws SqlEx {
        if (!bl) {
            return new ByteStream();
        }
        this.msg.lock();
        try {
            this.sendQuery("select ~V ");
            this.startDesc((short)1);
            this.descParam();
            this.msg.done(false);
            this.msg.begin((byte)7);
            this.sendParam();
            this.msg.done(true);
            this.initResults(this.loc_type == 36 ? (short)22 : 25);
            this.readResults();
            ((SqlStream.StreamSource)((Object)this.bsResult)).addStreamListener(this, null);
        }
        catch (SqlEx sqlEx) {
            this.msg.unlock();
            throw sqlEx;
        }
        return this.bsResult;
    }

    protected Reader getCharStream(boolean bl) throws SqlEx {
        if (!bl) {
            return new CharStream();
        }
        this.msg.lock();
        try {
            this.sendQuery("select ~V ");
            this.startDesc((short)1);
            this.descParam();
            this.msg.done(false);
            this.msg.begin((byte)7);
            this.sendParam();
            this.msg.done(true);
            this.initResults((short)28);
            this.readResults();
            ((SqlStream.StreamSource)((Object)this.csResult)).addStreamListener(this, null);
        }
        catch (SqlEx sqlEx) {
            this.msg.unlock();
            throw sqlEx;
        }
        return this.csResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamClosed(SqlStream sqlStream) {
        try {
            this.readResults();
            this.closeQuery();
        }
        catch (SqlEx sqlEx) {
            if (this.trace.enabled(1)) {
                this.trace.log("DrvBlob: error completing result processing");
                sqlEx.trace(this.trace);
            }
        }
        finally {
            this.msg.unlock();
        }
    }

    protected void sendQuery(String string) throws SqlEx {
        this.msg.begin((byte)4);
        this.msg.write((short)1);
        this.msg.write((short)6);
        this.msg.write((short)4);
        this.msg.write(10);
        this.msg.write((short)1);
        this.msg.write(string);
        this.msg.done(false);
    }

    protected void startDesc(short s) throws SqlEx {
        this.msg.begin((byte)6);
        this.msg.write(s);
    }

    protected void descParam() throws SqlEx {
        short s = 0;
        switch (this.loc_type) {
            case 35: {
                s = -4;
                break;
            }
            case 36: {
                s = -1;
                break;
            }
            case 29: {
                s = -1;
            }
        }
        this.descParam(s, this.loc_type, (short)0);
    }

    protected void descParam(DrvLOB drvLOB) throws SqlEx {
        short s = 0;
        switch (drvLOB.loc_type) {
            case 35: {
                s = -4;
                break;
            }
            case 36: {
                s = -1;
                break;
            }
            case 29: {
                s = -1;
            }
        }
        this.descParam(s, this.loc_type, (short)0);
    }

    protected void descParam(int n) throws SqlEx {
        this.descParam((short)4, (short)30, (short)4);
    }

    protected void descParam(byte[] byArray) throws SqlEx {
        int n = byArray.length;
        if (n > this.conn.max_vbyt_len) {
            this.descParam((short)-4, (short)25, (short)0);
        } else {
            this.descParam((short)-3, (short)24, (short)n);
        }
    }

    protected void descParam(String string) throws SqlEx {
        short s;
        short s2;
        boolean bl;
        int n = string.length();
        if (n > ((bl = this.loc_type == 29) ? this.conn.max_nvch_len : this.conn.max_vchr_len)) {
            s2 = -1;
            s = bl ? (short)28 : 22;
            n = 0;
        } else if (bl) {
            s2 = 12;
            s = 27;
            n *= 2;
        } else {
            s2 = 12;
            s = 21;
        }
        this.descParam(s2, s, (short)n);
    }

    protected void descParam(InputStream inputStream) throws SqlEx {
        this.descParam((short)-4, (short)25, (short)0);
    }

    protected void descParam(Reader reader) throws SqlEx {
        this.descParam((short)-1, this.loc_type == 29 ? (short)28 : 22, (short)0);
    }

    protected void descParam(short s, short s2, short s3) throws SqlEx {
        this.msg.write(s);
        this.msg.write(s2);
        this.msg.write(s3);
        this.msg.write((byte)0);
        this.msg.write((byte)0);
        this.msg.write((byte)0);
        this.msg.write((short)0);
    }

    protected void sendParam() throws SqlEx {
        this.msg.write((byte)1);
        this.msg.write(this.locator);
    }

    protected void sendParam(DrvLOB drvLOB) throws SqlEx {
        this.msg.write((byte)1);
        this.msg.write(drvLOB.locator);
    }

    protected void sendParam(int n) throws SqlEx {
        this.msg.write((byte)1);
        this.msg.write(n);
    }

    protected void sendParam(byte[] byArray) throws SqlEx {
        this.msg.write((byte)1);
        if (byArray.length > this.conn.max_vbyt_len) {
            this.msg.write(new ByteArrayInputStream(byArray));
        } else {
            this.msg.write(byArray);
        }
    }

    protected void sendParam(String string) throws SqlEx {
        boolean bl = this.loc_type == 29;
        this.msg.write((byte)1);
        if (string.length() > (bl ? this.conn.max_nvch_len : this.conn.max_vchr_len)) {
            StringReader stringReader = new StringReader(string);
            if (bl) {
                this.msg.writeUCS2(stringReader);
            } else {
                this.msg.write(stringReader);
            }
        } else if (bl) {
            this.msg.writeUCS2(string);
        } else {
            this.msg.write(string);
        }
    }

    protected void sendParam(InputStream inputStream) throws SqlEx {
        this.msg.write((byte)1);
        this.msg.write(inputStream);
    }

    protected void sendParam(Reader reader) throws SqlEx {
        this.msg.write((byte)1);
        if (this.loc_type == 29) {
            this.msg.writeUCS2(reader);
        } else {
            this.msg.write(reader);
        }
    }

    protected void closeQuery() throws SqlEx {
        if ((this.rslt_flags & 8) == 0) {
            this.msg.begin((byte)5);
            this.msg.write((short)1);
            this.msg.write((short)1);
            this.msg.write((short)8);
            this.msg.write((int)(this.rslt_val_stmt >> 32 & 0xFFFFFFFFFFFFFFFFL));
            this.msg.write((int)(this.rslt_val_stmt & 0xFFFFFFFFFFFFFFFFL));
            this.msg.done(true);
            this.readResults();
        }
    }

    protected void initResults(short s) {
        this.clearResults();
        this.resultType = s;
        this.resultLength = (short)-1;
        this.intResult = -1L;
        this.baResult = null;
        this.stringResult = null;
    }

    protected JdbcRSMD readDesc() throws SqlEx {
        short s = this.msg.readShort();
        if (s != 1) {
            throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
        }
        this.msg.readShort();
        short s2 = this.msg.readShort();
        this.resultLength = this.msg.readShort();
        this.msg.readByte();
        this.msg.readByte();
        this.msg.readByte();
        short s3 = this.msg.readShort();
        if (s3 > 0) {
            this.msg.skip(s3);
        }
        if (s2 != this.resultType) {
            throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
        }
        return null;
    }

    protected boolean readData() throws SqlEx {
        boolean bl = false;
        if (this.msg.readByte() == 0) {
            throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
        }
        block0 : switch (this.resultType) {
            case 30: {
                switch (this.resultLength) {
                    case 1: {
                        this.intResult = this.msg.readByte();
                        break block0;
                    }
                    case 2: {
                        this.intResult = this.msg.readShort();
                        break block0;
                    }
                    case 4: {
                        this.intResult = this.msg.readInt();
                        break block0;
                    }
                    case 8: {
                        this.intResult = this.msg.readLong();
                        break block0;
                    }
                }
                throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
            }
            case 24: {
                this.baResult = this.msg.readBytes();
                break;
            }
            case 21: {
                this.stringResult = this.msg.readString();
                break;
            }
            case 27: {
                this.stringResult = this.msg.readUCS2();
                break;
            }
            case 22: 
            case 25: {
                this.bsResult = this.bsResult == null ? this.msg.readByteStream() : this.msg.readByteStream(this.bsResult);
                bl = true;
                break;
            }
            case 28: {
                this.csResult = this.csResult == null ? this.msg.readUCS2Reader() : this.msg.readUCS2Reader(this.csResult);
                bl = true;
                break;
            }
            default: {
                throw SqlEx.get(ERR_GC401A_CONVERSION_ERR);
            }
        }
        return bl;
    }

    private class CharStream
    extends Reader
    implements DbmsConst {
        private int position = 1;
        private int mark = -1;
        private boolean end_of_data = false;

        private CharStream() {
        }

        public void close() throws IOException {
            if (DrvLOB.this.trace.enabled(4)) {
                DrvLOB.this.trace.write(DrvLOB.this.tr_id + ".close()");
            }
            this.mark = -1;
            this.position = -1;
            this.end_of_data = true;
        }

        public boolean markSupported() {
            return true;
        }

        public void mark(int n) throws IOException {
            if (this.position < 0) {
                throw new IOException("Stream closed");
            }
            this.mark = this.position;
        }

        public void reset() throws IOException {
            if (DrvLOB.this.trace.enabled(4)) {
                DrvLOB.this.trace.write(DrvLOB.this.tr_id + ".reset()");
            }
            if (this.position <= 0) {
                throw new IOException("Stream closed");
            }
            if (this.mark <= 0) {
                this.mark = 1;
            }
            if (DrvLOB.this.trace.enabled(5)) {
                DrvLOB.this.trace.write(DrvLOB.this.tr_id + ": position to " + this.mark);
            }
            this.position = this.mark;
            this.end_of_data = false;
        }

        public long skip(long l) throws IOException {
            if (DrvLOB.this.trace.enabled(4)) {
                DrvLOB.this.trace.write(DrvLOB.this.tr_id + ".skip(" + l + ")");
            }
            if (this.end_of_data || this.position <= 0 || l <= 0L) {
                return 0L;
            }
            if (DrvLOB.this.trace.enabled(5)) {
                DrvLOB.this.trace.write(DrvLOB.this.tr_id + ": skip " + l + " at " + this.position);
            }
            this.position = (int)((long)this.position + l);
            return l;
        }

        public int read(char[] cArray, int n, int n2) throws IOException {
            int n3 = 0;
            if (DrvLOB.this.trace.enabled(4)) {
                DrvLOB.this.trace.write(DrvLOB.this.tr_id + ".read(" + n2 + ")");
            }
            if (cArray == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n2 < 0 || n + n2 < 0 || n + n2 > cArray.length) {
                throw new IndexOutOfBoundsException();
            }
            if (this.position < 0) {
                throw new IOException("Stream closed");
            }
            if (this.end_of_data) {
                return -1;
            }
            if (n2 == 0) {
                return 0;
            }
            try {
                DrvLOB.this.msg.lock();
            }
            catch (SqlEx sqlEx) {
                throw new IOException(sqlEx.getMessage());
            }
            try {
                DrvLOB.this.sendQuery("select substring( ~V from ~V for ~V )");
                DrvLOB.this.startDesc((short)3);
                DrvLOB.this.descParam();
                DrvLOB.this.descParam(this.position);
                DrvLOB.this.descParam(n2);
                DrvLOB.this.msg.done(false);
                DrvLOB.this.msg.begin((byte)7);
                DrvLOB.this.sendParam();
                DrvLOB.this.sendParam(this.position);
                DrvLOB.this.sendParam(n2);
                DrvLOB.this.msg.done(true);
                DrvLOB.this.initResults((short)28);
                DrvLOB.this.readResults();
                n3 = DrvLOB.this.csResult.read(cArray, n, n2);
                try {
                    DrvLOB.this.csResult.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                DrvLOB.this.readResults();
                DrvLOB.this.closeQuery();
            }
            catch (SqlEx sqlEx) {
                this.close();
                throw new IOException(sqlEx.getMessage());
            }
            catch (IOException iOException) {
                this.close();
                throw iOException;
            }
            finally {
                DrvLOB.this.msg.unlock();
            }
            if (n3 <= 0) {
                n3 = -1;
                this.end_of_data = true;
            } else {
                if (DrvLOB.this.trace.enabled(5)) {
                    DrvLOB.this.trace.write(DrvLOB.this.tr_id + ": read " + n3 + " at " + this.position);
                }
                this.position += n3;
                if (n3 < n2) {
                    this.end_of_data = true;
                }
            }
            if (DrvLOB.this.trace.enabled(4)) {
                DrvLOB.this.trace.write(DrvLOB.this.tr_id + ".read: " + n3);
            }
            return n3;
        }
    }

    private class ByteStream
    extends InputStream
    implements DbmsConst {
        private int position = 1;
        private int mark = -1;
        private boolean end_of_data = false;
        private byte[] ba = new byte[1];

        private ByteStream() {
        }

        public void close() throws IOException {
            if (DrvLOB.this.trace.enabled(4)) {
                DrvLOB.this.trace.write(DrvLOB.this.tr_id + ".close()");
            }
            this.mark = -1;
            this.position = -1;
            this.end_of_data = true;
        }

        public boolean markSupported() {
            return true;
        }

        public void mark(int n) {
            this.mark = this.position;
        }

        public void reset() throws IOException {
            if (DrvLOB.this.trace.enabled(4)) {
                DrvLOB.this.trace.write(DrvLOB.this.tr_id + ".reset()");
            }
            if (this.position <= 0) {
                throw new IOException("Stream closed");
            }
            if (this.mark <= 0) {
                this.mark = 1;
            }
            if (DrvLOB.this.trace.enabled(5)) {
                DrvLOB.this.trace.write(DrvLOB.this.tr_id + ": position to " + this.mark);
            }
            this.position = this.mark;
            this.end_of_data = false;
        }

        public long skip(long l) throws IOException {
            if (DrvLOB.this.trace.enabled(4)) {
                DrvLOB.this.trace.write(DrvLOB.this.tr_id + ".skip(" + l + ")");
            }
            if (this.end_of_data || this.position <= 0 || l <= 0L) {
                return 0L;
            }
            if (DrvLOB.this.trace.enabled(5)) {
                DrvLOB.this.trace.write(DrvLOB.this.tr_id + ": skip " + l + " at " + this.position);
            }
            this.position = (int)((long)this.position + l);
            return l;
        }

        public int read() throws IOException {
            return this.read(this.ba, 0, 1) == 1 ? this.ba[0] & 0xFF : -1;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = 0;
            if (DrvLOB.this.trace.enabled(4)) {
                DrvLOB.this.trace.write(DrvLOB.this.tr_id + ".read(" + n2 + ")");
            }
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n2 < 0 || n + n2 < 0 || n + n2 > byArray.length) {
                throw new IndexOutOfBoundsException();
            }
            if (this.position < 0) {
                throw new IOException("Stream closed");
            }
            if (this.end_of_data) {
                return -1;
            }
            if (n2 == 0) {
                return 0;
            }
            try {
                DrvLOB.this.msg.lock();
            }
            catch (SqlEx sqlEx) {
                throw new IOException(sqlEx.getMessage());
            }
            try {
                DrvLOB.this.sendQuery("select substring( ~V from ~V for ~V )");
                DrvLOB.this.startDesc((short)3);
                DrvLOB.this.descParam();
                DrvLOB.this.descParam(this.position);
                DrvLOB.this.descParam(n2);
                DrvLOB.this.msg.done(false);
                DrvLOB.this.msg.begin((byte)7);
                DrvLOB.this.sendParam();
                DrvLOB.this.sendParam(this.position);
                DrvLOB.this.sendParam(n2);
                DrvLOB.this.msg.done(true);
                DrvLOB.this.initResults(DrvLOB.this.loc_type == 36 ? (short)22 : 25);
                DrvLOB.this.readResults();
                n3 = DrvLOB.this.bsResult.read(byArray, n, n2);
                try {
                    DrvLOB.this.bsResult.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                DrvLOB.this.readResults();
                DrvLOB.this.closeQuery();
            }
            catch (SqlEx sqlEx) {
                this.close();
                throw new IOException(sqlEx.getMessage());
            }
            catch (IOException iOException) {
                this.close();
                throw iOException;
            }
            finally {
                DrvLOB.this.msg.unlock();
            }
            if (n3 <= 0) {
                n3 = -1;
                this.end_of_data = true;
            } else {
                if (DrvLOB.this.trace.enabled(5)) {
                    DrvLOB.this.trace.write(DrvLOB.this.tr_id + ": read " + n3 + " at " + this.position);
                }
                this.position += n3;
                if (n3 < n2) {
                    this.end_of_data = true;
                }
            }
            if (DrvLOB.this.trace.enabled(4)) {
                DrvLOB.this.trace.write(DrvLOB.this.tr_id + ".read:" + n3);
            }
            return n3;
        }
    }
}

