/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.execution.repository.continuation;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.apache.commons.codec.binary.Base64;
import org.springframework.core.NestedRuntimeException;
import org.springframework.util.Assert;
import org.springframework.webflow.FlowException;
import org.springframework.webflow.ViewSelection;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.repository.ConversationLock;
import org.springframework.webflow.execution.repository.FlowExecutionKey;
import org.springframework.webflow.execution.repository.FlowExecutionRepositoryException;
import org.springframework.webflow.execution.repository.continuation.FlowExecutionContinuation;
import org.springframework.webflow.execution.repository.continuation.FlowExecutionContinuationFactory;
import org.springframework.webflow.execution.repository.continuation.SerializedFlowExecutionContinuationFactory;
import org.springframework.webflow.execution.repository.support.AbstractFlowExecutionRepository;
import org.springframework.webflow.execution.repository.support.FlowExecutionRepositoryServices;
import org.springframework.webflow.execution.repository.support.NoOpConversationLock;

public class ClientContinuationFlowExecutionRepository
extends AbstractFlowExecutionRepository {
    private FlowExecutionContinuationFactory continuationFactory = new SerializedFlowExecutionContinuationFactory();

    public FlowExecutionContinuationFactory getContinuationFactory() {
        return this.continuationFactory;
    }

    public void setContinuationFactory(FlowExecutionContinuationFactory continuationFactory) {
        this.continuationFactory = continuationFactory;
    }

    public ClientContinuationFlowExecutionRepository(FlowExecutionRepositoryServices repositoryServices) {
        super(repositoryServices);
    }

    public ConversationLock getLock(Serializable conversationId) {
        return NoOpConversationLock.INSTANCE;
    }

    public FlowExecutionKey generateKey(FlowExecution flowExecution) {
        return new FlowExecutionKey(this.generateId(), this.encode(this.generateId(), flowExecution));
    }

    public FlowExecutionKey generateKey(FlowExecution flowExecution, Serializable conversationId) {
        return new FlowExecutionKey(conversationId, this.encode(this.generateId(), flowExecution));
    }

    public FlowExecution getFlowExecution(FlowExecutionKey key) {
        return this.rehydrate(this.decode(key.getContinuationId()).getFlowExecution());
    }

    public void putFlowExecution(FlowExecutionKey key, FlowExecution flowExecution) {
    }

    public FlowExecutionKey getCurrentFlowExecutionKey(Serializable conversationId) throws FlowExecutionRepositoryException {
        return null;
    }

    public ViewSelection getCurrentViewSelection(Serializable conversationId) throws FlowException {
        return null;
    }

    public void setCurrentViewSelection(Serializable conversationId, ViewSelection viewSelection) throws FlowException {
    }

    public void invalidateConversation(Serializable conversationId) {
    }

    protected Serializable encode(Serializable continuationId, FlowExecution flowExecution) {
        FlowExecutionContinuation continuation = this.continuationFactory.createContinuation(continuationId, flowExecution);
        return new String(Base64.encodeBase64((byte[])continuation.toByteArray()));
    }

    protected FlowExecutionContinuation decode(Serializable data) {
        Assert.notNull((Object)data, (String)"The flow execution data to decode cannot be null");
        byte[] bytes = Base64.decodeBase64((byte[])String.valueOf(data).getBytes());
        try {
            return this.deserializeContinuation(bytes);
        }
        catch (IOException e) {
            throw new FlowExecutionContinuationDeserializationException("This should not happen", e);
        }
        catch (ClassNotFoundException e) {
            throw new FlowExecutionContinuationDeserializationException("This should not happen", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FlowExecutionContinuation deserializeContinuation(byte[] bytes) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));
        try {
            FlowExecutionContinuation flowExecutionContinuation = (FlowExecutionContinuation)ois.readObject();
            return flowExecutionContinuation;
        }
        finally {
            ois.close();
        }
    }

    private static class FlowExecutionContinuationDeserializationException
    extends NestedRuntimeException {
        public FlowExecutionContinuationDeserializationException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

