/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow;

import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.AttributeMap;
import org.springframework.webflow.Event;
import org.springframework.webflow.Flow;
import org.springframework.webflow.FlowAttributeMapper;
import org.springframework.webflow.FlowExecutionControlContext;
import org.springframework.webflow.RequestContext;
import org.springframework.webflow.State;
import org.springframework.webflow.StateException;
import org.springframework.webflow.TransitionableState;
import org.springframework.webflow.UnmodifiableAttributeMap;
import org.springframework.webflow.ViewSelection;

public class SubflowState
extends TransitionableState {
    public static final String START_STATE_PROPERTY = "startState";
    private Flow subflow;
    private FlowAttributeMapper attributeMapper;

    public SubflowState() {
    }

    public SubflowState(Flow flow, String id, Flow subflow) throws IllegalArgumentException {
        super(flow, id);
        this.setSubflow(subflow);
    }

    public void setSubflow(Flow subflow) {
        Assert.notNull((Object)subflow, (String)"A subflow state must have a subflow");
        this.subflow = subflow;
    }

    public Flow getSubflow() {
        return this.subflow;
    }

    public void setAttributeMapper(FlowAttributeMapper attributeMapper) {
        this.attributeMapper = attributeMapper;
    }

    public FlowAttributeMapper getAttributeMapper() {
        return this.attributeMapper;
    }

    protected ViewSelection doEnter(FlowExecutionControlContext context) throws StateException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Spawning subflow '" + this.getSubflow().getId() + "' within flow '" + this.getFlow().getId() + "'"));
        }
        return context.start(this.getSubflow(), this.getSubflowStartState(context), this.createSubflowInput(context));
    }

    private AttributeMap createSubflowInput(RequestContext context) {
        if (this.getAttributeMapper() != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Messaging the configured attribute mapper to map attributes down to the spawned subflow for access within the subflow");
            }
            return this.getAttributeMapper().createSubflowInput(context);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("No attribute mapper configured for this subflow state '" + this.getId() + "' -- as a result, no attributes in flow scope will be passed to the spawned subflow '" + this.subflow.getId() + "'"));
        }
        return null;
    }

    public ViewSelection onEvent(Event event, FlowExecutionControlContext context) {
        this.mapSubflowOutput(event.getAttributes(), context);
        return super.onEvent(event, context);
    }

    private void mapSubflowOutput(UnmodifiableAttributeMap subflowOutput, RequestContext context) {
        if (this.getAttributeMapper() != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Messaging the configured attribute mapper to map subflow result attributes to the resuming parent flow -- It will have access to attributes passed up by the completed subflow");
            }
            this.attributeMapper.mapSubflowOutput(subflowOutput, context);
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("No attribute mapper is configured for the resuming state '" + this.getId() + "' -- as a result, no attributes in the ending subflow scope will be passed to the resuming flow"));
        }
    }

    protected State getSubflowStartState(RequestContext context) {
        if (this.getAttributeMap().contains(START_STATE_PROPERTY)) {
            return this.getFlow().getRequiredState(this.getAttributeMap().getString(START_STATE_PROPERTY));
        }
        return null;
    }

    protected void appendToString(ToStringCreator creator) {
        creator.append("subflow", (Object)this.subflow.getId()).append("attributeMapper", (Object)this.attributeMapper);
        super.appendToString(creator);
    }
}

