/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.mdx;

import java.io.PrintWriter;
import java.util.List;
import org.olap4j.mdx.CallNode;
import org.olap4j.mdx.ParseTreeNode;
import org.olap4j.mdx.ParseTreeWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Syntax {
    Function{

        @Override
        public void unparse(String operatorName, List<ParseTreeNode> argList, ParseTreeWriter writer) {
            Syntax.unparseList(writer, argList, operatorName + "(", ", ", ")");
        }
    }
    ,
    Property{

        @Override
        public void unparse(String operatorName, List<ParseTreeNode> argList, ParseTreeWriter writer) {
            assert (argList.size() == 1);
            argList.get(0).unparse(writer);
            writer.getPrintWriter().print(".");
            writer.getPrintWriter().print(operatorName);
        }
    }
    ,
    Method{

        @Override
        public void unparse(String operatorName, List<ParseTreeNode> argList, ParseTreeWriter writer) {
            assert (argList.size() >= 1);
            argList.get(0).unparse(writer);
            PrintWriter pw = writer.getPrintWriter();
            pw.print(".");
            pw.print(operatorName);
            pw.print("(");
            for (int i = 1; i < argList.size(); ++i) {
                if (i > 1) {
                    pw.print(", ");
                }
                argList.get(i).unparse(writer);
            }
            pw.print(")");
        }
    }
    ,
    Infix{

        @Override
        public void unparse(String operatorName, List<ParseTreeNode> argList, ParseTreeWriter writer) {
            if (Syntax.needParen(argList)) {
                Syntax.unparseList(writer, argList, "(", " " + operatorName + " ", ")");
            } else {
                Syntax.unparseList(writer, argList, "", " " + operatorName + " ", "");
            }
        }
    }
    ,
    Prefix{

        @Override
        public void unparse(String operatorName, List<ParseTreeNode> argList, ParseTreeWriter writer) {
            if (Syntax.needParen(argList)) {
                Syntax.unparseList(writer, argList, "(" + operatorName + " ", null, ")");
            } else {
                Syntax.unparseList(writer, argList, operatorName + " ", null, "");
            }
        }
    }
    ,
    Postfix{

        @Override
        public void unparse(String operatorName, List<ParseTreeNode> argList, ParseTreeWriter writer) {
            if (Syntax.needParen(argList)) {
                Syntax.unparseList(writer, argList, "(", null, " " + operatorName + ")");
            } else {
                Syntax.unparseList(writer, argList, "", null, " " + operatorName);
            }
        }
    }
    ,
    Braces{

        @Override
        public void unparse(String operatorName, List<ParseTreeNode> argList, ParseTreeWriter writer) {
            Syntax.unparseList(writer, argList, "{", ", ", "}");
        }
    }
    ,
    Parentheses{

        @Override
        public void unparse(String operatorName, List<ParseTreeNode> argList, ParseTreeWriter writer) {
            Syntax.unparseList(writer, argList, "(", ", ", ")");
        }
    }
    ,
    Case{

        @Override
        public void unparse(String operatorName, List<ParseTreeNode> argList, ParseTreeWriter writer) {
            PrintWriter pw = writer.getPrintWriter();
            if (operatorName.equals("_CaseTest")) {
                pw.print("CASE");
                int j = 0;
                int clauseCount = (argList.size() - j) / 2;
                for (int i = 0; i < clauseCount; ++i) {
                    pw.print(" WHEN ");
                    argList.get(j++).unparse(writer);
                    pw.print(" THEN ");
                    argList.get(j++).unparse(writer);
                }
                if (j < argList.size()) {
                    pw.print(" ELSE ");
                    argList.get(j++).unparse(writer);
                }
                assert (j == argList.size());
                pw.print(" END");
            } else {
                assert (operatorName.equals("_CaseMatch"));
                pw.print("CASE ");
                int j = 0;
                argList.get(j++).unparse(writer);
                int clauseCount = (argList.size() - j) / 2;
                for (int i = 0; i < clauseCount; ++i) {
                    pw.print(" WHEN ");
                    argList.get(j++).unparse(writer);
                    pw.print(" THEN ");
                    argList.get(j++).unparse(writer);
                }
                if (j < argList.size()) {
                    pw.print(" ELSE ");
                    argList.get(j++).unparse(writer);
                }
                assert (j == argList.size());
                pw.print(" END");
            }
        }
    }
    ,
    Internal,
    Cast{

        @Override
        public void unparse(String operatorName, List<ParseTreeNode> argList, ParseTreeWriter writer) {
            writer.getPrintWriter().print("CAST(");
            argList.get(0).unparse(writer);
            writer.getPrintWriter().print(" AS ");
            argList.get(1).unparse(writer);
            writer.getPrintWriter().print(")");
        }
    }
    ,
    QuotedProperty,
    AmpersandQuotedProperty,
    Empty{

        @Override
        public void unparse(String operatorName, List<ParseTreeNode> argList, ParseTreeWriter writer) {
            assert (argList.size() == 0);
        }
    };


    public void unparse(String operatorName, List<ParseTreeNode> argList, ParseTreeWriter writer) {
        throw new UnsupportedOperationException();
    }

    private static boolean needParen(List<ParseTreeNode> args) {
        return args.size() != 1 || !(args.get(0) instanceof CallNode) || ((CallNode)args.get(0)).getSyntax() != Parentheses;
    }

    private static void unparseList(ParseTreeWriter writer, List<ParseTreeNode> argList, String start, String mid, String end) {
        PrintWriter pw = writer.getPrintWriter();
        pw.print(start);
        for (int i = 0; i < argList.size(); ++i) {
            if (i > 0) {
                pw.print(mid);
            }
            argList.get(i).unparse(writer);
        }
        pw.print(end);
    }
}

